/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.manager;

import jakarta.inject.Inject;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

@ExtendWith(value={MockitoExtension.class})
public class ServiceRegistryTestCase
extends AbstractMuleTestCase {
    private DefaultServiceRegistry serviceRegistry;
    private ServiceA serviceA;
    @Mock
    private ServiceProvider serviceProviderA;

    @BeforeEach
    public void before() {
        this.serviceRegistry = new DefaultServiceRegistry();
        this.serviceA = new ServiceA();
    }

    private void registerServiceA() {
        this.serviceRegistry.register((Service)this.serviceA, ServiceA.class);
    }

    @Test
    void injectRequiredServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderRequiredDependencyToServiceA serviceProviderRequiredDependencyToServiceA = new ServiceProviderRequiredDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderRequiredDependencyToServiceA);
        MatcherAssert.assertThat((Object)serviceProviderRequiredDependencyToServiceA.serviceA, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)serviceProviderRequiredDependencyToServiceA.serviceA, (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    @Test
    void injectRequiredServiceDependencyJavax() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderRequiredJavaxDependencyToServiceA serviceProviderRequiredDependencyToServiceA = new ServiceProviderRequiredJavaxDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderRequiredDependencyToServiceA);
        MatcherAssert.assertThat((Object)serviceProviderRequiredDependencyToServiceA.serviceA, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)serviceProviderRequiredDependencyToServiceA.serviceA, (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    @Test
    void missingRequiredServiceDependency() throws ServiceResolutionError {
        ServiceProviderRequiredDependencyToServiceA serviceProviderRequiredDependencyToServiceA = new ServiceProviderRequiredDependencyToServiceA();
        ServiceResolutionError thrown = (ServiceResolutionError)Assert.assertThrows(ServiceResolutionError.class, () -> this.serviceRegistry.inject((ServiceProvider)serviceProviderRequiredDependencyToServiceA));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot find a service to inject into field '" + ServiceProviderRequiredDependencyToServiceA.class.getName() + "#serviceA' of type '" + ServiceA.class.getName() + "'")));
    }

    @Test
    void injectEmptyOptionalServiceDependency() throws ServiceResolutionError {
        ServiceProviderOptionalDependencyToServiceA serviceProviderOptionalDependencyToServiceA = new ServiceProviderOptionalDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalDependencyToServiceA);
        MatcherAssert.assertThat(serviceProviderOptionalDependencyToServiceA.serviceA, (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    void injectOptionalServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderOptionalDependencyToServiceA serviceProviderOptionalDependencyToServiceA = new ServiceProviderOptionalDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalDependencyToServiceA);
        MatcherAssert.assertThat((Object)serviceProviderOptionalDependencyToServiceA.serviceA.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)serviceProviderOptionalDependencyToServiceA.serviceA.get(), (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    @Test
    void injectOptionalSetterServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderOptionalSetterDependencyToServiceA serviceProviderOptionalSetterDependencyToServiceA = new ServiceProviderOptionalSetterDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalSetterDependencyToServiceA);
        MatcherAssert.assertThat((Object)serviceProviderOptionalSetterDependencyToServiceA.serviceA.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)serviceProviderOptionalSetterDependencyToServiceA.serviceA.get(), (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    @Test
    void injectSetterServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderSetterDependencyToServiceA serviceProviderOptionalDependencyToServiceA = new ServiceProviderSetterDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalDependencyToServiceA);
        MatcherAssert.assertThat((Object)serviceProviderOptionalDependencyToServiceA.serviceA, (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    @Test
    void injectFailingSetterServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderFailingSetterDependencyToServiceA serviceProviderOptionalDependencyToServiceA = new ServiceProviderFailingSetterDependencyToServiceA();
        Assert.assertThrows(ServiceResolutionError.class, () -> this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalDependencyToServiceA));
    }

    public class ServiceA
    implements Service {
        public String getName() {
            return this.getClass().getSimpleName();
        }
    }

    public class ServiceProviderRequiredDependencyToServiceA
    implements ServiceProvider {
        @Inject
        ServiceA serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public class ServiceProviderRequiredJavaxDependencyToServiceA
    implements ServiceProvider {
        @javax.inject.Inject
        ServiceA serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public class ServiceProviderOptionalDependencyToServiceA
    implements ServiceProvider {
        @Inject
        Optional<ServiceA> serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public class ServiceProviderOptionalSetterDependencyToServiceA
    implements ServiceProvider {
        Optional<ServiceA> serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }

        @Inject
        public void setServiceA(Optional<ServiceA> serviceA) {
            this.serviceA = serviceA;
        }
    }

    public class ServiceProviderSetterDependencyToServiceA
    implements ServiceProvider {
        ServiceA serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }

        @Inject
        public void setServiceA(ServiceA serviceA) {
            this.serviceA = serviceA;
        }
    }

    public class ServiceProviderFailingSetterDependencyToServiceA
    implements ServiceProvider {
        ServiceA serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }

        @Inject
        public void setServiceA(ServiceA serviceA) {
            throw new NullPointerException("Expected");
        }
    }
}

