/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.builder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.runtime.module.artifact.builder.AbstractDependencyFileBuilder;
import org.mule.tck.ZipUtils;
import org.mule.tck.util.FileUtils;

public class ServiceFileBuilder
extends AbstractArtifactFileBuilder<ServiceFileBuilder> {
    private String serviceProviderClassName;
    private String contractClassName = null;
    private boolean unpack = false;

    public ServiceFileBuilder(String artifactId) {
        super(artifactId);
    }

    protected ServiceFileBuilder getThis() {
        return this;
    }

    public ServiceFileBuilder unpack(boolean unpack) {
        this.unpack = unpack;
        return this;
    }

    public ServiceFileBuilder withServiceProviderClass(String className) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)className) ? 1 : 0) != 0, (String)"Property value cannot be blank");
        this.serviceProviderClassName = className;
        return this;
    }

    public ServiceFileBuilder forContract(String contractClassName) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)contractClassName) ? 1 : 0) != 0, (String)"Property value cannot be blank");
        this.contractClassName = contractClassName;
        return this;
    }

    protected final List<ZipUtils.ZipResource> getCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        for (AbstractDependencyFileBuilder dependencyFileBuilder : this.getAllCompileDependencies()) {
            customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactFile().getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFileRepositoryPath()).toString()));
            customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactPomFile().getAbsolutePath(), Paths.get("repository", dependencyFileBuilder.getArtifactFilePomRepositoryPath()).toString()));
        }
        File serviceDescriptor = this.createServiceJsonDescriptorFile();
        customResources.add(new ZipUtils.ZipResource(serviceDescriptor.getAbsolutePath(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION));
        return customResources;
    }

    private File createServiceJsonDescriptorFile() {
        File serviceDescriptor = new File(this.getTempFolder(), this.getArtifactId() + "service.json");
        serviceDescriptor.deleteOnExit();
        MuleServiceModel.MuleServiceModelBuilder serviceModelBuilder = ((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)new MuleServiceModel.MuleServiceModelBuilder().setName(this.getArtifactId())).setMinMuleVersion("4.2.0")).setRequiredProduct(Product.MULE)).withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withContracts(Arrays.asList(new MuleServiceContractModel(this.serviceProviderClassName, this.contractClassName)));
        String serviceDescriptorContent = new MuleServiceModelJsonSerializer().serialize((AbstractMuleArtifactModel)serviceModelBuilder.build());
        try (FileWriter fileWriter = new FileWriter(serviceDescriptor);){
            fileWriter.write(serviceDescriptorContent);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return serviceDescriptor;
    }

    public String getConfigFile() {
        return null;
    }

    public File getArtifactFile() {
        boolean newlyCreated = this.artifactFile == null;
        File file = super.getArtifactFile();
        if (this.unpack && newlyCreated && !file.isDirectory()) {
            File unpacked = new File(file.getParentFile(), file.getName() + "-unpack");
            unpacked.mkdirs();
            try {
                FileUtils.unzip((File)file, (File)unpacked);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            file.delete();
            File newFile = new File(file.getParentFile(), file.getName().replaceAll(".jar", ""));
            unpacked.renameTo(newFile);
            this.artifactFile = file = new File(newFile.getAbsolutePath());
        }
        return file;
    }
}

