/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.runtime.module.artifact.builder.AbstractDependencyFileBuilder;
import org.mule.tck.ZipUtils;
import org.mule.tck.util.FileUtils;

public class ServiceFileBuilder
extends AbstractArtifactFileBuilder<ServiceFileBuilder> {
    private String serviceProviderClassName;
    private String contractClassName = null;
    private boolean unpack = false;

    public ServiceFileBuilder(String artifactId) {
        super(artifactId);
    }

    protected ServiceFileBuilder getThis() {
        return this;
    }

    public ServiceFileBuilder unpack(boolean unpack) {
        this.unpack = unpack;
        return this;
    }

    public ServiceFileBuilder withServiceProviderClass(String className) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)className) ? 1 : 0) != 0, (String)"Property value cannot be blank");
        this.serviceProviderClassName = className;
        return this;
    }

    public ServiceFileBuilder forContract(String contractClassName) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)contractClassName) ? 1 : 0) != 0, (String)"Property value cannot be blank");
        this.contractClassName = contractClassName;
        return this;
    }

    protected final List<ZipUtils.ZipResource> getCustomResources() throws IOException {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        for (AbstractDependencyFileBuilder dependencyFileBuilder : this.getAllCompileDependencies()) {
            customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactFile().toAbsolutePath().toString(), Paths.get("repository", dependencyFileBuilder.getArtifactFileRepositoryPath()).toString()));
            customResources.add(new ZipUtils.ZipResource(dependencyFileBuilder.getArtifactPomFile().toAbsolutePath().toString(), Paths.get("repository", dependencyFileBuilder.getArtifactFilePomRepositoryPath()).toString()));
        }
        Path serviceDescriptor = this.createServiceJsonDescriptorFile();
        customResources.add(new ZipUtils.ZipResource(serviceDescriptor.toAbsolutePath().toString(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION));
        return customResources;
    }

    private Path createServiceJsonDescriptorFile() throws IOException {
        Path serviceDescriptor = this.getTempFolder().resolve(this.getArtifactId() + "service.json");
        serviceDescriptor.toFile().deleteOnExit();
        MuleServiceModel.MuleServiceModelBuilder serviceModelBuilder = ((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)((MuleServiceModel.MuleServiceModelBuilder)new MuleServiceModel.MuleServiceModelBuilder().setName(this.getArtifactId())).setMinMuleVersion("4.2.0")).setRequiredProduct(Product.MULE)).withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withContracts(Arrays.asList(new MuleServiceContractModel(this.serviceProviderClassName, this.contractClassName)));
        String serviceDescriptorContent = new MuleServiceModelJsonSerializer().serialize((AbstractMuleArtifactModel)serviceModelBuilder.build());
        try (BufferedWriter fileWriter = Files.newBufferedWriter(serviceDescriptor, new OpenOption[0]);){
            fileWriter.write(serviceDescriptorContent);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return serviceDescriptor;
    }

    public String getConfigFile() {
        return null;
    }

    public Path getArtifactFile() throws IOException {
        boolean newlyCreated = this.artifactFile == null;
        Path file = super.getArtifactFile();
        if (this.unpack && newlyCreated && !Files.isDirectory(file, new LinkOption[0])) {
            Path unpacked = file.getParent().resolve(file.getFileName().toString() + "-unpack");
            Files.createDirectories(unpacked, new FileAttribute[0]);
            try {
                FileUtils.unzip((File)file.toFile(), (File)unpacked.toFile());
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            Files.delete(file);
            Path newFile = file.getParent().resolve(file.getFileName().toString().replaceAll(".jar", ""));
            Files.move(unpacked, newFile, new CopyOption[0]);
            this.artifactFile = file = newFile.toAbsolutePath();
        }
        return file;
    }
}

