/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.artifact;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyIterable;
import org.junit.Test;
import org.mule.runtime.module.service.internal.artifact.LibraryByJavaVersion;

@Feature(value="Classloading Isolation")
@Stories(value={@Story(value="ClassLoader configuration loader"), @Story(value="ClassLoader configuration")})
public class LibraryByJavaVersionTestCase {
    private final File someLib_1_1 = new File("someFolder" + File.separator + "someLib-1.1.jar");
    private final File someLib_1_2 = new File("someFolder" + File.separator + "someLib-1.2.jar");
    private final File someOtherLib_1_1 = new File("someFolder" + File.separator + "someOtherLib-1.1.jar");

    @Test
    public void singleLib() {
        ArrayList<LibraryByJavaVersion> libs = new ArrayList<LibraryByJavaVersion>();
        libs.add(new LibraryByJavaVersion(11, this.someLib_1_1));
        List resolvedLibs = LibraryByJavaVersion.resolveJvmDependantLibs((int)11, libs);
        MatcherAssert.assertThat((Object)resolvedLibs, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((File)resolvedLibs.get(0)), (Matcher)CoreMatchers.is((Object)this.someLib_1_1));
    }

    @Test
    public void noLibForJvm() {
        ArrayList<LibraryByJavaVersion> libs = new ArrayList<LibraryByJavaVersion>();
        libs.add(new LibraryByJavaVersion(17, this.someLib_1_1));
        MatcherAssert.assertThat((Object)LibraryByJavaVersion.resolveJvmDependantLibs((int)11, libs), (Matcher)CoreMatchers.is((Matcher)IsEmptyIterable.emptyIterable()));
    }

    @Test
    public void sameLibForDifferentJvms() {
        ArrayList<LibraryByJavaVersion> libs = new ArrayList<LibraryByJavaVersion>();
        libs.add(new LibraryByJavaVersion(11, this.someLib_1_1));
        libs.add(new LibraryByJavaVersion(17, this.someLib_1_2));
        List resolvedLibs = LibraryByJavaVersion.resolveJvmDependantLibs((int)17, libs);
        MatcherAssert.assertThat((Object)resolvedLibs, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((File)resolvedLibs.get(0)), (Matcher)CoreMatchers.is((Object)this.someLib_1_2));
    }

    @Test
    public void sameLibForDifferentJvmsLowerApplicable() {
        ArrayList<LibraryByJavaVersion> libs = new ArrayList<LibraryByJavaVersion>();
        libs.add(new LibraryByJavaVersion(11, this.someLib_1_1));
        libs.add(new LibraryByJavaVersion(17, this.someLib_1_2));
        List resolvedLibs = LibraryByJavaVersion.resolveJvmDependantLibs((int)11, libs);
        MatcherAssert.assertThat((Object)resolvedLibs, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((File)resolvedLibs.get(0)), (Matcher)CoreMatchers.is((Object)this.someLib_1_1));
    }

    @Test
    public void differentLibForDifferentJvms() {
        ArrayList<LibraryByJavaVersion> libs = new ArrayList<LibraryByJavaVersion>();
        libs.add(new LibraryByJavaVersion(11, this.someLib_1_1));
        libs.add(new LibraryByJavaVersion(17, this.someOtherLib_1_1));
        List resolvedLibs = LibraryByJavaVersion.resolveJvmDependantLibs((int)17, libs);
        MatcherAssert.assertThat((Object)resolvedLibs, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)((File)resolvedLibs.get(0)), (Matcher)CoreMatchers.is((Object)this.someLib_1_1));
        MatcherAssert.assertThat((Object)((File)resolvedLibs.get(1)), (Matcher)CoreMatchers.is((Object)this.someOtherLib_1_1));
    }
}

