/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.internal.discoverer.ServiceResolver;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxy;
import org.mule.runtime.module.service.internal.manager.ServiceRegistry;

public class ReflectionServiceResolver
implements ServiceResolver {
    private final ServiceRegistry serviceRegistry;
    private final Injector containerInjector;

    public ReflectionServiceResolver(ServiceRegistry serviceRegistry, Injector containerInjector) {
        this.serviceRegistry = serviceRegistry;
        this.containerInjector = containerInjector;
    }

    @Override
    public List<Service> resolveServices(List<ServiceAssembly> assemblies) {
        ArrayList<Service> services = new ArrayList<Service>(assemblies.size());
        for (ServiceAssembly assembly : assemblies) {
            Service service = LazyServiceProxy.from(assembly, this.serviceRegistry, this.containerInjector);
            this.serviceRegistry.register(service, assembly);
            services.add(service);
        }
        return services;
    }
}

