/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.module.service.api.discoverer.ServiceDiscoverer;
import org.mule.runtime.module.service.internal.manager.MuleServiceManager;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class MuleServiceManagerTestCase
extends AbstractMuleTestCase {
    private Service service1;
    private Service service2;
    @Mock
    private ServiceDiscoverer serviceDiscoverer;
    private MuleServiceManager muleServiceManager;

    @Before
    public void before() throws Exception {
        this.service1 = this.mockService();
        this.service2 = this.mockService();
        Mockito.when((Object)this.serviceDiscoverer.discoverServices()).thenReturn(Arrays.asList(this.service1, this.service2));
        Mockito.when((Object)this.service1.getName()).thenReturn((Object)"Awesome Service");
        Mockito.when((Object)this.service2.getName()).thenReturn((Object)"Yet another awesome Service");
        this.muleServiceManager = new MuleServiceManager(this.serviceDiscoverer);
    }

    private Service mockService() {
        return (Service)Mockito.mock(Service.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Startable.class, Stoppable.class}));
    }

    @Test
    public void registerServices() throws Exception {
        this.muleServiceManager.start();
        Assert.assertThat((Object)this.muleServiceManager.getServices(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(this.muleServiceManager.getServices().get(0), (Matcher)Is.is((Object)this.service1));
        Assert.assertThat(this.muleServiceManager.getServices().get(1), (Matcher)Is.is((Object)this.service2));
    }

    @Test
    public void startServices() throws Exception {
        this.muleServiceManager.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.service1, this.service2});
        ((Startable)inOrder.verify((Object)((Startable)this.service1))).start();
        ((Startable)inOrder.verify((Object)((Startable)this.service2))).start();
    }

    @Test
    public void stopsServices() throws Exception {
        this.muleServiceManager.start();
        this.muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.service1, this.service2});
        ((Stoppable)inOrder.verify((Object)((Stoppable)this.service1))).stop();
        ((Stoppable)inOrder.verify((Object)((Stoppable)this.service2))).stop();
    }

    @Test
    public void ignoresServiceStopError() throws Exception {
        ((Stoppable)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)((Stoppable)this.service1))).stop();
        this.muleServiceManager.start();
        this.muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.service1, this.service2});
        ((Stoppable)inOrder.verify((Object)((Stoppable)this.service1))).stop();
        ((Stoppable)inOrder.verify((Object)((Stoppable)this.service2))).stop();
    }

    @Test
    public void httpAndSchedulerServicesAreStoppedInOrder() throws Exception {
        Service mockSchedulerService = this.mockService();
        Mockito.when((Object)mockSchedulerService.getName()).thenReturn((Object)"Scheduler service");
        Service mockHttpService = this.mockService();
        Mockito.when((Object)mockHttpService.getName()).thenReturn((Object)"HTTP Service");
        Mockito.when((Object)this.serviceDiscoverer.discoverServices()).thenReturn(Arrays.asList(this.service1, mockSchedulerService, this.service2, mockHttpService));
        this.muleServiceManager.start();
        this.muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockHttpService, mockSchedulerService});
        ((Stoppable)inOrder.verify((Object)((Stoppable)mockHttpService))).stop();
        ((Stoppable)inOrder.verify((Object)((Stoppable)mockSchedulerService))).stop();
    }
}

