/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.io.File;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.api.discoverer.MuleServiceModelLoader;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptorFactory;
import org.mule.runtime.module.service.internal.discoverer.LazyServiceAssembly;

public class FileSystemServiceProviderDiscoverer
implements ServiceProviderDiscoverer {
    private static final AccessControlContext ACCESS_CONTROL_CTX = AccessController.getContext();
    private final ArtifactClassLoader apiClassLoader;
    private final ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory;
    private final DescriptorLoaderRepository descriptorLoaderRepository;
    private final ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder;
    private final Supplier<File> targetServicesFolder;

    public FileSystemServiceProviderDiscoverer(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder, File targetServicesFolder) {
        this(containerClassLoader, serviceClassLoaderFactory, descriptorLoaderRepository, artifactDescriptorValidatorBuilder, () -> targetServicesFolder);
    }

    public FileSystemServiceProviderDiscoverer(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        this(containerClassLoader, serviceClassLoaderFactory, descriptorLoaderRepository, artifactDescriptorValidatorBuilder, () -> MuleFoldersUtil.getServicesFolder());
    }

    private FileSystemServiceProviderDiscoverer(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder, Supplier<File> targetServicesFolder) {
        Preconditions.checkArgument((containerClassLoader != null ? 1 : 0) != 0, (String)"containerClassLoader cannot be null");
        Preconditions.checkArgument((serviceClassLoaderFactory != null ? 1 : 0) != 0, (String)"serviceClassLoaderFactory cannot be null");
        Preconditions.checkArgument((artifactDescriptorValidatorBuilder != null ? 1 : 0) != 0, (String)"artifactDescriptorValidatorBuilder cannot be null");
        Preconditions.checkArgument((targetServicesFolder != null ? 1 : 0) != 0, (String)"targetServicesFolder cannot be null");
        this.descriptorLoaderRepository = descriptorLoaderRepository;
        this.apiClassLoader = containerClassLoader;
        this.serviceClassLoaderFactory = serviceClassLoaderFactory;
        this.artifactDescriptorValidatorBuilder = artifactDescriptorValidatorBuilder;
        this.targetServicesFolder = targetServicesFolder;
    }

    @Override
    public List<ServiceAssembly> discover() throws ServiceResolutionError {
        ServiceDescriptorFactory serviceDescriptorFactory = new ServiceDescriptorFactory(this.descriptorLoaderRepository, this.artifactDescriptorValidatorBuilder);
        List<ServiceDescriptor> serviceDescriptors = this.getServiceDescriptors(serviceDescriptorFactory);
        return this.assemble(serviceDescriptors, this.serviceClassLoaderFactory);
    }

    private List<ServiceDescriptor> getServiceDescriptors(ServiceDescriptorFactory serviceDescriptorFactory) throws ServiceResolutionError {
        File[] serviceDirectories = this.targetServicesFolder.get().listFiles(File::isDirectory);
        ArrayList<ServiceDescriptor> foundServices = new ArrayList<ServiceDescriptor>(serviceDirectories.length);
        for (File serviceDirectory : serviceDirectories) {
            try {
                ArtifactDescriptor serviceDescriptor = serviceDescriptorFactory.create(serviceDirectory, Optional.empty());
                foundServices.add((ServiceDescriptor)serviceDescriptor);
            }
            catch (Exception e) {
                throw new ServiceResolutionError("Error processing service JAR file", Exceptions.unwrap((Throwable)e));
            }
        }
        return foundServices;
    }

    private List<ServiceAssembly> assemble(List<ServiceDescriptor> serviceDescriptors, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory) throws ServiceResolutionError {
        ArrayList<ServiceAssembly> assemblies = new ArrayList<ServiceAssembly>(serviceDescriptors.size());
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            LazyValue serviceClassLoader = new LazyValue(() -> AccessController.doPrivileged(() -> (ClassLoader)serviceClassLoaderFactory.create(this.getServiceArtifactId(serviceDescriptor), (ArtifactDescriptor)serviceDescriptor, this.apiClassLoader.getClassLoader(), this.apiClassLoader.getClassLoaderLookupPolicy()), ACCESS_CONTROL_CTX));
            for (MuleServiceContractModel contract : serviceDescriptor.getContractModels()) {
                ServiceAssembly assembly = LazyServiceAssembly.builder().withName(serviceDescriptor.getName()).withClassLoader((Supplier<ClassLoader>)serviceClassLoader).withServiceProvider((CheckedSupplier<ServiceProvider>)((CheckedSupplier)() -> MuleServiceModelLoader.instantiateServiceProvider(contract))).forContract(contract.getContractClassName()).build();
                assemblies.add(assembly);
            }
        }
        return assemblies;
    }

    private String getServiceArtifactId(ServiceDescriptor serviceDescriptor) {
        return "service/" + serviceDescriptor.getName();
    }
}

