/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.internal.artifact.LibFolderClassLoaderConfigurationLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Classloading Isolation")
@Stories(value={@Story(value="ClassLoader configuration loader"), @Story(value="ClassLoader configuration")})
public class LibFolderClassLoaderConfigurationLoaderTestCase
extends AbstractMuleTestCase {
    private final ClassLoaderLookupPolicy lookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    @Rule
    public TemporaryFolder serviceFolder = new TemporaryFolder();
    private LibFolderClassLoaderConfigurationLoader classLoaderConfigurationLoader = new LibFolderClassLoaderConfigurationLoader();
    private ServiceDescriptor descriptor;

    @Before
    public void setUp() throws Exception {
        this.descriptor = new ServiceDescriptor("testService");
        this.descriptor.setRootFolder(this.serviceFolder.getRoot());
        Mockito.when((Object)this.lookupPolicy.getClassLookupStrategy(ArgumentMatchers.anyString())).thenReturn((Object)ParentFirstLookupStrategy.PARENT_FIRST);
    }

    @Test(expected=IllegalArgumentException.class)
    public void validatesServiceFolder() throws Exception {
        File fakeServiceFolder = new File("./fake/folder/for/test");
        this.descriptor.setRootFolder(fakeServiceFolder);
        this.classLoaderConfigurationLoader.load(fakeServiceFolder, Collections.emptyMap(), ArtifactType.SERVICE);
    }

    @Test
    public void addsArtifactFolderToClassLoader() throws Exception {
        ClassLoaderConfiguration classLoaderModel = this.classLoaderConfigurationLoader.load(this.serviceFolder.getRoot(), Collections.emptyMap(), ArtifactType.SERVICE);
        URL[] urls = classLoaderModel.getUrls();
        MatcherAssert.assertThat((Object)urls, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)urls, (Matcher)ArrayMatching.hasItemInArray((Object)this.serviceFolder.getRoot().toURI().toURL()));
    }

    @Test
    public void addJarsFromLibFolderToClassLoader() throws Exception {
        File libFolder = this.serviceFolder.newFolder("lib");
        File jarFile = new File(libFolder, "dummy.jar");
        jarFile.createNewFile();
        ClassLoaderConfiguration classLoaderModel = this.classLoaderConfigurationLoader.load(this.serviceFolder.getRoot(), Collections.emptyMap(), ArtifactType.SERVICE);
        URL[] urls = classLoaderModel.getUrls();
        MatcherAssert.assertThat((Object)urls, (Matcher)IsArrayWithSize.arrayWithSize((int)2));
        MatcherAssert.assertThat((Object)urls, (Matcher)ArrayMatching.hasItemInArray((Object)jarFile.toURI().toURL()));
    }

    @Test
    public void ignoresNonJarsFilesFromLibFolder() throws Exception {
        File libFolder = this.serviceFolder.newFolder("lib");
        File jarFile = new File(libFolder, "dummy.txt");
        jarFile.createNewFile();
        ClassLoaderConfiguration classLoaderModel = this.classLoaderConfigurationLoader.load(this.serviceFolder.getRoot(), Collections.emptyMap(), ArtifactType.SERVICE);
        MatcherAssert.assertThat((Object)classLoaderModel.getUrls(), (Matcher)ArrayMatching.hasItemInArray((Object)this.serviceFolder.getRoot().toURI().toURL()));
    }
}

