/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.manager;

import java.util.Optional;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ServiceRegistryTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    private DefaultServiceRegistry serviceRegistry;
    private ServiceA serviceA;
    @Mock
    private ServiceProvider serviceProviderA;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        this.serviceRegistry = new DefaultServiceRegistry();
        this.serviceA = new ServiceA();
    }

    private void registerServiceA() {
        this.serviceRegistry.register((Service)this.serviceA, ServiceA.class);
    }

    @Test
    public void injectRequiredServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderRequiredDependencyToServiceA serviceProviderRequiredDependencyToServiceA = new ServiceProviderRequiredDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderRequiredDependencyToServiceA);
        Assert.assertThat((Object)serviceProviderRequiredDependencyToServiceA.serviceA, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)serviceProviderRequiredDependencyToServiceA.serviceA, (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    @Test
    public void missingRequiredServiceDependency() throws ServiceResolutionError {
        ServiceProviderRequiredDependencyToServiceA serviceProviderRequiredDependencyToServiceA = new ServiceProviderRequiredDependencyToServiceA();
        this.expectedException.expect(ServiceResolutionError.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)("Could not inject dependency on field serviceA of type " + ServiceA.class.getName())));
        this.serviceRegistry.inject((ServiceProvider)serviceProviderRequiredDependencyToServiceA);
    }

    @Test
    public void injectEmptyOptionalServiceDependency() throws ServiceResolutionError {
        ServiceProviderOptionalDependencyToServiceA serviceProviderOptionalDependencyToServiceA = new ServiceProviderOptionalDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalDependencyToServiceA);
        Assert.assertThat(serviceProviderOptionalDependencyToServiceA.serviceA, (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void injectOptionalServiceDependency() throws ServiceResolutionError {
        this.registerServiceA();
        ServiceProviderOptionalDependencyToServiceA serviceProviderOptionalDependencyToServiceA = new ServiceProviderOptionalDependencyToServiceA();
        this.serviceRegistry.inject((ServiceProvider)serviceProviderOptionalDependencyToServiceA);
        Assert.assertThat((Object)serviceProviderOptionalDependencyToServiceA.serviceA.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)serviceProviderOptionalDependencyToServiceA.serviceA.get(), (Matcher)CoreMatchers.sameInstance((Object)this.serviceA));
    }

    public class ServiceProviderOptionalDependencyToServiceA
    implements ServiceProvider {
        @Inject
        Optional<ServiceA> serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public class ServiceProviderRequiredDependencyToServiceA
    implements ServiceProvider {
        @Inject
        ServiceA serviceA;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public class ServiceA
    implements Service {
        public String getName() {
            return this.getClass().getSimpleName();
        }
    }
}

