/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.artifact;

import io.qameta.allure.Story;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.builder.ServiceFileBuilder;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptorFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

@Story(value="Artifact descriptors")
public class ServiceDescriptorFactoryTestCase
extends AbstractMuleTestCase {
    private static final String SERVICE_NAME = "testService";
    private static final String SERVICE_API_CLASS_NAME = "org.foo.FooServiceProvider";
    private static final String PROVIDER_CLASS_NAME = "org.foo.FooServiceProvider";
    private final DescriptorLoaderRepository descriptorLoaderRepository = (DescriptorLoaderRepository)Mockito.mock(DescriptorLoaderRepository.class);
    private final ArtifactDescriptorValidator artifactDescriptorValidator = (ArtifactDescriptorValidator)Mockito.mock(ArtifactDescriptorValidator.class);
    private ServiceDescriptorFactory serviceDescriptorFactory;
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");

    @Before
    public void setUp() throws Exception {
        BundleDescriptorLoader bundleDescriptorLoaderMock = (BundleDescriptorLoader)Mockito.mock(BundleDescriptorLoader.class);
        Mockito.when((Object)bundleDescriptorLoaderMock.supportsArtifactType(ArtifactType.SERVICE)).thenReturn((Object)true);
        Mockito.when((Object)((BundleDescriptor)bundleDescriptorLoaderMock.load((File)Mockito.any(File.class), (Map)Mockito.any(Map.class), (ArtifactType)ArgumentMatchers.eq((Object)ArtifactType.SERVICE)))).thenReturn((Object)new BundleDescriptor.Builder().setGroupId("mockGroupId").setArtifactId("mockArtifactId").setVersion("1.0.0").setClassifier("mule-service").setType("jar").build());
        Mockito.when((Object)((BundleDescriptorLoader)this.descriptorLoaderRepository.get(ArgumentMatchers.anyString(), (ArtifactType)ArgumentMatchers.any(), (Class)MockitoHamcrest.argThat((Matcher)Matchers.equalTo(BundleDescriptorLoader.class))))).thenReturn((Object)bundleDescriptorLoaderMock);
        Mockito.when((Object)((ClassLoaderConfigurationLoader)this.descriptorLoaderRepository.get(ArgumentMatchers.anyString(), (ArtifactType)ArgumentMatchers.any(), (Class)MockitoHamcrest.argThat((Matcher)Matchers.equalTo(ClassLoaderConfigurationLoader.class))))).thenReturn((Object)((ClassLoaderConfigurationLoader)Mockito.mock(ClassLoaderConfigurationLoader.class)));
        ((ArtifactDescriptorValidator)Mockito.doNothing().when((Object)this.artifactDescriptorValidator)).validate((ArtifactDescriptor)ArgumentMatchers.any());
        this.serviceDescriptorFactory = new ServiceDescriptorFactory(this.descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder.builder());
    }

    @Test
    public void createServiceDescriptor() throws Exception {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        MatcherAssert.assertThat((Object)servicesFolder.mkdirs(), (Matcher)Is.is((Object)true));
        ServiceFileBuilder fooService = new ServiceFileBuilder(SERVICE_NAME).withServiceProviderClass("org.foo.FooServiceProvider").forContract("org.foo.FooServiceProvider");
        FileUtils.unzip((File)fooService.getArtifactFile(), (File)MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME));
        ServiceDescriptor descriptor = this.serviceDescriptorFactory.create(MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME), Optional.empty());
        MatcherAssert.assertThat((Object)descriptor.getName(), (Matcher)Matchers.equalTo((Object)SERVICE_NAME));
        MatcherAssert.assertThat((Object)descriptor.getRootFolder(), (Matcher)Matchers.equalTo((Object)MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME)));
        MatcherAssert.assertThat((Object)descriptor.getContractModels(), (Matcher)Matchers.hasSize((int)1));
        MuleServiceContractModel contractModel = (MuleServiceContractModel)descriptor.getContractModels().get(0);
        MatcherAssert.assertThat((Object)contractModel.getServiceProviderClassName(), (Matcher)Matchers.equalTo((Object)"org.foo.FooServiceProvider"));
        MatcherAssert.assertThat((Object)contractModel.getContractClassName(), (Matcher)Matchers.equalTo((Object)"org.foo.FooServiceProvider"));
    }
}

