/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.discoverer;

import io.qameta.allure.Description;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ReflectionServiceResolverTestCase
extends AbstractMuleTestCase {
    @Test
    @Description(value="SOAP service apis are not loader for Java 21+. Assert that the presence of the service does not break the startup of Mule when running with Java 21+")
    public void resolveServiceNoContractClass() throws ServiceResolutionError {
        ReflectionServiceResolver resolver = new ReflectionServiceResolver(null, null, (s, a) -> s);
        ServiceAssembly serviceAssembly = ServiceAssembly.lazyBuilder().withName("Invalid Service").withClassLoader(() -> ((Object)((Object)this)).getClass().getClassLoader()).withServiceProvider(() -> (ServiceProvider)Mockito.mock(ServiceProvider.class)).forContract("org.mule.runtime.NotExists").build();
        List resolvedServices = resolver.resolveServices(Arrays.asList(serviceAssembly));
        MatcherAssert.assertThat((Object)resolvedServices, (Matcher)IsEmptyIterable.emptyIterable());
    }

    @Test
    public void resolveServiceException() throws ServiceResolutionError {
        MuleRuntimeException expectedException = new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        ReflectionServiceResolver resolver = new ReflectionServiceResolver(null, null, (s, a) -> {
            throw expectedException;
        });
        ServiceAssembly serviceAssembly = ServiceAssembly.lazyBuilder().withName("some Service").withClassLoader(() -> ((Object)((Object)this)).getClass().getClassLoader()).withServiceProvider(() -> (ServiceProvider)Mockito.mock(ServiceProvider.class)).forContract(SomeService.class.getName()).build();
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> resolver.resolveServices(Arrays.asList(serviceAssembly)));
        MatcherAssert.assertThat((Object)thrown, (Matcher)IsSame.sameInstance((Object)expectedException));
    }

    public static interface SomeService
    extends Service {
    }
}

