/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.MuleConfigurationConfigurator;
import org.mule.runtime.config.spring.NotificationConfig;
import org.mule.runtime.config.spring.ServerNotificationManagerConfigurator;
import org.mule.runtime.config.spring.dsl.processor.AddVariablePropertyConfigurator;
import org.mule.runtime.config.spring.dsl.processor.CustomSecurityFilterObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.EncryptionSecurityFilterObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.EnvironmentPropertyObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.ExplicitMethodEntryPointResolverObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.MessageEnricherObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.MethodEntryPoint;
import org.mule.runtime.config.spring.dsl.processor.NoArgumentsEntryPointResolverObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.RetryPolicyTemplateObjectFactory;
import org.mule.runtime.config.spring.dsl.processor.TransformerConfigurator;
import org.mule.runtime.config.spring.dsl.processor.UsernamePasswordFilterObjectFactory;
import org.mule.runtime.config.spring.dsl.spring.ComponentObjectFactory;
import org.mule.runtime.config.spring.dsl.spring.ConfigurableInstanceFactory;
import org.mule.runtime.config.spring.dsl.spring.ConfigurableObjectFactory;
import org.mule.runtime.config.spring.dsl.spring.ExcludeDefaultObjectMethods;
import org.mule.runtime.config.spring.dsl.spring.PooledComponentObjectFactory;
import org.mule.runtime.config.spring.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.runtime.config.spring.factories.ChoiceRouterFactoryBean;
import org.mule.runtime.config.spring.factories.FlowRefFactoryBean;
import org.mule.runtime.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.runtime.config.spring.factories.MessageProcessorFilterPairFactoryBean;
import org.mule.runtime.config.spring.factories.ModuleOperationMessageProcessorChainFactoryBean;
import org.mule.runtime.config.spring.factories.ResponseMessageProcessorsFactoryBean;
import org.mule.runtime.config.spring.factories.ScatterGatherRouterFactoryBean;
import org.mule.runtime.config.spring.factories.SchedulingMessageSourceFactoryBean;
import org.mule.runtime.config.spring.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.runtime.config.spring.factories.TryProcessorFactoryBean;
import org.mule.runtime.config.spring.factories.streaming.InMemoryCursorIteratorProviderObjectFactory;
import org.mule.runtime.config.spring.factories.streaming.InMemoryCursorStreamProviderObjectFactory;
import org.mule.runtime.config.spring.factories.streaming.NullCursorIteratorProviderObjectFactory;
import org.mule.runtime.config.spring.factories.streaming.NullCursorStreamProviderObjectFactory;
import org.mule.runtime.config.spring.util.SpringBeanLookup;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.LifecycleAdapterFactory;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.interceptor.Interceptor;
import org.mule.runtime.core.api.model.EntryPointResolver;
import org.mule.runtime.core.api.model.EntryPointResolverSet;
import org.mule.runtime.core.api.model.resolvers.ArrayEntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.CallableEntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.runtime.core.api.model.resolvers.ExplicitMethodEntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.MethodHeaderPropertyEntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.NoArgumentsEntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.ReflectionEntryPointResolver;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.processor.AbstractProcessor;
import org.mule.runtime.core.api.processor.LoggerMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.polling.PeriodicScheduler;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.component.DefaultJavaComponent;
import org.mule.runtime.core.component.PooledJavaComponent;
import org.mule.runtime.core.component.simple.EchoComponent;
import org.mule.runtime.core.component.simple.LogComponent;
import org.mule.runtime.core.component.simple.NullComponent;
import org.mule.runtime.core.component.simple.StaticComponent;
import org.mule.runtime.core.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.el.ExpressionLanguageComponent;
import org.mule.runtime.core.exception.ErrorHandler;
import org.mule.runtime.core.exception.OnErrorContinueHandler;
import org.mule.runtime.core.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.exception.RedeliveryExceeded;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.expression.transformers.AbstractExpressionTransformer;
import org.mule.runtime.core.expression.transformers.BeanBuilderTransformer;
import org.mule.runtime.core.expression.transformers.ExpressionArgument;
import org.mule.runtime.core.expression.transformers.ExpressionTransformer;
import org.mule.runtime.core.interceptor.LoggingInterceptor;
import org.mule.runtime.core.interceptor.TimerInterceptor;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.enricher.MessageEnricher;
import org.mule.runtime.core.internal.transformer.codec.XmlEntityDecoder;
import org.mule.runtime.core.internal.transformer.codec.XmlEntityEncoder;
import org.mule.runtime.core.internal.transformer.compression.GZipCompressTransformer;
import org.mule.runtime.core.internal.transformer.compression.GZipUncompressTransformer;
import org.mule.runtime.core.internal.transformer.encryption.AbstractEncryptionTransformer;
import org.mule.runtime.core.internal.transformer.encryption.DecryptionTransformer;
import org.mule.runtime.core.internal.transformer.encryption.EncryptionTransformer;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.mule.runtime.core.object.PrototypeObjectFactory;
import org.mule.runtime.core.object.SingletonObjectFactory;
import org.mule.runtime.core.processor.AnnotatedProcessor;
import org.mule.runtime.core.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.processor.IdempotentRedeliveryPolicy;
import org.mule.runtime.core.processor.InvokerMessageProcessor;
import org.mule.runtime.core.processor.ResponseMessageProcessorAdapter;
import org.mule.runtime.core.processor.SecurityFilterMessageProcessor;
import org.mule.runtime.core.processor.simple.AbstractAddVariablePropertyProcessor;
import org.mule.runtime.core.processor.simple.AddFlowVariableProcessor;
import org.mule.runtime.core.processor.simple.AddPropertyProcessor;
import org.mule.runtime.core.processor.simple.RemoveFlowVariableProcessor;
import org.mule.runtime.core.processor.simple.RemovePropertyProcessor;
import org.mule.runtime.core.processor.simple.SetPayloadMessageProcessor;
import org.mule.runtime.core.retry.notifiers.ConnectNotifier;
import org.mule.runtime.core.routing.AggregationStrategy;
import org.mule.runtime.core.routing.ChoiceRouter;
import org.mule.runtime.core.routing.FirstSuccessful;
import org.mule.runtime.core.routing.Foreach;
import org.mule.runtime.core.routing.IdempotentMessageValidator;
import org.mule.runtime.core.routing.IdempotentSecureHashMessageValidator;
import org.mule.runtime.core.routing.MessageChunkAggregator;
import org.mule.runtime.core.routing.MessageChunkSplitter;
import org.mule.runtime.core.routing.MessageFilter;
import org.mule.runtime.core.routing.MessageProcessorFilterPair;
import org.mule.runtime.core.routing.Resequencer;
import org.mule.runtime.core.routing.RoundRobin;
import org.mule.runtime.core.routing.ScatterGatherRouter;
import org.mule.runtime.core.routing.SimpleCollectionAggregator;
import org.mule.runtime.core.routing.Splitter;
import org.mule.runtime.core.routing.UntilSuccessful;
import org.mule.runtime.core.routing.WireTap;
import org.mule.runtime.core.routing.filters.EqualsFilter;
import org.mule.runtime.core.routing.filters.ExceptionTypeFilter;
import org.mule.runtime.core.routing.filters.ExpressionFilter;
import org.mule.runtime.core.routing.filters.MessagePropertyFilter;
import org.mule.runtime.core.routing.filters.NotWildcardFilter;
import org.mule.runtime.core.routing.filters.PayloadTypeFilter;
import org.mule.runtime.core.routing.filters.RegExFilter;
import org.mule.runtime.core.routing.filters.WildcardFilter;
import org.mule.runtime.core.routing.filters.logic.AndFilter;
import org.mule.runtime.core.routing.filters.logic.NotFilter;
import org.mule.runtime.core.routing.filters.logic.OrFilter;
import org.mule.runtime.core.routing.outbound.MulticastingRouter;
import org.mule.runtime.core.routing.requestreply.SimpleAsyncRequestReplyRequester;
import org.mule.runtime.core.source.StartableCompositeMessageSource;
import org.mule.runtime.core.source.scheduler.DefaultSchedulerMessageSource;
import org.mule.runtime.core.source.scheduler.schedule.CronScheduler;
import org.mule.runtime.core.source.scheduler.schedule.FixedFrequencyScheduler;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.TransactionType;
import org.mule.runtime.core.transaction.XaTransactionFactory;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.transformer.codec.Base64Decoder;
import org.mule.runtime.core.transformer.codec.Base64Encoder;
import org.mule.runtime.core.transformer.simple.AutoTransformer;
import org.mule.runtime.core.transformer.simple.BeanToMap;
import org.mule.runtime.core.transformer.simple.ByteArrayToHexString;
import org.mule.runtime.core.transformer.simple.ByteArrayToObject;
import org.mule.runtime.core.transformer.simple.ByteArrayToSerializable;
import org.mule.runtime.core.transformer.simple.CombineCollectionsTransformer;
import org.mule.runtime.core.transformer.simple.CopyPropertiesProcessor;
import org.mule.runtime.core.transformer.simple.HexStringToByteArray;
import org.mule.runtime.core.transformer.simple.MapToBean;
import org.mule.runtime.core.transformer.simple.ParseTemplateTransformer;
import org.mule.runtime.core.transformer.simple.SerializableToByteArray;
import org.mule.runtime.core.transformer.simple.StringAppendTransformer;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.CommonTypeConverters;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.ExtensionConstants;

public class CoreComponentBuildingDefinitionProvider
implements ComponentBuildingDefinitionProvider {
    private static final String MESSAGE_PROCESSORS = "messageProcessors";
    private static final String NAME = "name";
    private static final String EXCEPTION_STRATEGY = "exception-strategy";
    private static final String ON_ERROR_CONTINUE = "on-error-continue";
    private static final String WHEN = "when";
    private static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    private static final String CUSTOM_EXCEPTION_STRATEGY = "custom-exception-strategy";
    private static final String ERROR_HANDLER = "error-handler";
    private static final String SET_PAYLOAD = "set-payload";
    private static final String LOGGER = "logger";
    private static final String PROCESSOR_CHAIN = "processor-chain";
    private static final String PROCESSOR = "processor";
    private static final String TRANSFORMER = "transformer";
    private static final String FILTER = "filter";
    private static final String CUSTOM_PROCESSOR = "custom-processor";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String SUB_FLOW = "sub-flow";
    private static final String RESPONSE = "response";
    private static final String MESSAGE_FILTER = "message-filter";
    private static final String FLOW = "flow";
    private static final String FLOW_REF = "flow-ref";
    private static final String EXCEPTION_LISTENER_ATTRIBUTE = "exceptionListener";
    private static final String SCATTER_GATHER = "scatter-gather";
    private static final String WIRE_TAP = "wire-tap";
    private static final String ENRICHER = "enricher";
    private static final String ASYNC = "async";
    private static final String TRY = "try";
    private static final String UNTIL_SUCCESSFUL = "until-successful";
    private static final String FOREACH = "foreach";
    private static final String FIRST_SUCCESSFUL = "first-successful";
    private static final String ROUND_ROBIN = "round-robin";
    private static final String CHOICE = "choice";
    private static final String OTHERWISE = "otherwise";
    private static final String ALL = "all";
    private static final String SCHEDULER = "scheduler";
    private static final String REQUEST_REPLY = "request-reply";
    private static final String ERROR_TYPE = "errorType";
    private static final String TYPE = "type";
    private static final String TX_ACTION = "transactionalAction";
    private static final String TX_TYPE = "transactionType";
    private Map<String, Integer> regExFlagsMapping = ImmutableMap.builder().put((Object)"CANON_EQ", (Object)128).put((Object)"CASE_INSENSITIVE", (Object)2).put((Object)"DOTALL", (Object)32).put((Object)"MULTILINE", (Object)8).put((Object)"UNICODE_CASE", (Object)64).build();
    private static ComponentBuildingDefinition.Builder baseDefinition = new ComponentBuildingDefinition.Builder().withNamespace("mule");
    private ComponentBuildingDefinition.Builder transactionManagerBaseDefinition;

    public void init() {
        this.transactionManagerBaseDefinition = baseDefinition.copy();
    }

    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<ComponentBuildingDefinition>();
        AttributeDefinition messageProcessorListAttributeDefinition = AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build();
        ComponentBuildingDefinition.Builder exceptionStrategyBaseBuilder = baseDefinition.copy().withSetterParameterDefinition(MESSAGE_PROCESSORS, messageProcessorListAttributeDefinition).withSetterParameterDefinition("globalName", AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(EXCEPTION_STRATEGY).withTypeDefinition(TypeDefinition.fromType(Object.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).build());
        componentBuildingDefinitions.add(exceptionStrategyBaseBuilder.copy().withIdentifier(ON_ERROR_CONTINUE).withTypeDefinition(TypeDefinition.fromType(OnErrorContinueHandler.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(WHEN, AttributeDefinition.Builder.fromSimpleParameter((String)WHEN).build()).withSetterParameterDefinition(ERROR_TYPE, AttributeDefinition.Builder.fromSimpleParameter((String)TYPE).build()).asPrototype().build());
        componentBuildingDefinitions.add(exceptionStrategyBaseBuilder.copy().withIdentifier(ON_ERROR_PROPAGATE).withTypeDefinition(TypeDefinition.fromType(OnErrorPropagateHandler.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(WHEN, AttributeDefinition.Builder.fromSimpleParameter((String)WHEN).build()).withSetterParameterDefinition(ERROR_TYPE, AttributeDefinition.Builder.fromSimpleParameter((String)TYPE).build()).withSetterParameterDefinition("maxRedeliveryAttempts", AttributeDefinition.Builder.fromSimpleParameter((String)"maxRedeliveryAttempts").build()).withSetterParameterDefinition("redeliveryExceeded", AttributeDefinition.Builder.fromChildConfiguration(RedeliveryExceeded.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("on-redelivery-attempts-exceeded").withTypeDefinition(TypeDefinition.fromType(RedeliveryExceeded.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asScope().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("commit-transaction").withTypeDefinition(TypeDefinition.fromType(WildcardFilter.class)).withSetterParameterDefinition("pattern", AttributeDefinition.Builder.fromSimpleParameter((String)"exception-pattern").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("rollback-transaction").withTypeDefinition(TypeDefinition.fromType(NotWildcardFilter.class)).withSetterParameterDefinition("pattern", AttributeDefinition.Builder.fromSimpleParameter((String)"exception-pattern").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(CUSTOM_EXCEPTION_STRATEGY).withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(ERROR_HANDLER).withTypeDefinition(TypeDefinition.fromType(ErrorHandler.class)).withSetterParameterDefinition("globalName", AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("exceptionListeners", AttributeDefinition.Builder.fromChildCollectionConfiguration(MessagingExceptionHandler.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(SET_PAYLOAD).withTypeDefinition(TypeDefinition.fromType(SetPayloadMessageProcessor.class)).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).withSetterParameterDefinition("mimeType", AttributeDefinition.Builder.fromSimpleParameter((String)"mimeType").build()).withSetterParameterDefinition("encoding", AttributeDefinition.Builder.fromSimpleParameter((String)"encoding").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(LOGGER).withTypeDefinition(TypeDefinition.fromType(LoggerMessageProcessor.class)).withSetterParameterDefinition("message", AttributeDefinition.Builder.fromSimpleParameter((String)"message").build()).withSetterParameterDefinition("category", AttributeDefinition.Builder.fromSimpleParameter((String)"category").build()).withSetterParameterDefinition("level", AttributeDefinition.Builder.fromSimpleParameter((String)"level").build()).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getSetVariablePropertyBaseBuilder(this.getAddFlowVariableTransformerInstanceFactory(AddPropertyProcessor.class), AddPropertyProcessor.class, KeyAttributeDefinitionPair.newBuilder().withKey("identifier").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"propertyName").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("value").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).build()).withIdentifier("set-property").withTypeDefinition(TypeDefinition.fromType(AddPropertyProcessor.class)).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getSetVariablePropertyBaseBuilder(this.getAddFlowVariableTransformerInstanceFactory(AddFlowVariableProcessor.class), AddFlowVariableProcessor.class, KeyAttributeDefinitionPair.newBuilder().withKey("identifier").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"variableName").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("value").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).build()).withIdentifier("set-variable").withTypeDefinition(TypeDefinition.fromType(AddFlowVariableProcessor.class)).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getMuleMessageTransformerBaseBuilder().withIdentifier("remove-property").withTypeDefinition(TypeDefinition.fromType(RemovePropertyProcessor.class)).withSetterParameterDefinition("identifier", AttributeDefinition.Builder.fromSimpleParameter((String)"propertyName").build()).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getMuleMessageTransformerBaseBuilder().withIdentifier("remove-variable").withTypeDefinition(TypeDefinition.fromType(RemoveFlowVariableProcessor.class)).withSetterParameterDefinition("identifier", AttributeDefinition.Builder.fromSimpleParameter((String)"variableName").build()).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getMuleMessageTransformerBaseBuilder().withIdentifier("copy-properties").withTypeDefinition(TypeDefinition.fromType(CopyPropertiesProcessor.class)).withSetterParameterDefinition("propertyName", AttributeDefinition.Builder.fromSimpleParameter((String)"propertyName").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(PROCESSOR).withTypeDefinition(TypeDefinition.fromType(AbstractProcessor.class)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(TRANSFORMER).withTypeDefinition(TypeDefinition.fromType(Transformer.class)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(FILTER).withTypeDefinition(TypeDefinition.fromType(Object.class)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(CUSTOM_PROCESSOR).withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(PROCESSOR_CHAIN).withTypeDefinition(TypeDefinition.fromType(Processor.class)).withObjectFactoryType(MessageProcessorChainFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        this.addModuleOperationChainParser(componentBuildingDefinitions);
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(SUB_FLOW).withTypeDefinition(TypeDefinition.fromType(Processor.class)).withObjectFactoryType(SubflowMessageProcessorChainFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(RESPONSE).withTypeDefinition(TypeDefinition.fromType(ResponseMessageProcessorAdapter.class)).withObjectFactoryType(ResponseMessageProcessorsFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(MESSAGE_FILTER).withTypeDefinition(TypeDefinition.fromType(MessageFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Filter.class).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"throwOnUnaccepted").withDefaultValue((Object)false).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"onUnaccepted").build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(FLOW).withTypeDefinition(TypeDefinition.fromType(DefaultFlowBuilder.DefaultFlow.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("initialState", AttributeDefinition.Builder.fromSimpleParameter((String)"initialState").build()).withSetterParameterDefinition("messageSource", AttributeDefinition.Builder.fromChildConfiguration(MessageSource.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(EXCEPTION_LISTENER_ATTRIBUTE, AttributeDefinition.Builder.fromChildConfiguration(MessagingExceptionHandler.class).build()).withSetterParameterDefinition("processingStrategyFactory", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"processingStrategy").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(FLOW_REF).withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(FlowRefFactoryBean.class).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(SCATTER_GATHER).withTypeDefinition(TypeDefinition.fromType(ScatterGatherRouter.class)).withObjectFactoryType(ScatterGatherRouterFactoryBean.class).withSetterParameterDefinition("parallel", AttributeDefinition.Builder.fromSimpleParameter((String)"parallel").build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("aggregationStrategy", AttributeDefinition.Builder.fromChildConfiguration(AggregationStrategy.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asScope().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(WIRE_TAP).withTypeDefinition(TypeDefinition.fromType(WireTap.class)).withSetterParameterDefinition("tap", AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).withSetterParameterDefinition(FILTER, AttributeDefinition.Builder.fromChildConfiguration(Filter.class).build()).asScope().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(ENRICHER).withObjectFactoryType(MessageEnricherObjectFactory.class).withTypeDefinition(TypeDefinition.fromType(MessageEnricher.class)).withSetterParameterDefinition("messageProcessor", AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).withSetterParameterDefinition("enrichExpressionPairs", AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageEnricher.EnrichExpressionPair.class).build()).withSetterParameterDefinition("source", AttributeDefinition.Builder.fromSimpleParameter((String)"source").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter((String)"target").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("enrich").withTypeDefinition(TypeDefinition.fromType(MessageEnricher.EnrichExpressionPair.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"source").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"target").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(ASYNC).withTypeDefinition(TypeDefinition.fromType(AsyncDelegateMessageProcessor.class)).withObjectFactoryType(AsyncMessageProcessorsFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(TRY).withTypeDefinition(TypeDefinition.fromType(MessageProcessorChain.class)).withObjectFactoryType(TryProcessorFactoryBean.class).withSetterParameterDefinition(EXCEPTION_LISTENER_ATTRIBUTE, AttributeDefinition.Builder.fromChildConfiguration(MessagingExceptionHandler.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(TX_ACTION, AttributeDefinition.Builder.fromSimpleParameter((String)TX_ACTION).withDefaultValue((Object)"INDIFFERENT").build()).withSetterParameterDefinition(TX_TYPE, AttributeDefinition.Builder.fromSimpleParameter((String)TX_TYPE, this.getTransactionTypeConverter()).withDefaultValue((Object)TransactionType.LOCAL.name()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(UNTIL_SUCCESSFUL).withTypeDefinition(TypeDefinition.fromType(UntilSuccessful.class)).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"objectStore-ref").build()).withSetterParameterDefinition("maxRetries", AttributeDefinition.Builder.fromSimpleParameter((String)"maxRetries").withDefaultValue((Object)5).build()).withSetterParameterDefinition("millisBetweenRetries", AttributeDefinition.Builder.fromSimpleParameter((String)"millisBetweenRetries").build()).withSetterParameterDefinition("secondsBetweenRetries", AttributeDefinition.Builder.fromSimpleParameter((String)"secondsBetweenRetries").build()).withSetterParameterDefinition("failureExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"failureExpression").build()).withSetterParameterDefinition("ackExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"ackExpression").build()).withSetterParameterDefinition("synchronous", AttributeDefinition.Builder.fromSimpleParameter((String)"synchronous").withDefaultValue((Object)false).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(FOREACH).withTypeDefinition(TypeDefinition.fromType(Foreach.class)).withSetterParameterDefinition("collectionExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"collection").build()).withSetterParameterDefinition("batchSize", AttributeDefinition.Builder.fromSimpleParameter((String)"batchSize").build()).withSetterParameterDefinition("rootMessageVariableName", AttributeDefinition.Builder.fromSimpleParameter((String)"rootMessageVariableName").build()).withSetterParameterDefinition("counterVariableName", AttributeDefinition.Builder.fromSimpleParameter((String)"counterVariableName").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(FIRST_SUCCESSFUL).withTypeDefinition(TypeDefinition.fromType(FirstSuccessful.class)).withSetterParameterDefinition("failureExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"failureExpression").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(ROUND_ROBIN).withTypeDefinition(TypeDefinition.fromType(RoundRobin.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(CHOICE).withTypeDefinition(TypeDefinition.fromType(ChoiceRouter.class)).withObjectFactoryType(ChoiceRouterFactoryBean.class).withSetterParameterDefinition("routes", AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorFilterPair.class).build()).withSetterParameterDefinition("defaultRoute", AttributeDefinition.Builder.fromChildConfiguration(MessageProcessorFilterPair.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(WHEN).withTypeDefinition(TypeDefinition.fromType(MessageProcessorFilterPair.class)).withObjectFactoryType(MessageProcessorFilterPairFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(OTHERWISE).withTypeDefinition(TypeDefinition.fromType(MessageProcessorFilterPair.class)).withObjectFactoryType(MessageProcessorFilterPairFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromFixedValue((Object)"true").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(ALL).withTypeDefinition(TypeDefinition.fromType(MulticastingRouter.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("message-chunk-splitter").withTypeDefinition(TypeDefinition.fromType(MessageChunkSplitter.class)).withSetterParameterDefinition("messageSize", AttributeDefinition.Builder.fromSimpleParameter((String)"messageSize").build()).build());
        ComponentBuildingDefinition.Builder baseAggregatorDefinition = baseDefinition.copy().withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("failOnTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"failOnTimeout").build()).withSetterParameterDefinition("processedGroupsObjectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"processed-groups-object-store").build()).withSetterParameterDefinition("eventGroupsObjectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"event-groups-object-store").build()).withSetterParameterDefinition("persistentStores", AttributeDefinition.Builder.fromSimpleParameter((String)"persistentStores").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter((String)"storePrefix").build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.copy().withIdentifier("message-chunk-aggregator").withTypeDefinition(TypeDefinition.fromType(MessageChunkAggregator.class)).build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.copy().withIdentifier("collection-aggregator").withTypeDefinition(TypeDefinition.fromType(SimpleCollectionAggregator.class)).build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.copy().withIdentifier("resequencer").withTypeDefinition(TypeDefinition.fromType(Resequencer.class)).build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.copy().withIdentifier("custom-aggregator").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("splitter").withTypeDefinition(TypeDefinition.fromType(Splitter.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-splitter").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(REQUEST_REPLY).withTypeDefinition(TypeDefinition.fromType(SimpleAsyncRequestReplyRequester.class)).withSetterParameterDefinition("messageProcessor", AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).withSetterParameterDefinition("messageSource", AttributeDefinition.Builder.fromChildConfiguration(MessageSource.class).build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter((String)"storePrefix").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier(SCHEDULER).withTypeDefinition(TypeDefinition.fromType(DefaultSchedulerMessageSource.class)).withObjectFactoryType(SchedulingMessageSourceFactoryBean.class).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter((String)"frequency").build()).withSetterParameterDefinition(SCHEDULER, AttributeDefinition.Builder.fromChildConfiguration(PeriodicScheduler.class).withWrapperIdentifier("scheduling-strategy").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("fixed-frequency").withTypeDefinition(TypeDefinition.fromType(FixedFrequencyScheduler.class)).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter((String)"frequency").build()).withSetterParameterDefinition("startDelay", AttributeDefinition.Builder.fromSimpleParameter((String)"startDelay").build()).withSetterParameterDefinition("timeUnit", AttributeDefinition.Builder.fromSimpleParameter((String)"timeUnit").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("cron").withTypeDefinition(TypeDefinition.fromType(CronScheduler.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).withSetterParameterDefinition("timeZone", AttributeDefinition.Builder.fromSimpleParameter((String)"timeZone").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("redelivery-policy").withTypeDefinition(TypeDefinition.fromType(IdempotentRedeliveryPolicy.class)).withSetterParameterDefinition("useSecureHash", AttributeDefinition.Builder.fromSimpleParameter((String)"useSecureHash").build()).withSetterParameterDefinition("messageDigestAlgorithm", AttributeDefinition.Builder.fromSimpleParameter((String)"messageDigestAlgorithm").build()).withSetterParameterDefinition("maxRedeliveryCount", AttributeDefinition.Builder.fromSimpleParameter((String)"maxRedeliveryCount").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"idExpression").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"idExpression").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"object-store-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("composite-source").withTypeDefinition(TypeDefinition.fromType(StartableCompositeMessageSource.class)).withSetterParameterDefinition("messageSources", AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageSource.class).build()).withSetterParameterDefinition("muleContext", AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("configuration").withTypeDefinition(TypeDefinition.fromType(MuleConfiguration.class)).withObjectFactoryType(MuleConfigurationConfigurator.class).withSetterParameterDefinition("defaultErrorHandlerName", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultErrorHandler-ref").build()).withSetterParameterDefinition("defaultProcessingStrategy", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"defaultProcessingStrategy").build()).withSetterParameterDefinition("defaultResponseTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultResponseTimeout").build()).withSetterParameterDefinition("maxQueueTransactionFilesSize", AttributeDefinition.Builder.fromSimpleParameter((String)"maxQueueTransactionFilesSize").build()).withSetterParameterDefinition("defaultTransactionTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultTransactionTimeout").build()).withSetterParameterDefinition("shutdownTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"shutdownTimeout").build()).withSetterParameterDefinition("defaultTransactionTimeout", AttributeDefinition.Builder.fromSimpleParameter((String)"defaultTransactionTimeout").build()).withSetterParameterDefinition("useExtendedTransformations", AttributeDefinition.Builder.fromSimpleParameter((String)"useExtendedTransformations").build()).withSetterParameterDefinition("flowEndingWithOneWayEndpointReturnsNull", AttributeDefinition.Builder.fromSimpleParameter((String)"flowEndingWithOneWayEndpointReturnsNull").build()).withSetterParameterDefinition("enricherPropagatesSessionVariableChanges", AttributeDefinition.Builder.fromSimpleParameter((String)"enricherPropagatesSessionVariableChanges").build()).withSetterParameterDefinition("extensions", AttributeDefinition.Builder.fromChildCollectionConfiguration(Object.class).build()).withSetterParameterDefinition("defaultObjectSerializer", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"defaultObjectSerializer-ref").build()).withSetterParameterDefinition("extensions", AttributeDefinition.Builder.fromChildCollectionConfiguration(ConfigurationExtension.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("notifications").withTypeDefinition(TypeDefinition.fromType(ServerNotificationManagerConfigurator.class)).withSetterParameterDefinition("notificationDynamic", AttributeDefinition.Builder.fromSimpleParameter((String)"dynamic").build()).withSetterParameterDefinition("enabledNotifications", AttributeDefinition.Builder.fromChildCollectionConfiguration(NotificationConfig.EnabledNotificationConfig.class).build()).withSetterParameterDefinition("disabledNotifications", AttributeDefinition.Builder.fromChildCollectionConfiguration(NotificationConfig.DisabledNotificationConfig.class).build()).withSetterParameterDefinition("notificationListeners", AttributeDefinition.Builder.fromChildCollectionConfiguration(ListenerSubscriptionPair.class).build()).build());
        ComponentBuildingDefinition.Builder baseNotificationDefinition = baseDefinition.copy().withSetterParameterDefinition("interfaseName", AttributeDefinition.Builder.fromSimpleParameter((String)"interface").build()).withSetterParameterDefinition("eventName", AttributeDefinition.Builder.fromSimpleParameter((String)"event").build()).withSetterParameterDefinition("interfaceClass", AttributeDefinition.Builder.fromSimpleParameter((String)"interface-class").build()).withSetterParameterDefinition("eventClass", AttributeDefinition.Builder.fromSimpleParameter((String)"event-class").build());
        componentBuildingDefinitions.add(baseNotificationDefinition.copy().withTypeDefinition(TypeDefinition.fromType(NotificationConfig.EnabledNotificationConfig.class)).withIdentifier("notification").build());
        componentBuildingDefinitions.add(baseNotificationDefinition.copy().withTypeDefinition(TypeDefinition.fromType(NotificationConfig.DisabledNotificationConfig.class)).withIdentifier("disable-notification").build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("notification-listener").withTypeDefinition(TypeDefinition.fromType(ListenerSubscriptionPair.class)).withSetterParameterDefinition("listener", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).withSetterParameterDefinition("subscription", AttributeDefinition.Builder.fromSimpleParameter((String)"subscription").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("username-password-filter").withTypeDefinition(TypeDefinition.fromType(SecurityFilterMessageProcessor.class)).withObjectFactoryType(UsernamePasswordFilterObjectFactory.class).withSetterParameterDefinition("username", AttributeDefinition.Builder.fromSimpleParameter((String)"username").build()).withSetterParameterDefinition("password", AttributeDefinition.Builder.fromSimpleParameter((String)"password").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-security-filter").withTypeDefinition(TypeDefinition.fromType(SecurityFilterMessageProcessor.class)).withObjectFactoryType(CustomSecurityFilterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("encryption-security-filter").withTypeDefinition(TypeDefinition.fromType(SecurityFilterMessageProcessor.class)).withObjectFactoryType(EncryptionSecurityFilterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"strategy-ref").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("redelivery-policy").withTypeDefinition(TypeDefinition.fromType(IdempotentRedeliveryPolicy.class)).withSetterParameterDefinition("maxRedeliveryCount", AttributeDefinition.Builder.fromSimpleParameter((String)"maxRedeliveryCount").build()).withSetterParameterDefinition("useSecureHash", AttributeDefinition.Builder.fromSimpleParameter((String)"useSecureHash").build()).withSetterParameterDefinition("messageDigestAlgorithm", AttributeDefinition.Builder.fromSimpleParameter((String)"messageDigestAlgorithm").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"idExpression").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"object-store-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-router").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("singleton-object").withTypeDefinition(TypeDefinition.fromType(SingletonObjectFactory.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Map.class).withDefaultValue(new HashMap()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("prototype-object").withTypeDefinition(TypeDefinition.fromType(PrototypeObjectFactory.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Map.class).withDefaultValue(new HashMap()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("pooling-profile").withTypeDefinition(TypeDefinition.fromType(PoolingProfile.class)).withSetterParameterDefinition("maxActive", AttributeDefinition.Builder.fromSimpleParameter((String)"maxActive").build()).withSetterParameterDefinition("maxIdle", AttributeDefinition.Builder.fromSimpleParameter((String)"maxIdle").build()).withSetterParameterDefinition("exhaustedAction", AttributeDefinition.Builder.fromSimpleParameter((String)"exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS::get).build()).withSetterParameterDefinition("maxWait", AttributeDefinition.Builder.fromSimpleParameter((String)"maxWait").build()).withSetterParameterDefinition("evictionCheckIntervalMillis", AttributeDefinition.Builder.fromSimpleParameter((String)"evictionCheckIntervalMillis").build()).withSetterParameterDefinition("minEvictionMillis", AttributeDefinition.Builder.fromSimpleParameter((String)"minEvictionMillis").build()).withSetterParameterDefinition("disabled", AttributeDefinition.Builder.fromSimpleParameter((String)"disabled").build()).withSetterParameterDefinition("initialisationPolicy", AttributeDefinition.Builder.fromSimpleParameter((String)"initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES::get).build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("expression-component").withTypeDefinition(TypeDefinition.fromType(ExpressionLanguageComponent.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromTextContent().build()).withSetterParameterDefinition("expressionFile", AttributeDefinition.Builder.fromSimpleParameter((String)"file").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("expression-component").withTypeDefinition(TypeDefinition.fromType(ExpressionLanguageComponent.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromTextContent().build()).withSetterParameterDefinition("expressionFile", AttributeDefinition.Builder.fromSimpleParameter((String)"file").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("invoke").withTypeDefinition(TypeDefinition.fromType(InvokerMessageProcessor.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).withSetterParameterDefinition("methodName", AttributeDefinition.Builder.fromSimpleParameter((String)"method").build()).withSetterParameterDefinition("argumentExpressionsString", AttributeDefinition.Builder.fromSimpleParameter((String)"methodArguments").build()).withSetterParameterDefinition("object", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"object-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-source").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-agent").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).asPrototype().build());
        componentBuildingDefinitions.addAll(this.getTransformersBuildingDefinitions());
        componentBuildingDefinitions.addAll(this.getComponentsDefinitions());
        componentBuildingDefinitions.addAll(this.getEntryPointResolversDefinitions());
        componentBuildingDefinitions.addAll(this.getStreamingDefinitions());
        componentBuildingDefinitions.addAll(this.getFiltersDefinitions());
        componentBuildingDefinitions.addAll(this.getReconnectionDefinitions());
        componentBuildingDefinitions.addAll(this.getTransactionDefinitions());
        return componentBuildingDefinitions;
    }

    private TypeConverter<String, TransactionType> getTransactionTypeConverter() {
        return TransactionType::valueOf;
    }

    private List<ComponentBuildingDefinition> getFiltersDefinitions() {
        LinkedList<ComponentBuildingDefinition> definitions = new LinkedList<ComponentBuildingDefinition>();
        definitions.add(baseDefinition.copy().withIdentifier("and-filter").withTypeDefinition(TypeDefinition.fromType(AndFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(Filter.class).build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("or-filter").withTypeDefinition(TypeDefinition.fromType(OrFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(Filter.class).build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("not-filter").withTypeDefinition(TypeDefinition.fromType(NotFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Filter.class).build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("regex-filter").withTypeDefinition(TypeDefinition.fromType(RegExFilter.class)).withSetterParameterDefinition("flags", AttributeDefinition.Builder.fromSimpleParameter((String)"flags", value -> {
            String[] flagStrings;
            String flags = (String)value;
            int combinedFlags = 0;
            for (String flagString : flagStrings = StringUtils.split((String)flags, (char)',')) {
                Integer flag = this.regExFlagsMapping.get(flagString);
                if (flag == null) {
                    String message = String.format("Invalid flag '%1s'. Must be one of %2s", flagString, this.regExFlagsMapping.keySet().toString());
                    throw new IllegalArgumentException(message);
                }
                combinedFlags |= flag.intValue();
            }
            return combinedFlags;
        }).build()).withSetterParameterDefinition("pattern", AttributeDefinition.Builder.fromSimpleParameter((String)"pattern").build()).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("exception-type-filter").withTypeDefinition(TypeDefinition.fromType(ExceptionTypeFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"expectedType", (TypeConverter)CommonTypeConverters.stringToClassConverter()).build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("message-property-filter").withTypeDefinition(TypeDefinition.fromType(MessagePropertyFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"pattern").build()).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter((String)"value").build()).withSetterParameterDefinition("scope", AttributeDefinition.Builder.fromSimpleParameter((String)"scope").build()).withSetterParameterDefinition("caseSensitive", AttributeDefinition.Builder.fromSimpleParameter((String)"caseSensitive").build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("payload-type-filter").withTypeDefinition(TypeDefinition.fromType(PayloadTypeFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"expectedType", (TypeConverter)CommonTypeConverters.stringToClassConverter()).build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("wildcard-filter").withTypeDefinition(TypeDefinition.fromType(WildcardFilter.class)).withSetterParameterDefinition("caseSensitive", AttributeDefinition.Builder.fromSimpleParameter((String)"caseSensitive").build()).withSetterParameterDefinition("pattern", AttributeDefinition.Builder.fromSimpleParameter((String)"pattern").build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("equals-filter").withTypeDefinition(TypeDefinition.fromType(EqualsFilter.class)).withSetterParameterDefinition("pattern", AttributeDefinition.Builder.fromSimpleParameter((String)"pattern").build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("expression-filter").withTypeDefinition(TypeDefinition.fromType(ExpressionFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).withSetterParameterDefinition("nullReturnsTrue", AttributeDefinition.Builder.fromSimpleParameter((String)"nullReturnsTrue").build()).build());
        definitions.add(baseDefinition.copy().withIdentifier("custom-filter").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).asPrototype().build());
        ComponentBuildingDefinition.Builder baseIdempotentMessageFilterDefinition = baseDefinition.copy().withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"idExpression").build()).withSetterParameterDefinition("valueExpression", AttributeDefinition.Builder.fromSimpleParameter((String)"valueExpression").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter((String)"storePrefix").build()).withSetterParameterDefinition("throwOnUnaccepted", AttributeDefinition.Builder.fromSimpleParameter((String)"throwOnUnaccepted").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"objectStore").build()).withSetterParameterDefinition("unacceptedMessageProcessor", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"onUnaccepted").build());
        definitions.add(baseIdempotentMessageFilterDefinition.copy().withIdentifier("idempotent-message-validator").withTypeDefinition(TypeDefinition.fromType(IdempotentMessageValidator.class)).build());
        definitions.add(baseIdempotentMessageFilterDefinition.copy().withIdentifier("idempotent-secure-hash-message-validator").withTypeDefinition(TypeDefinition.fromType(IdempotentSecureHashMessageValidator.class)).withSetterParameterDefinition("messageDigestAlgorithm", AttributeDefinition.Builder.fromSimpleParameter((String)"messageDigestAlgorithm").build()).build());
        return definitions;
    }

    private List<ComponentBuildingDefinition> getTransformersBuildingDefinitions() {
        ArrayList<ComponentBuildingDefinition> transformerComponentBuildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(Base64Encoder.class, new KeyAttributeDefinitionPair[0]).withIdentifier("base64-encoder-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(Base64Decoder.class, new KeyAttributeDefinitionPair[0]).withIdentifier("base64-decoder-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(XmlEntityEncoder.class, new KeyAttributeDefinitionPair[0]).withIdentifier("xml-entity-encoder-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(XmlEntityDecoder.class, new KeyAttributeDefinitionPair[0]).withIdentifier("xml-entity-decoder-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(GZipCompressTransformer.class, new KeyAttributeDefinitionPair[0]).withIdentifier("gzip-compress-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(GZipUncompressTransformer.class, new KeyAttributeDefinitionPair[0]).withIdentifier("gzip-uncompress-transformer").build());
        KeyAttributeDefinitionPair strategyParameterDefinition = KeyAttributeDefinitionPair.newBuilder().withKey("strategy").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"strategy-ref").build()).build();
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(this.getEncryptionTransformerConfigurationFactory(EncryptionTransformer.class), EncryptionTransformer.class, strategyParameterDefinition).withIdentifier("encrypt-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(this.getEncryptionTransformerConfigurationFactory(DecryptionTransformer.class), DecryptionTransformer.class, strategyParameterDefinition).withIdentifier("decrypt-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ByteArrayToHexString.class, new KeyAttributeDefinitionPair[0]).withIdentifier("byte-array-to-hex-string-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(HexStringToByteArray.class, new KeyAttributeDefinitionPair[0]).withIdentifier("hex-string-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ByteArrayToObject.class, new KeyAttributeDefinitionPair[0]).withIdentifier("byte-array-to-object-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ObjectToByteArray.class, new KeyAttributeDefinitionPair[0]).withIdentifier("object-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ObjectToString.class, new KeyAttributeDefinitionPair[0]).withIdentifier("object-to-string-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ByteArrayToSerializable.class, new KeyAttributeDefinitionPair[0]).withIdentifier("byte-array-to-serializable-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(SerializableToByteArray.class, new KeyAttributeDefinitionPair[0]).withIdentifier("serializable-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ObjectToString.class, new KeyAttributeDefinitionPair[0]).withIdentifier("byte-array-to-string-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(ObjectToByteArray.class, new KeyAttributeDefinitionPair[0]).withIdentifier("string-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getMuleMessageTransformerBaseBuilder().withIdentifier("parse-template").withTypeDefinition(TypeDefinition.fromType(ParseTemplateTransformer.class)).withSetterParameterDefinition("location", AttributeDefinition.Builder.fromSimpleParameter((String)"location").build()).build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(AutoTransformer.class, new KeyAttributeDefinitionPair[0]).withIdentifier("auto-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(MapToBean.class, new KeyAttributeDefinitionPair[0]).withIdentifier("map-to-bean-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(BeanToMap.class, new KeyAttributeDefinitionPair[0]).withIdentifier("bean-to-map-transformer").build());
        transformerComponentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("combine-collections-transformer").withTypeDefinition(TypeDefinition.fromType(CombineCollectionsTransformer.class)).asPrototype().build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getMuleMessageTransformerBaseBuilder().withIdentifier("append-string-transformer").withTypeDefinition(TypeDefinition.fromType(StringAppendTransformer.class)).withSetterParameterDefinition("message", AttributeDefinition.Builder.fromSimpleParameter((String)"message").build()).build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(this.getCustomTransformerConfigurationFactory(), Transformer.class, KeyAttributeDefinitionPair.newBuilder().withKey(CLASS_ATTRIBUTE).withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE).build()).build()).withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).withIdentifier("custom-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(this.getBeanBuilderTransformerConfigurationfactory(), BeanBuilderTransformer.class, KeyAttributeDefinitionPair.newBuilder().withKey("beanClass").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"beanClass", (TypeConverter)CommonTypeConverters.stringToClassConverter()).build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("beanFactory").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"beanFactory-ref").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("arguments").withAttributeDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(ExpressionArgument.class).build()).build()).withIdentifier("bean-builder-transformer").build());
        transformerComponentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder(this.getExpressionTransformerConfigurationfactory(), ExpressionTransformer.class, KeyAttributeDefinitionPair.newBuilder().withKey("returnSourceIfNull").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"returnSourceIfNull").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("expression").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("arguments").withAttributeDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(ExpressionArgument.class).build()).build()).withIdentifier("expression-transformer").withTypeDefinition(TypeDefinition.fromType(ExpressionTransformer.class)).build());
        transformerComponentBuildingDefinitions.add(baseDefinition.copy().withObjectFactoryType(ConfigurableObjectFactory.class).withIdentifier("return-argument").withTypeDefinition(TypeDefinition.fromType(ExpressionArgument.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)this.getExpressionArgumentConfigurationFactory()).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])new KeyAttributeDefinitionPair[]{KeyAttributeDefinitionPair.newBuilder().withKey("optional").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"optional").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("expression").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build()}).build()).build());
        transformerComponentBuildingDefinitions.add(baseDefinition.copy().withObjectFactoryType(ConfigurableObjectFactory.class).withIdentifier("bean-property").withTypeDefinition(TypeDefinition.fromType(ExpressionArgument.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)this.getExpressionArgumentConfigurationFactory()).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])new KeyAttributeDefinitionPair[]{KeyAttributeDefinitionPair.newBuilder().withKey("optional").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"optional").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("expression").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"expression").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("propertyName").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"property-name").build()).build()}).build()).build());
        return transformerComponentBuildingDefinitions;
    }

    private ConfigurableInstanceFactory getAddFlowVariableTransformerInstanceFactory(Class<? extends AbstractAddVariablePropertyProcessor> transformerType) {
        return parameters -> {
            AbstractAddVariablePropertyProcessor transformer = (AbstractAddVariablePropertyProcessor)CoreComponentBuildingDefinitionProvider.createNewInstance(transformerType);
            transformer.setIdentifier((String)parameters.get("identifier"));
            transformer.setValue((String)parameters.get("value"));
            return transformer;
        };
    }

    private ConfigurableInstanceFactory getEncryptionTransformerConfigurationFactory(Class<? extends AbstractEncryptionTransformer> abstractEncryptionTransformerType) {
        return parameters -> {
            AbstractEncryptionTransformer encryptionTransformer = (AbstractEncryptionTransformer)CoreComponentBuildingDefinitionProvider.createNewInstance(abstractEncryptionTransformerType);
            encryptionTransformer.setStrategy((EncryptionStrategy)parameters.get("strategy"));
            return encryptionTransformer;
        };
    }

    private ConfigurableInstanceFactory getCustomTransformerConfigurationFactory() {
        return parameters -> {
            String className = (String)parameters.get(CLASS_ATTRIBUTE);
            Preconditions.checkState((className != null ? 1 : 0) != 0, (String)"custom-transformer class attribute cannot be null");
            return CoreComponentBuildingDefinitionProvider.createNewInstance(className);
        };
    }

    private static Object createNewInstance(Class classType) {
        try {
            return ClassUtils.instantiateClass((Class)classType, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private static Object createNewInstance(String className) {
        try {
            return ClassUtils.instantiateClass((String)className, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private ConfigurableInstanceFactory getExpressionArgumentConfigurationFactory() {
        return parameters -> {
            String name = (String)parameters.get("propertyName");
            ExpressionArgument expressionArgument = new ExpressionArgument(name, new ExpressionConfig((String)parameters.get("expression")), Boolean.parseBoolean(Optional.ofNullable(parameters.get("optional")).orElse("false")));
            expressionArgument.setMuleContext((MuleContext)parameters.get("muleContext"));
            return expressionArgument;
        };
    }

    private ConfigurableInstanceFactory getExpressionTransformerConfigurationfactory() {
        return this.getAbstractTransformerConfigurationfactory(parameters -> {
            ExpressionTransformer expressionTransformer = new ExpressionTransformer();
            Boolean returnSourceIfNull = (Boolean)parameters.get("returnSourceIfNull");
            if (returnSourceIfNull != null) {
                expressionTransformer.setReturnSourceIfNull(returnSourceIfNull.booleanValue());
            }
            return expressionTransformer;
        });
    }

    private ConfigurableInstanceFactory getBeanBuilderTransformerConfigurationfactory() {
        return this.getAbstractTransformerConfigurationfactory(parameters -> {
            BeanBuilderTransformer beanBuilderTransformer = new BeanBuilderTransformer();
            beanBuilderTransformer.setBeanClass((Class)parameters.get("beanClass"));
            beanBuilderTransformer.setBeanFactory((ObjectFactory)parameters.get("beanFactory"));
            return beanBuilderTransformer;
        });
    }

    private ConfigurableInstanceFactory getAbstractTransformerConfigurationfactory(Function<Map<String, Object>, AbstractExpressionTransformer> abstractExpressionTransformerFactory) {
        return parameters -> {
            List<ExpressionArgument> arguments = (List<ExpressionArgument>)parameters.get("arguments");
            String expression = (String)parameters.get("expression");
            AbstractExpressionTransformer abstractExpressionTransformer = (AbstractExpressionTransformer)abstractExpressionTransformerFactory.apply(parameters);
            if (expression != null && arguments != null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expression transformer do not support expression attribute or return-data child element at the same time."));
            }
            if (expression != null) {
                arguments = Arrays.asList(new ExpressionArgument("single", new ExpressionConfig(expression), false));
            }
            abstractExpressionTransformer.setArguments((List)arguments);
            return abstractExpressionTransformer;
        };
    }

    public static ComponentBuildingDefinition.Builder getSetVariablePropertyBaseBuilder(ConfigurableInstanceFactory configurableInstanceFactory, Class<? extends AbstractAddVariablePropertyProcessor> setterClass, KeyAttributeDefinitionPair ... configurationAttributes) {
        Object[] commonTransformerParameters = new KeyAttributeDefinitionPair[]{KeyAttributeDefinitionPair.newBuilder().withKey("encoding").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"encoding").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("mimeType").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"mimeType").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build()};
        return baseDefinition.copy().withTypeDefinition(TypeDefinition.fromType(setterClass)).withObjectFactoryType(((Object)((Object)new ConfigurableObjectFactory())).getClass()).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)configurableInstanceFactory).build()).withSetterParameterDefinition("commonConfiguratorType", AttributeDefinition.Builder.fromFixedValue(AddVariablePropertyConfigurator.class).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])((KeyAttributeDefinitionPair[])ArrayUtils.addAll((Object[])commonTransformerParameters, (Object[])configurationAttributes))).build()).asPrototype().copy();
    }

    public static ComponentBuildingDefinition.Builder getTransformerBaseBuilder(ConfigurableInstanceFactory configurableInstanceFactory, Class<? extends Transformer> transformerClass, KeyAttributeDefinitionPair ... configurationAttributes) {
        Object[] commonTransformerParameters = new KeyAttributeDefinitionPair[]{KeyAttributeDefinitionPair.newBuilder().withKey("encoding").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"encoding").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey(NAME).withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)NAME).build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("ignoreBadInput").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"ignoreBadInput").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("mimeType").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"mimeType").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("returnClass").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"returnClass").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build()};
        return baseDefinition.copy().withTypeDefinition(TypeDefinition.fromType(transformerClass)).withObjectFactoryType(((Object)((Object)new ConfigurableObjectFactory())).getClass()).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)configurableInstanceFactory).build()).withSetterParameterDefinition("commonConfiguratorType", AttributeDefinition.Builder.fromFixedValue(TransformerConfigurator.class).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])((KeyAttributeDefinitionPair[])ArrayUtils.addAll((Object[])commonTransformerParameters, (Object[])configurationAttributes))).build()).asPrototype().copy();
    }

    private List<ComponentBuildingDefinition> getComponentsDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        ComponentBuildingDefinition.Builder componentDefinition = baseDefinition.copy().withSetterParameterDefinition("clazz", AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE).build()).withSetterParameterDefinition("objectFactory", AttributeDefinition.Builder.fromChildConfiguration(ObjectFactory.class).build()).withSetterParameterDefinition("entryPointResolverSet", AttributeDefinition.Builder.fromChildConfiguration(EntryPointResolverSet.class).build()).withSetterParameterDefinition("entryPointResolver", AttributeDefinition.Builder.fromChildConfiguration(EntryPointResolver.class).build()).withSetterParameterDefinition("lifecycleAdapterFactory", AttributeDefinition.Builder.fromChildConfiguration(LifecycleAdapterFactory.class).build()).withSetterParameterDefinition("interceptors", AttributeDefinition.Builder.fromChildCollectionConfiguration(Interceptor.class).build());
        buildingDefinitions.add(componentDefinition.copy().withIdentifier("component").withTypeDefinition(TypeDefinition.fromType(DefaultJavaComponent.class)).withObjectFactoryType(ComponentObjectFactory.class).build());
        buildingDefinitions.add(componentDefinition.copy().withIdentifier("pooled-component").withTypeDefinition(TypeDefinition.fromType(PooledJavaComponent.class)).withObjectFactoryType(PooledComponentObjectFactory.class).withSetterParameterDefinition("poolingProfile", AttributeDefinition.Builder.fromChildConfiguration(PoolingProfile.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-interceptor").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("timer-interceptor").withTypeDefinition(TypeDefinition.fromType(TimerInterceptor.class)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("logging-interceptor").withTypeDefinition(TypeDefinition.fromType(LoggingInterceptor.class)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("log-component").withTypeDefinition(TypeDefinition.fromType(DefaultJavaComponent.class)).withObjectFactoryType(ComponentObjectFactory.class).withSetterParameterDefinition("usePrototypeObjectFactory", AttributeDefinition.Builder.fromFixedValue((Object)false).build()).withSetterParameterDefinition("clazz", AttributeDefinition.Builder.fromFixedValue(LogComponent.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("null-component").withTypeDefinition(TypeDefinition.fromType(DefaultJavaComponent.class)).withObjectFactoryType(ComponentObjectFactory.class).withSetterParameterDefinition("usePrototypeObjectFactory", AttributeDefinition.Builder.fromFixedValue((Object)false).build()).withSetterParameterDefinition("clazz", AttributeDefinition.Builder.fromFixedValue(NullComponent.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("static-component").withTypeDefinition(TypeDefinition.fromType(DefaultJavaComponent.class)).withObjectFactoryType(ComponentObjectFactory.class).withSetterParameterDefinition("usePrototypeObjectFactory", AttributeDefinition.Builder.fromFixedValue((Object)false).build()).withSetterParameterDefinition("clazz", AttributeDefinition.Builder.fromFixedValue(StaticComponent.class).build()).withSetterParameterDefinition("staticData", AttributeDefinition.Builder.fromChildConfiguration(String.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("echo-component").withTypeDefinition(TypeDefinition.fromType(DefaultJavaComponent.class)).withObjectFactoryType(ComponentObjectFactory.class).withSetterParameterDefinition("usePrototypeObjectFactory", AttributeDefinition.Builder.fromFixedValue((Object)false).build()).withSetterParameterDefinition("clazz", AttributeDefinition.Builder.fromFixedValue(EchoComponent.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("pooling-profile").withTypeDefinition(TypeDefinition.fromType(PoolingProfile.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxActive").withDefaultValue((Object)5).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxIdle").withDefaultValue((Object)5).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxWait", value -> Long.valueOf((String)value)).withDefaultValue((Object)String.valueOf(4000L)).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS::get).withDefaultValue((Object)String.valueOf(2)).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES::get).withDefaultValue((Object)String.valueOf(1)).build()).withSetterParameterDefinition("disabled", AttributeDefinition.Builder.fromSimpleParameter((String)"disabled").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("return-data").withTypeDefinition(TypeDefinition.fromType(String.class)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("singleton-object").withTypeDefinition(TypeDefinition.fromType(SingletonObjectFactory.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE, (TypeConverter)CommonTypeConverters.stringToClassConverter()).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Map.class).withDefaultValue(new HashMap()).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("prototype-object").withTypeDefinition(TypeDefinition.fromType(PrototypeObjectFactory.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)CLASS_ATTRIBUTE, (TypeConverter)CommonTypeConverters.stringToClassConverter()).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Map.class).withDefaultValue(new HashMap()).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("spring-object").withTypeDefinition(TypeDefinition.fromType(SpringBeanLookup.class)).withSetterParameterDefinition("bean", AttributeDefinition.Builder.fromSimpleParameter((String)"bean").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-lifecycle-adapter-factory").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.addAll(this.getBytesStreamingDefinitions());
        buildingDefinitions.addAll(this.getObjectsStreamingDefinitions());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getBytesStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("repeatable-in-memory-stream").withTypeDefinition(TypeDefinition.fromType(CursorStreamProviderFactory.class)).withObjectFactoryType(InMemoryCursorStreamProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"initialBufferSize").withDefaultValue((Object)512).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"bufferSizeIncrement").withDefaultValue((Object)512).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxBufferSize").withDefaultValue((Object)1024).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"bufferUnit", value -> DataUnit.valueOf((String)((String)value))).withDefaultValue((Object)ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("non-repeatable-stream").withTypeDefinition(TypeDefinition.fromType(CursorStreamProviderFactory.class)).withObjectFactoryType(NullCursorStreamProviderObjectFactory.class).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getObjectsStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("repeatable-in-memory-iterable").withTypeDefinition(TypeDefinition.fromType(CursorIteratorProviderFactory.class)).withObjectFactoryType(InMemoryCursorIteratorProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"initialBufferSize").withDefaultValue((Object)100).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"bufferSizeIncrement").withDefaultValue((Object)100).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)"maxBufferSize").withDefaultValue((Object)500).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("non-repeatable-iterable").withTypeDefinition(TypeDefinition.fromType(CursorIteratorProviderFactory.class)).withObjectFactoryType(NullCursorIteratorProviderObjectFactory.class).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getEntryPointResolversDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-entry-point-resolver-set").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).withSetterParameterDefinition("entryPointResolvers", AttributeDefinition.Builder.fromChildCollectionConfiguration(EntryPointResolver.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("entry-point-resolver-set").withTypeDefinition(TypeDefinition.fromType(DefaultEntryPointResolverSet.class)).withSetterParameterDefinition("entryPointResolvers", AttributeDefinition.Builder.fromChildCollectionConfiguration(EntryPointResolver.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-entry-point-resolver").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("callable-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(CallableEntryPointResolver.class)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("method-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(ExplicitMethodEntryPointResolver.class)).withObjectFactoryType(ExplicitMethodEntryPointResolverObjectFactory.class).withSetterParameterDefinition("methodEntryPoints", AttributeDefinition.Builder.fromChildCollectionConfiguration(MethodEntryPoint.class).build()).withSetterParameterDefinition("acceptVoidMethods", AttributeDefinition.Builder.fromSimpleParameter((String)"acceptVoidMethods").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("include-entry-point").withTypeDefinition(TypeDefinition.fromType(MethodEntryPoint.class)).withSetterParameterDefinition("enabled", AttributeDefinition.Builder.fromFixedValue((Object)true).build()).withSetterParameterDefinition("method", AttributeDefinition.Builder.fromSimpleParameter((String)"method").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("exclude-entry-point").withTypeDefinition(TypeDefinition.fromType(MethodEntryPoint.class)).withSetterParameterDefinition("enabled", AttributeDefinition.Builder.fromFixedValue((Object)false).build()).withSetterParameterDefinition("method", AttributeDefinition.Builder.fromSimpleParameter((String)"method").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("property-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(MethodHeaderPropertyEntryPointResolver.class)).withSetterParameterDefinition("methodProperty", AttributeDefinition.Builder.fromSimpleParameter((String)"property").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("property-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(MethodHeaderPropertyEntryPointResolver.class)).withSetterParameterDefinition("methodProperty", AttributeDefinition.Builder.fromSimpleParameter((String)"property").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("reflection-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(ReflectionEntryPointResolver.class)).withSetterParameterDefinition("ignoredMethods", AttributeDefinition.Builder.fromChildConfiguration(List.class).withIdentifier("exclude-object-methods").build()).withSetterParameterDefinition("ignoredMethods", AttributeDefinition.Builder.fromChildConfiguration(List.class).withIdentifier("exclude-entry-point").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("exclude-object-methods").withTypeDefinition(TypeDefinition.fromType(ExcludeDefaultObjectMethods.class)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("no-arguments-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(NoArgumentsEntryPointResolver.class)).withObjectFactoryType(NoArgumentsEntryPointResolverObjectFactory.class).withSetterParameterDefinition("excludeDefaultObjectMethods", AttributeDefinition.Builder.fromChildConfiguration(ExcludeDefaultObjectMethods.class).build()).withSetterParameterDefinition("methodEntryPoints", AttributeDefinition.Builder.fromChildCollectionConfiguration(MethodEntryPoint.class).build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("array-entry-point-resolver").withTypeDefinition(TypeDefinition.fromType(ArrayEntryPointResolver.class)).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getReconnectionDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        ComponentBuildingDefinition.Builder baseReconnectDefinition = baseDefinition.copy().withTypeDefinition(TypeDefinition.fromType(RetryPolicyTemplate.class)).withObjectFactoryType(RetryPolicyTemplateObjectFactory.class).withSetterParameterDefinition("blocking", AttributeDefinition.Builder.fromSimpleParameter((String)"blocking").build()).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter((String)"frequency").build());
        buildingDefinitions.add(baseReconnectDefinition.copy().withIdentifier("reconnect-forever").withSetterParameterDefinition("count", AttributeDefinition.Builder.fromFixedValue((Object)-1).build()).build());
        buildingDefinitions.add(baseReconnectDefinition.copy().withIdentifier("reconnect").withSetterParameterDefinition("retryNotifier", AttributeDefinition.Builder.fromChildConfiguration(RetryNotifier.class).build()).withSetterParameterDefinition("count", AttributeDefinition.Builder.fromSimpleParameter((String)"count").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("reconnect-custom-strategy").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).asPrototype().build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("reconnect-notifier").withTypeDefinition(TypeDefinition.fromType(ConnectNotifier.class)).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("reconnect-custom-notifier").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).asPrototype().build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getTransactionDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("xa-transaction").withTypeDefinition(TypeDefinition.fromType(MuleTransactionConfig.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue((Object)new XaTransactionFactory()).build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("actionAsString", AttributeDefinition.Builder.fromSimpleParameter((String)"action").build()).withSetterParameterDefinition("interactWithExternal", AttributeDefinition.Builder.fromSimpleParameter((String)"interactWithExternal").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-transaction").withTypeDefinition(TypeDefinition.fromType(MuleTransactionConfig.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"factory-ref").build()).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromSimpleParameter((String)"factory-class", o -> {
            try {
                return ClassUtils.instantiateClass((String)((String)o), (Object[])new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }).build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter((String)"timeout").build()).withSetterParameterDefinition("actionAsString", AttributeDefinition.Builder.fromSimpleParameter((String)"action").build()).withSetterParameterDefinition("interactWithExternal", AttributeDefinition.Builder.fromSimpleParameter((String)"interactWithExternal").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("environment").withTypeDefinition(TypeDefinition.fromType(Map.class)).withObjectFactoryType(EnvironmentPropertyObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter((String)"ref").build()).build());
        buildingDefinitions.add(baseDefinition.copy().withIdentifier("custom-transaction-manager").withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)CLASS_ATTRIBUTE)).withSetterParameterDefinition("environment", AttributeDefinition.Builder.fromChildConfiguration(Map.class).build()).build());
        return buildingDefinitions;
    }

    public static ComponentBuildingDefinition.Builder getTransformerBaseBuilder(Class<? extends AbstractTransformer> transformerClass, KeyAttributeDefinitionPair ... configurationAttributes) {
        return CoreComponentBuildingDefinitionProvider.getTransformerBaseBuilder((Map<String, Object> parameters) -> CoreComponentBuildingDefinitionProvider.createNewInstance(transformerClass), transformerClass, configurationAttributes);
    }

    public static ComponentBuildingDefinition.Builder getMuleMessageTransformerBaseBuilder() {
        return baseDefinition.copy().withSetterParameterDefinition("encoding", AttributeDefinition.Builder.fromSimpleParameter((String)"encoding").build()).withSetterParameterDefinition("mimeType", AttributeDefinition.Builder.fromSimpleParameter((String)"mimeType").build()).asPrototype().copy();
    }

    private ComponentBuildingDefinition.Builder createTransactionManagerDefinitionBuilder(String transactionManagerName, Class<?> transactionManagerClass) {
        return this.transactionManagerBaseDefinition.copy().withIdentifier(transactionManagerName).withTypeDefinition(TypeDefinition.fromType(transactionManagerClass));
    }

    private void addModuleOperationChainParser(LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions) {
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("module-operation-chain").withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(ModuleOperationMessageProcessorChainFactoryBean.class).withSetterParameterDefinition("properties", AttributeDefinition.Builder.fromChildMapConfiguration(String.class, String.class).withWrapperIdentifier("module-operation-properties").build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromChildMapConfiguration(String.class, String.class).withWrapperIdentifier("module-operation-parameters").build()).withSetterParameterDefinition("moduleName", AttributeDefinition.Builder.fromSimpleParameter((String)"moduleName").build()).withSetterParameterDefinition("moduleOperation", AttributeDefinition.Builder.fromSimpleParameter((String)"moduleOperation").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("module-operation-properties").withTypeDefinition(TypeDefinition.fromType(TreeMap.class)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("module-operation-property-entry").withTypeDefinition(TypeDefinition.fromMapEntryType(String.class, String.class)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("module-operation-parameters").withTypeDefinition(TypeDefinition.fromType(TreeMap.class)).build());
        componentBuildingDefinitions.add(baseDefinition.copy().withIdentifier("module-operation-parameter-entry").withTypeDefinition(TypeDefinition.fromMapEntryType(String.class, String.class)).build());
    }
}

