/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class MinimalApplicationModelGenerator {
    private ConfigurationDependencyResolver dependencyResolver;

    public MinimalApplicationModelGenerator(ConfigurationDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public ApplicationModel getMinimalModel(LazyComponentInitializer.ComponentLocationFilter filter) {
        List<ComponentModel> required = this.dependencyResolver.findRequiredComponentModels(filter);
        required.stream().forEach(componentModel -> {
            DefaultComponentLocation componentLocation = componentModel.getComponentLocation();
            if (componentLocation != null) {
                this.enableComponentDependencies((ComponentModel)componentModel, required);
            }
        });
        return this.dependencyResolver.getApplicationModel();
    }

    public ApplicationModel getMinimalModel(Location location) {
        ComponentModel requestedComponentModel = this.dependencyResolver.findRequiredComponentModel(location);
        this.enableComponentDependencies(requestedComponentModel, Collections.emptyList());
        return this.dependencyResolver.getApplicationModel();
    }

    private void enableComponentDependencies(ComponentModel requestedComponentModel, List<ComponentModel> requiredComponentModels) {
        Set<String> otherRequiredGlobalComponents = this.dependencyResolver.resolveComponentDependencies(requestedComponentModel);
        String requestComponentModelName = requestedComponentModel.getNameAttribute();
        if (requestComponentModelName != null && this.dependencyResolver.getApplicationModel().findTopLevelNamedElement(requestComponentModelName).isPresent()) {
            otherRequiredGlobalComponents.add(requestedComponentModel.getNameAttribute());
        }
        Set<String> allRequiredComponentModels = this.dependencyResolver.findComponentModelsDependencies(otherRequiredGlobalComponents);
        for (ComponentModel componentModel2 : this.dependencyResolver.getApplicationModel().getRootComponentModel().getInnerComponents()) {
            if (componentModel2.getNameAttribute() == null || !allRequiredComponentModels.contains(componentModel2.getNameAttribute())) continue;
            componentModel2.setEnabled(true);
            componentModel2.executedOnEveryInnerComponent(component -> component.setEnabled(true));
        }
        ComponentModel currentComponentModel = requestedComponentModel;
        for (ComponentModel parentModel = currentComponentModel.getParent(); parentModel != null && parentModel.getParent() != null; parentModel = parentModel.getParent()) {
            parentModel.setEnabled(true);
            for (ComponentModel innerComponent : parentModel.getInnerComponents()) {
                if (innerComponent.equals(currentComponentModel) || requiredComponentModels.contains(currentComponentModel)) continue;
                innerComponent.setEnabled(false);
                innerComponent.executedOnEveryInnerComponent(component -> component.setEnabled(false));
            }
            currentComponentModel = parentModel;
        }
        requestedComponentModel.setEnabled(true);
        requestedComponentModel.executedOnEveryInnerComponent(componentModel -> componentModel.setEnabled(true));
        this.dependencyResolver.getApplicationModel().getRootComponentModel().setEnabled(true);
    }
}

