/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.processor.xml;

import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.w3c.dom.Node;

public class XmlCustomAttributeHandler {
    public static final String IS_CDATA = "IS_CDATA";
    public static final String DECLARED_PREFIX = "DECLARED_PREFIX";
    public static final String NAMESPACE_URI = "NAMESPACE_URI";
    public static final String XML_NODE = "XML_NODE";
    public static final String LINE_NUMBER = "LINE_NUMBER";
    public static final String CONFIG_FILE_NAME = "CONFIG_FILE_NAME";

    public static ConfigLineCustomAttributeStore to(ConfigLine.Builder builder) {
        return new ConfigLineCustomAttributeStore(builder);
    }

    public static ConfigLineCustomAttributeRetrieve from(ConfigLine configLine) {
        return new ConfigLineCustomAttributeRetrieve(configLine);
    }

    public static ComponentCustomAttributeStore to(ComponentModel.Builder builder) {
        return new ComponentCustomAttributeStore(builder);
    }

    public static ComponentCustomAttributeRetrieve from(ComponentModel componentModel) {
        return new ComponentCustomAttributeRetrieve(componentModel);
    }

    public static class ComponentCustomAttributeRetrieve {
        private final ComponentModel componentModel;

        private ComponentCustomAttributeRetrieve(ComponentModel componentModel) {
            this.componentModel = componentModel;
        }

        public String getNamespaceUri() {
            return (String)this.componentModel.getCustomAttributes().get(XmlCustomAttributeHandler.NAMESPACE_URI);
        }

        public String getConfigFileName() {
            return (String)this.componentModel.getCustomAttributes().get(XmlCustomAttributeHandler.CONFIG_FILE_NAME);
        }

        public Node getNode() {
            return (Node)this.componentModel.getCustomAttributes().get(XmlCustomAttributeHandler.XML_NODE);
        }
    }

    public static class ComponentCustomAttributeStore {
        private final ComponentModel.Builder builder;

        private ComponentCustomAttributeStore(ComponentModel.Builder builder) {
            this.builder = builder;
        }

        public ComponentCustomAttributeStore addNode(Node node) {
            this.builder.addCustomAttribute(XmlCustomAttributeHandler.XML_NODE, node);
            this.builder.addCustomAttribute(XmlCustomAttributeHandler.NAMESPACE_URI, node.getNamespaceURI());
            this.builder.addCustomAttribute(XmlCustomAttributeHandler.NAMESPACE_URI, node.getNamespaceURI());
            if (node.getPrefix() != null) {
                this.builder.addCustomAttribute(XmlCustomAttributeHandler.DECLARED_PREFIX, node.getPrefix());
            }
            return this;
        }
    }

    public static class ConfigLineCustomAttributeRetrieve {
        private final ConfigLine configLine;

        private ConfigLineCustomAttributeRetrieve(ConfigLine configLine) {
            this.configLine = configLine;
        }

        public Node getNode() {
            return (Node)this.configLine.getCustomAttributes().get(XmlCustomAttributeHandler.XML_NODE);
        }
    }

    public static class ConfigLineCustomAttributeStore {
        private final ConfigLine.Builder builder;

        private ConfigLineCustomAttributeStore(ConfigLine.Builder builder) {
            this.builder = builder;
        }

        public ConfigLineCustomAttributeStore addNode(Node node) {
            this.addCustomAttributes(node);
            return this;
        }

        private void addCustomAttributes(Node node) {
            this.builder.addCustomAttribute(XmlCustomAttributeHandler.XML_NODE, node);
            this.builder.addCustomAttribute(XmlCustomAttributeHandler.NAMESPACE_URI, node.getNamespaceURI());
            if (node.getPrefix() != null) {
                this.builder.addCustomAttribute(XmlCustomAttributeHandler.DECLARED_PREFIX, node.getPrefix());
            }
        }
    }
}

