/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collection;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;

class CollectionBeanDefinitionCreator
extends BeanDefinitionCreator {
    CollectionBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        ComponentBuildingDefinition componentBuildingDefinition = createBeanDefinitionRequest.getComponentBuildingDefinition();
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        componentBuildingDefinition.getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
        if (Collection.class.isAssignableFrom(objectTypeVisitor.getType())) {
            componentModel.setType(objectTypeVisitor.getType());
            ManagedList managedList = new ManagedList();
            for (ComponentModel innerComponent : componentModel.getInnerComponents()) {
                SpringComponentModel innerSpringComp = (SpringComponentModel)innerComponent;
                BeanReference bean = innerSpringComp.getBeanDefinition() == null ? innerSpringComp.getBeanReference() : innerSpringComp.getBeanDefinition();
                managedList.add((Object)bean);
            }
            componentModel.setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(objectTypeVisitor.getType()).addConstructorArgValue((Object)managedList).getBeanDefinition());
            return true;
        }
        return false;
    }
}

