/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.config.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.config.internal.dsl.model.ComponentLocationVisitor;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.internal.routing.AbstractSelectiveRouter;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;

public class ComponentModelHelper {
    public static TypedComponentIdentifier.ComponentType resolveComponentType(ComponentModel componentModel) {
        if (ComponentModelHelper.isMessageSource(componentModel)) {
            return TypedComponentIdentifier.ComponentType.SOURCE;
        }
        if (ComponentModelHelper.isErrorHandler(componentModel)) {
            return TypedComponentIdentifier.ComponentType.ERROR_HANDLER;
        }
        if (ComponentModelHelper.isTemplateOnErrorHandler(componentModel)) {
            return TypedComponentIdentifier.ComponentType.ON_ERROR;
        }
        if (ComponentModelHelper.isFlow(componentModel)) {
            return TypedComponentIdentifier.ComponentType.FLOW;
        }
        if (ComponentModelHelper.isProcessor(componentModel)) {
            if (ComponentModelHelper.isOperationMessageProcessor(componentModel)) {
                return TypedComponentIdentifier.ComponentType.OPERATION;
            }
            if (ComponentModelHelper.isInterceptingProcessor(componentModel)) {
                return TypedComponentIdentifier.ComponentType.INTERCEPTING;
            }
            if (ComponentModelHelper.isRouterProcessor(componentModel)) {
                return TypedComponentIdentifier.ComponentType.ROUTER;
            }
            if (ComponentModelHelper.isScopeProcessor(componentModel)) {
                return TypedComponentIdentifier.ComponentType.SCOPE;
            }
            return TypedComponentIdentifier.ComponentType.PROCESSOR;
        }
        return TypedComponentIdentifier.ComponentType.UNKNOWN;
    }

    private static boolean isOperationMessageProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, OperationMessageProcessor.class);
    }

    public static boolean isAnnotatedObject(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Component.class);
    }

    private static boolean isScopeProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Scope.class);
    }

    private static boolean isRouterProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Router.class);
    }

    private static boolean isInterceptingProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, InterceptingMessageProcessor.class);
    }

    public static boolean isProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Processor.class) || ComponentModelHelper.isOfType(componentModel, InterceptingMessageProcessor.class);
    }

    public static boolean isMessageSource(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, MessageSource.class);
    }

    public static boolean isErrorHandler(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, ErrorHandler.class);
    }

    public static boolean isTemplateOnErrorHandler(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, TemplateOnErrorHandler.class);
    }

    public static boolean isFlow(ComponentModel componentModel) {
        return componentModel.getIdentifier().equals(ApplicationModel.FLOW_IDENTIFIER);
    }

    private static boolean isOfType(ComponentModel componentModel, Class type) {
        Class<?> componentModelType = componentModel.getType();
        if (componentModelType == null) {
            return false;
        }
        return CommonBeanDefinitionCreator.areMatchingTypes(type, componentModelType);
    }

    public static void addAnnotation(QName annotationKey, Object annotationValue, SpringComponentModel componentModel) {
        if (!ComponentModelHelper.isAnnotatedObject(componentModel) && !componentModel.getIdentifier().getName().equals("flow-ref")) {
            return;
        }
        BeanDefinition beanDefinition = componentModel.getBeanDefinition();
        if (beanDefinition == null) {
            return;
        }
        ComponentModelHelper.updateAnnotationValue(annotationKey, annotationValue, beanDefinition);
    }

    public static void updateAnnotationValue(QName annotationKey, Object annotationValue, BeanDefinition beanDefinition) {
        Map<QName, Object> annotations;
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            annotations = new HashMap();
            propertyValue = new PropertyValue("annotations", annotations);
            beanDefinition.getPropertyValues().addPropertyValue(propertyValue);
        } else {
            annotations = (Map)propertyValue.getValue();
        }
        annotations.put(annotationKey, annotationValue);
    }

    public static <T> Optional<T> getAnnotation(QName annotationKey, SpringComponentModel componentModel) {
        if (componentModel.getBeanDefinition() == null) {
            return Optional.empty();
        }
        PropertyValue propertyValue = componentModel.getBeanDefinition().getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            return Optional.empty();
        }
        Map annotations = (Map)propertyValue.getValue();
        return Optional.ofNullable(annotations.get(annotationKey));
    }

    public static boolean isRouter(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Router.class) || ComponentModelHelper.isOfType(componentModel, AbstractSelectiveRouter.class) || ComponentLocationVisitor.BATCH_JOB_COMPONENT_IDENTIFIER.equals(componentModel.getIdentifier()) || ComponentLocationVisitor.BATCH_PROCESSS_RECORDS_COMPONENT_IDENTIFIER.equals(componentModel.getIdentifier());
    }
}

