/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model;

import java.util.Set;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.internal.dsl.model.ConfigurationDependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalApplicationModelGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalApplicationModelGenerator.class);
    private ConfigurationDependencyResolver dependencyResolver;

    public MinimalApplicationModelGenerator(ConfigurationDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public ApplicationModel getMinimalModel(Location location) {
        ComponentModel requestedComponentModel = this.dependencyResolver.findRequiredComponentModel(location);
        Set<String> otherRequiredGlobalComponents = this.dependencyResolver.resolveComponentDependencies(requestedComponentModel);
        String requestComponentModelName = requestedComponentModel.getNameAttribute();
        if (requestComponentModelName != null && this.dependencyResolver.getApplicationModel().findTopLevelNamedElement(requestComponentModelName).isPresent()) {
            otherRequiredGlobalComponents.add(requestedComponentModel.getNameAttribute());
        }
        Set<String> allRequiredComponentModels = this.dependencyResolver.findComponentModelsDependencies(otherRequiredGlobalComponents);
        for (ComponentModel componentModel2 : this.dependencyResolver.getApplicationModel().getRootComponentModel().getInnerComponents()) {
            if (componentModel2.getNameAttribute() == null || !allRequiredComponentModels.contains(componentModel2.getNameAttribute())) continue;
            componentModel2.setEnabled(true);
            componentModel2.executedOnEveryInnerComponent(component -> component.setEnabled(true));
        }
        ComponentModel currentComponentModel = requestedComponentModel;
        for (ComponentModel parentModel = currentComponentModel.getParent(); parentModel != null && parentModel.getParent() != null; parentModel = parentModel.getParent()) {
            parentModel.setEnabled(true);
            for (ComponentModel innerComponent : parentModel.getInnerComponents()) {
                if (innerComponent.equals(currentComponentModel)) continue;
                innerComponent.setEnabled(false);
                innerComponent.executedOnEveryInnerComponent(component -> component.setEnabled(false));
            }
            currentComponentModel = parentModel;
        }
        requestedComponentModel.setEnabled(true);
        requestedComponentModel.executedOnEveryInnerComponent(componentModel -> componentModel.setEnabled(true));
        this.dependencyResolver.getApplicationModel().getRootComponentModel().setEnabled(true);
        return this.dependencyResolver.getApplicationModel();
    }
}

