/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.processor.xml;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.ConfigLineProvider;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.config.spring.parsers.XmlMetadataAnnotations;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.internal.dsl.DslConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlApplicationParser {
    private static final String COLON = ":";
    private static final Map<String, String> predefinedNamespace = new HashMap<String, String>();
    private static final String UNDEFINED_NAMESPACE = "undefined";
    private final List<XmlNamespaceInfoProvider> namespaceInfoProviders;
    private final Cache<String, String> namespaceCache;

    public XmlApplicationParser(ServiceRegistry serviceRegistry, List<ClassLoader> pluginsClassLoaders) {
        this(XmlApplicationParser.discoverNamespaceInfoProviders(serviceRegistry, pluginsClassLoaders));
    }

    private static List<XmlNamespaceInfoProvider> discoverNamespaceInfoProviders(ServiceRegistry serviceRegistry, List<ClassLoader> pluginsClassLoaders) {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, XmlNamespaceInfoProvider.class.getClassLoader()));
        for (ClassLoader pluginClassLoader : pluginsClassLoaders) {
            namespaceInfoProvidersBuilder.addAll((Iterable)serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, pluginClassLoader));
        }
        return namespaceInfoProvidersBuilder.build();
    }

    public XmlApplicationParser(List<XmlNamespaceInfoProvider> namespaceInfoProviders) {
        this.namespaceInfoProviders = ImmutableList.builder().addAll(namespaceInfoProviders).build();
        this.namespaceCache = CacheBuilder.newBuilder().build();
    }

    private String loadNamespaceFromProviders(String namespaceUri) {
        if (predefinedNamespace.containsKey(namespaceUri)) {
            return predefinedNamespace.get(namespaceUri);
        }
        for (XmlNamespaceInfoProvider namespaceInfoProvider : this.namespaceInfoProviders) {
            Optional<XmlNamespaceInfo> matchingXmlNamespaceInfo = namespaceInfoProvider.getXmlNamespacesInfo().stream().filter(xmlNamespaceInfo -> namespaceUri.equals(xmlNamespaceInfo.getNamespaceUriPrefix())).findFirst();
            if (!matchingXmlNamespaceInfo.isPresent()) continue;
            return matchingXmlNamespaceInfo.get().getNamespace();
        }
        return UNDEFINED_NAMESPACE;
    }

    public String getNormalizedNamespace(String namespaceUri, String namespacePrefix) {
        try {
            return (String)this.namespaceCache.get((Object)namespaceUri, () -> {
                String namespace = this.loadNamespaceFromProviders(namespaceUri);
                if (namespace == null) {
                    namespace = namespacePrefix;
                }
                return namespace;
            });
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Optional<ConfigLine> parse(Element configElement) {
        return this.configLineFromElement(configElement, () -> null);
    }

    private Optional<ConfigLine> configLineFromElement(Node node, ConfigLineProvider parentProvider) {
        if (!this.isValidType(node)) {
            return Optional.empty();
        }
        String identifier = this.parseIdentifier(node);
        String namespace = this.parseNamespace(node);
        ConfigLine.Builder builder = new ConfigLine.Builder().setIdentifier(identifier).setNamespace(namespace).setNode(node).setParent(parentProvider);
        XmlMetadataAnnotations userData = (XmlMetadataAnnotations)node.getUserData("metadataAnnotations");
        int lineNumber = userData.getLineNumber();
        builder.setLineNumber(lineNumber);
        XmlCustomAttributeHandler.to(builder).addNode(node);
        Element element = (Element)node;
        NamedNodeMap attributes = element.getAttributes();
        if (element.hasAttributes()) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                Attr attributeNode = element.getAttributeNode(attribute.getNodeName());
                boolean isFromXsd = !attributeNode.getSpecified();
                builder.addConfigAttribute(attribute.getNodeName(), attribute.getNodeValue(), isFromXsd);
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (this.isTextContent(child)) {
                    builder.setTextContent(child.getNodeValue());
                    if (child.getNodeType() != 4) continue;
                    builder.addCustomAttribute("IS_CDATA", Boolean.TRUE);
                    break;
                }
                this.configLineFromElement(child, builder::build).ifPresent(builder::addChild);
            }
        }
        return Optional.of(builder.build());
    }

    private String parseNamespace(Node node) {
        String namespace = "mule";
        if (node.getNodeType() != 4 && (namespace = this.getNormalizedNamespace(node.getNamespaceURI(), node.getPrefix())).equals(UNDEFINED_NAMESPACE)) {
            namespace = node.getPrefix();
        }
        return namespace;
    }

    private String parseIdentifier(Node node) {
        String identifier = node.getNodeName();
        String[] nameParts = identifier.split(COLON);
        if (nameParts.length > 1) {
            identifier = nameParts[1];
        }
        return identifier;
    }

    private boolean isValidType(Node node) {
        return node.getNodeType() != 3 && node.getNodeType() != 8;
    }

    private boolean isTextContent(Node node) {
        return node.getNodeType() == 3 || node.getNodeType() == 4;
    }

    static {
        predefinedNamespace.put(DslConstants.DOMAIN_NAMESPACE, "domain");
        predefinedNamespace.put(DslConstants.EE_DOMAIN_NAMESPACE, "ee-domain");
    }
}

