/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.mule.runtime.config.spring.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationPropertiesProvider;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationProperty;
import org.mule.runtime.core.api.util.IOUtils;

public class FileConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider {
    private static final String FILE_PREFIX = "file::";
    private ResourceProvider resourceProvider;
    private String description;

    public FileConfigurationPropertiesProvider(ResourceProvider resourceProvider, String description) {
        this.resourceProvider = resourceProvider;
        this.description = description;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        if (!configurationAttributeKey.startsWith(FILE_PREFIX)) return Optional.empty();
        String path = configurationAttributeKey.substring(FILE_PREFIX.length());
        try (InputStream is = this.resourceProvider.getResourceAsStream(path);){
            if (is == null) return Optional.empty();
            String value = IOUtils.toString((InputStream)is);
            Optional<ConfigurationProperty> optional = Optional.of(new ConfigurationProperty(this, configurationAttributeKey, value));
            return optional;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

