/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.spring;

import java.util.List;
import java.util.Map;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.spring.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.spring.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.spring.internal.dsl.spring.PropertyComponentUtils;
import org.mule.runtime.config.spring.privileged.dsl.PostProcessorIocHelper;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;

class SpringPostProcessorIocHelper
implements PostProcessorIocHelper {
    private ObjectFactoryClassRepository objectFactoryClassRepository;
    private AbstractBeanDefinition beanDefinition;

    public SpringPostProcessorIocHelper(ObjectFactoryClassRepository objectFactoryClassRepository, AbstractBeanDefinition beanDefinition) {
        this.objectFactoryClassRepository = objectFactoryClassRepository;
        this.beanDefinition = beanDefinition;
    }

    @Override
    public void replaceDefinitionWithRoot(Class beanClass, boolean wrap, Object ... constructorArgs) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)beanClass);
        if (wrap) {
            builder = builder.addConstructorArgValue((Object)this.beanDefinition);
        }
        for (Object constructorArg : constructorArgs) {
            builder = builder.addConstructorArgValue(constructorArg);
        }
        this.beanDefinition = builder.getBeanDefinition();
    }

    @Override
    public void addReferenceConstructorArg(String beanName) {
        this.beanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(beanName));
    }

    @Override
    public void addPropertyValue(String propertyName, Object propertyValue) {
        this.beanDefinition.getPropertyValues().addPropertyValue(propertyName, propertyValue);
    }

    @Override
    public void addReferencesPropertyValue(String propertyName, String[] refBeanNames) {
        ManagedList managedList = new ManagedList();
        for (String ref : refBeanNames) {
            managedList.add((Object)new RuntimeBeanReference(ref));
        }
        this.beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)managedList);
    }

    @Override
    public void addDefinitionPropertyValue(String propertyName, Class beanClass, Map<String, Object> properties, boolean addContext, Object ... constructorArgs) {
        BeanDefinitionBuilder builder;
        if (ObjectFactory.class.isAssignableFrom(beanClass)) {
            ComponentBuildingDefinition definition = new ComponentBuildingDefinition.Builder().withTypeDefinition(TypeDefinition.fromType(Object.class)).withObjectFactoryType(beanClass).withNamespace("helper").withIdentifier(propertyName).build();
            builder = BeanDefinitionBuilder.genericBeanDefinition(this.objectFactoryClassRepository.getObjectFactoryClass(definition, beanClass, Object.class, () -> true, b -> {}));
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition((Class)beanClass);
        }
        for (Object constructorArg : constructorArgs) {
            builder = builder.addConstructorArgValue(constructorArg);
        }
        if (addContext) {
            builder = builder.addConstructorArgReference("_muleContext");
        }
        for (Map.Entry entry : properties.entrySet()) {
            builder = builder.addPropertyValue((String)entry.getKey(), entry.getValue());
        }
        this.beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)builder.getBeanDefinition());
    }

    @Override
    public void removePropertyValue(String propertyName) {
        this.beanDefinition.getPropertyValues().removePropertyValue(propertyName);
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        return this.beanDefinition.getPropertyValues().get(propertyName);
    }

    @Override
    public List toBeanDefinitions(List<ComponentModel> components) {
        ManagedList responseMessageProcessorsBeanList = new ManagedList();
        components.forEach(responseProcessorComponentModel -> {
            BeanDefinition beanDefinition = ((SpringComponentModel)responseProcessorComponentModel).getBeanDefinition();
            responseMessageProcessorsBeanList.add(beanDefinition != null ? beanDefinition : ((SpringComponentModel)responseProcessorComponentModel).getBeanReference());
        });
        return responseMessageProcessorsBeanList;
    }

    @Override
    public Map<String, Object> toBeanDefinitionsProperties(List<ComponentModel> components) {
        ManagedMap propertiesMap = new ManagedMap();
        components.stream().filter(innerComponent -> innerComponent.getIdentifier().equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)).forEach(propertyComponentModel -> {
            Pair<String, Object> propertyValue = PropertyComponentUtils.getPropertyValueFromPropertyComponent(propertyComponentModel);
            this.removePropertyValue((String)propertyValue.getFirst());
            propertiesMap.put(propertyValue.getFirst(), propertyValue.getSecond());
        });
        components.stream().filter(innerComponent -> innerComponent.getIdentifier().getName().equals("properties")).findFirst().ifPresent(propertiesComponent -> CommonBeanDefinitionCreator.getPropertyValueFromPropertiesComponent(propertiesComponent).stream().forEach(propertyValue -> propertiesMap.put(propertyValue.getFirst(), propertyValue.getSecond())));
        return propertiesMap;
    }

    @Override
    public boolean isDefinitionFor(Object definition, Class beanClass) {
        return definition instanceof AbstractBeanDefinition && CommonBeanDefinitionCreator.areMatchingTypes(beanClass, ((AbstractBeanDefinition)definition).getBeanClass());
    }

    public AbstractBeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }
}

