/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.dsl.model.ComponentLocationVisitor;
import org.mule.runtime.config.internal.dsl.model.ExtensionModelHelper;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.routing.AbstractSelectiveRouter;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.processor.Router;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;

public class ComponentModelHelper {
    public static TypedComponentIdentifier.ComponentType resolveComponentType(ComponentModel componentModel, ExtensionModelHelper extensionModelHelper) {
        if (componentModel.getIdentifier().equals(CoreDslConstants.ON_ERROR_CONTINE_IDENTIFIER) || componentModel.getIdentifier().equals(CoreDslConstants.ON_ERROR_PROPAGATE_IDENTIFIER)) {
            return TypedComponentIdentifier.ComponentType.ON_ERROR;
        }
        return extensionModelHelper.findComponentType(componentModel);
    }

    public static boolean isAnnotatedObject(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Component.class);
    }

    public static boolean isProcessor(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Processor.class) || ComponentModelHelper.isOfType(componentModel, InterceptingMessageProcessor.class) || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.OPERATION)).orElse(false) != false || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.ROUTER)).orElse(false) != false || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.SCOPE)).orElse(false) != false;
    }

    public static boolean isMessageSource(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, MessageSource.class) || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.SOURCE)).orElse(false) != false;
    }

    public static boolean isErrorHandler(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, ErrorHandler.class) || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER)).orElse(false) != false;
    }

    public static boolean isTemplateOnErrorHandler(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, TemplateOnErrorHandler.class) || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.ON_ERROR)).orElse(false) != false;
    }

    private static boolean isOfType(ComponentModel componentModel, Class type) {
        Class<?> componentModelType = componentModel.getType();
        if (componentModelType == null) {
            return false;
        }
        return CommonBeanDefinitionCreator.areMatchingTypes(type, componentModelType);
    }

    public static void addAnnotation(QName annotationKey, Object annotationValue, SpringComponentModel componentModel) {
        if (!ComponentModelHelper.isAnnotatedObject(componentModel) && !componentModel.getIdentifier().getName().equals("flow-ref")) {
            return;
        }
        BeanDefinition beanDefinition = componentModel.getBeanDefinition();
        if (beanDefinition == null) {
            return;
        }
        ComponentModelHelper.updateAnnotationValue(annotationKey, annotationValue, beanDefinition);
    }

    public static void updateAnnotationValue(QName annotationKey, Object annotationValue, BeanDefinition beanDefinition) {
        Map<QName, Object> annotations;
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            annotations = new HashMap();
            propertyValue = new PropertyValue("annotations", annotations);
            beanDefinition.getPropertyValues().addPropertyValue(propertyValue);
        } else {
            annotations = (Map)propertyValue.getValue();
        }
        annotations.put(annotationKey, annotationValue);
    }

    public static <T> Optional<T> getAnnotation(QName annotationKey, SpringComponentModel componentModel) {
        if (componentModel.getBeanDefinition() == null) {
            return Optional.empty();
        }
        PropertyValue propertyValue = componentModel.getBeanDefinition().getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            return Optional.empty();
        }
        Map annotations = (Map)propertyValue.getValue();
        return Optional.ofNullable(annotations.get(annotationKey));
    }

    public static boolean isRouter(ComponentModel componentModel) {
        return ComponentModelHelper.isOfType(componentModel, Router.class) || ComponentModelHelper.isOfType(componentModel, AbstractSelectiveRouter.class) || ComponentLocationVisitor.BATCH_JOB_COMPONENT_IDENTIFIER.equals(componentModel.getIdentifier()) || ComponentLocationVisitor.BATCH_PROCESSS_RECORDS_COMPONENT_IDENTIFIER.equals(componentModel.getIdentifier()) || componentModel.getComponentType().map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.ROUTER)).orElse(false) != false;
    }
}

