/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;

public class DependencyNode {
    private String componentName;
    private ComponentIdentifier componentIdentifier;
    private final Type type;

    public DependencyNode(String componentName, Type type) {
        this.componentName = componentName;
        this.type = type;
    }

    public DependencyNode(String componentName, ComponentIdentifier componentIdentifier, Type type) {
        this.componentName = componentName;
        this.componentIdentifier = componentIdentifier;
        this.type = type;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isTopLevel() {
        return Type.TOP_LEVEL.equals((Object)this.getType());
    }

    public boolean isUnnamedTopLevel() {
        return Type.UNNAMED_TOP_LEVEL.equals((Object)this.getType());
    }

    public Optional<ComponentIdentifier> getComponentIdentifier() {
        return Optional.ofNullable(this.componentIdentifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyNode that = (DependencyNode)o;
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) {
            return false;
        }
        if (this.componentIdentifier != null ? !this.componentIdentifier.equals(that.componentIdentifier) : that.componentIdentifier != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.componentName != null ? this.componentName.hashCode() : 0;
        result = 31 * result + (this.componentIdentifier != null ? this.componentIdentifier.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "DependencyNode{componentName='" + this.componentName + '\'' + ", componentIdentifier=" + this.componentIdentifier + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        TOP_LEVEL,
        INNER,
        UNNAMED_TOP_LEVEL;

    }
}

