/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.DependencyNode;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class MinimalApplicationModelGenerator {
    private ConfigurationDependencyResolver dependencyResolver;

    public MinimalApplicationModelGenerator(ConfigurationDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public ApplicationModel getMinimalModel(Predicate<ComponentModel> predicate) {
        List<ComponentModel> required = this.dependencyResolver.findRequiredComponentModels(predicate);
        required.stream().forEach(componentModel -> {
            DefaultComponentLocation componentLocation = componentModel.getComponentLocation();
            if (componentLocation != null) {
                this.enableComponentDependencies((ComponentModel)componentModel);
            }
        });
        return this.dependencyResolver.getApplicationModel();
    }

    public ApplicationModel getMinimalModel(Location location) {
        ComponentModel requestedComponentModel = this.dependencyResolver.findRequiredComponentModel(location);
        this.enableComponentDependencies(requestedComponentModel);
        return this.dependencyResolver.getApplicationModel();
    }

    private void enableComponentDependencies(ComponentModel requestedComponentModel) {
        String requestComponentModelName = requestedComponentModel.getNameAttribute();
        Set<DependencyNode> componentDependencies = this.dependencyResolver.resolveComponentDependencies(requestedComponentModel);
        Set<DependencyNode> alwaysEnabledComponents = this.dependencyResolver.resolveAlwaysEnabledComponents();
        ImmutableSet.Builder otherRequiredGlobalComponentsSetBuilder = ImmutableSet.builder().addAll(componentDependencies).addAll((Iterable)alwaysEnabledComponents.stream().filter(dependencyNode -> dependencyNode.isTopLevel()).collect(Collectors.toList()));
        if (requestComponentModelName != null && this.dependencyResolver.getApplicationModel().findTopLevelNamedComponent(requestComponentModelName).isPresent()) {
            otherRequiredGlobalComponentsSetBuilder.add((Object)new DependencyNode(requestComponentModelName, DependencyNode.Type.TOP_LEVEL));
        }
        Set<DependencyNode> allRequiredComponentModels = this.resolveDependencies((Set<DependencyNode>)otherRequiredGlobalComponentsSetBuilder.build());
        this.enableTopLevelElementDependencies(allRequiredComponentModels);
        this.enableInnerElementDependencies(allRequiredComponentModels);
        for (ComponentModel parentModel = requestedComponentModel.getParent(); parentModel != null && parentModel.getParent() != null; parentModel = parentModel.getParent()) {
            parentModel.setEnabled(true);
        }
        alwaysEnabledComponents.stream().filter(dependencyNode -> dependencyNode.isUnnamedTopLevel() && dependencyNode.getComponentIdentifier().isPresent()).forEach(dependencyNode -> this.dependencyResolver.getApplicationModel().findComponentDefinitionModel(dependencyNode.getComponentIdentifier().get()).ifPresent(componentModel -> {
            componentModel.setEnabled(true);
            componentModel.executedOnEveryInnerComponent(innerComponent -> innerComponent.setEnabled(true));
        }));
        requestedComponentModel.setEnabled(true);
        requestedComponentModel.executedOnEveryInnerComponent(componentModel -> componentModel.setEnabled(true));
        this.enableParentComponentModels(requestedComponentModel);
        this.dependencyResolver.getApplicationModel().getRootComponentModel().setEnabled(true);
    }

    private void enableInnerElementDependencies(Set<DependencyNode> allRequiredComponentModels) {
        Set noneTopLevelDendencyNames = allRequiredComponentModels.stream().filter(dependencyNode -> !dependencyNode.isTopLevel()).map(dependencyNode -> dependencyNode.getComponentName()).collect(Collectors.toSet());
        this.dependencyResolver.getApplicationModel().executeOnEveryComponentTree(componentModel -> {
            if (!componentModel.isEnabled() && componentModel.getNameAttribute() != null && noneTopLevelDendencyNames.contains(componentModel.getNameAttribute())) {
                componentModel.setEnabled(true);
                componentModel.executedOnEveryInnerComponent(component -> component.setEnabled(true));
                this.enableParentComponentModels((ComponentModel)componentModel);
            }
        });
    }

    private void enableTopLevelElementDependencies(Set<DependencyNode> allRequiredComponentModels) {
        Set topLevelDendencyNames = allRequiredComponentModels.stream().filter(dependencyNode -> dependencyNode.isTopLevel()).map(dependencyNode -> dependencyNode.getComponentName()).collect(Collectors.toSet());
        for (ComponentModel componentModel : this.dependencyResolver.getApplicationModel().getRootComponentModel().getInnerComponents()) {
            if (componentModel.getNameAttribute() == null || !topLevelDendencyNames.contains(componentModel.getNameAttribute())) continue;
            componentModel.setEnabled(true);
            componentModel.executedOnEveryInnerComponent(component -> component.setEnabled(true));
        }
    }

    private void enableParentComponentModels(ComponentModel requestedComponentModel) {
        for (ComponentModel parentModel = requestedComponentModel.getParent(); parentModel != null && parentModel.getParent() != null; parentModel = parentModel.getParent()) {
            parentModel.setEnabled(true);
        }
    }

    private Set<DependencyNode> resolveDependencies(Set<DependencyNode> initialComponents) {
        Set<DependencyNode> difference = initialComponents;
        HashSet<DependencyNode> allRequiredComponentModels = new HashSet<DependencyNode>(initialComponents);
        while (difference.size() > 0) {
            Set<DependencyNode> newDependencies = this.dependencyResolver.findComponentModelsDependencies(difference);
            newDependencies.removeAll(allRequiredComponentModels);
            allRequiredComponentModels.addAll(newDependencies);
            difference = newDependencies;
        }
        return allRequiredComponentModels;
    }
}

