/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.PropertyNotFoundException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationPropertiesResolver
implements ConfigurationPropertiesResolver,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigurationPropertiesResolver.class);
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private final Optional<ConfigurationPropertiesResolver> parentResolver;
    private final ConfigurationPropertiesProvider configurationPropertiesProvider;
    private Cache<String, Object> resolutionCache = CacheBuilder.newBuilder().build();
    private boolean initialized = false;
    private Optional<ConfigurationPropertiesResolver> rootResolver = Optional.empty();

    public DefaultConfigurationPropertiesResolver(Optional<ConfigurationPropertiesResolver> parentResolver, ConfigurationPropertiesProvider configurationPropertiesProvider) {
        this.parentResolver = parentResolver;
        this.configurationPropertiesProvider = configurationPropertiesProvider;
    }

    @Override
    public Object resolveValue(String value) {
        if (value == null) {
            return value;
        }
        try {
            return this.resolutionCache.get((Object)value, () -> {
                int prefixIndex = value.indexOf(PLACEHOLDER_PREFIX);
                if (prefixIndex == -1) {
                    return value;
                }
                return this.replaceAllPlaceholders(value);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Failure processing configuration attribute " + value), (Object[])new Object[]{e}));
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.parentResolver);
        if (!this.initialized) {
            LifecycleUtils.initialiseIfNeeded((Object)this.configurationPropertiesProvider);
            this.initialized = true;
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.configurationPropertiesProvider, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded(this.parentResolver, (Logger)LOGGER);
        this.initialized = false;
    }

    @Override
    public Object resolvePlaceholderKeyValue(String placeholderKey) {
        Optional<ConfigurationProperty> foundValueOptional = this.configurationPropertiesProvider.getConfigurationProperty(placeholderKey);
        if (foundValueOptional.isPresent() && !foundValueOptional.get().getRawValue().equals(PLACEHOLDER_PREFIX + placeholderKey + PLACEHOLDER_SUFFIX)) {
            if (foundValueOptional.get().getRawValue() instanceof String) {
                return this.replaceAllPlaceholders((String)foundValueOptional.get().getRawValue());
            }
            return foundValueOptional.get();
        }
        if (this.parentResolver.isPresent()) {
            try {
                return this.parentResolver.get().resolvePlaceholderKeyValue(placeholderKey);
            }
            catch (PropertyNotFoundException e) {
                throw new PropertyNotFoundException(e, (Pair<String, String>)new Pair((Object)this.configurationPropertiesProvider.getDescription(), (Object)placeholderKey));
            }
        }
        throw new PropertyNotFoundException((Pair<String, String>)new Pair((Object)this.configurationPropertiesProvider.getDescription(), (Object)placeholderKey));
    }

    private Object tryResolveByRoot(String placeholder) {
        if (!this.rootResolver.isPresent()) {
            return this.resolvePlaceholderKeyValue(placeholder);
        }
        try {
            return this.rootResolver.get().resolvePlaceholderKeyValue(placeholder);
        }
        catch (PropertyNotFoundException e) {
            return this.resolvePlaceholderKeyValue(placeholder);
        }
    }

    private Object replaceAllPlaceholders(String value) {
        String testValue = value;
        int prefixIndex = testValue.indexOf(PLACEHOLDER_PREFIX);
        while (prefixIndex != -1) {
            int suffixIndex = testValue.indexOf(PLACEHOLDER_SUFFIX, prefixIndex + PLACEHOLDER_PREFIX.length());
            String innerPlaceholderKey = testValue.substring(prefixIndex + PLACEHOLDER_PREFIX.length(), suffixIndex);
            Object objectValueFound = this.tryResolveByRoot(innerPlaceholderKey);
            if (value.equals(PLACEHOLDER_PREFIX + innerPlaceholderKey + PLACEHOLDER_SUFFIX)) {
                return objectValueFound;
            }
            testValue = testValue.replace(PLACEHOLDER_PREFIX + innerPlaceholderKey + PLACEHOLDER_SUFFIX, objectValueFound.toString());
            prefixIndex = testValue.indexOf(PLACEHOLDER_PREFIX);
        }
        return testValue;
    }

    private void propagateRootResolver(ConfigurationPropertiesResolver rootResolver) {
        this.parentResolver.ifPresent(resolver -> {
            if (resolver instanceof DefaultConfigurationPropertiesResolver) {
                ((DefaultConfigurationPropertiesResolver)resolver).setRootResolver(rootResolver);
            }
        });
    }

    public void setRootResolver(ConfigurationPropertiesResolver rootResolver) {
        this.rootResolver = Optional.of(rootResolver);
        this.propagateRootResolver(rootResolver);
    }

    public void setAsRootResolver() {
        this.propagateRootResolver(this);
    }
}

