/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.OperationComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.TestConnectionGlobalElementModelProperty;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;

public class MacroExpansionModuleModel {
    private static final String MODULE_OPERATION_CONFIG_REF = "config-ref";
    public static final String ORIGINAL_IDENTIFIER = "ORIGINAL_IDENTIFIER";
    public static final String TNS_PREFIX = "tns";
    public static final String ROOT_MACRO_EXPANDED_FLOW_CONTAINER_NAME = "ROOT_MACRO_EXPANDED_FLOW_CONTAINER_NAME";
    private static final String DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX = "%s-default-config-global-element-suffix";
    private final ApplicationModel applicationModel;
    private final ExtensionModel extensionModel;
    private final DslSyntaxResolver dslSyntaxResolver;

    MacroExpansionModuleModel(ApplicationModel applicationModel, ExtensionModel extensionModel) {
        this.applicationModel = applicationModel;
        this.extensionModel = extensionModel;
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.singleton(extensionModel));
        this.dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)dslResolvingContext);
    }

    public void expand() {
        List<ComponentModel> moduleGlobalElements = this.getModuleGlobalElements();
        Set<String> moduleGlobalElementsNames = moduleGlobalElements.stream().map(ComponentModel::getNameAttribute).collect(Collectors.toSet());
        this.expandOperations(moduleGlobalElementsNames);
        this.expandGlobalElements(moduleGlobalElements, moduleGlobalElementsNames);
    }

    private void expandOperations(Set<String> moduleGlobalElementsNames) {
        this.applicationModel.executeOnEveryMuleComponentTree(containerComponentModel -> {
            HashMap componentModelsToReplaceByIndex = new HashMap();
            IntStream.range(0, containerComponentModel.getInnerComponents().size()).forEach(i -> {
                ComponentModel operationRefModel = containerComponentModel.getInnerComponents().get(i);
                this.lookForOperation(operationRefModel).ifPresent(operationModel -> {
                    String containerName = this.calculateContainerRootName((ComponentModel)containerComponentModel, (OperationModel)operationModel);
                    ComponentModel moduleOperationChain = this.createModuleOperationChain(operationRefModel, (OperationModel)operationModel, moduleGlobalElementsNames, Optional.empty(), containerName);
                    componentModelsToReplaceByIndex.put(i, moduleOperationChain);
                });
            });
            for (Map.Entry entry : componentModelsToReplaceByIndex.entrySet()) {
                ((ComponentModel)entry.getValue()).setParent((ComponentModel)containerComponentModel);
                containerComponentModel.getInnerComponents().add((Integer)entry.getKey(), (ComponentModel)entry.getValue());
                containerComponentModel.getInnerComponents().remove((Integer)entry.getKey() + 1);
            }
            componentModelsToReplaceByIndex.clear();
        });
    }

    private String calculateContainerRootName(ComponentModel containerComponentModel, OperationModel operationModel) {
        String nameAttribute;
        if (containerComponentModel.isRoot()) {
            nameAttribute = containerComponentModel.getNameAttribute();
        } else if (ApplicationModel.MODULE_OPERATION_CHAIN.equals(containerComponentModel.getIdentifier())) {
            nameAttribute = (String)containerComponentModel.getCustomAttributes().get(ROOT_MACRO_EXPANDED_FLOW_CONTAINER_NAME);
        } else if (containerComponentModel.getParent() != null) {
            nameAttribute = this.calculateContainerRootName(containerComponentModel.getParent(), operationModel);
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Should have not reach here. There was no root container element while doing the macro expansion for the module [%s], operation [%s]", this.extensionModel.getName(), operationModel.getName())));
        }
        return nameAttribute;
    }

    private Optional<String> defaultGlobalElementName() {
        Optional<String> defaultElementName = Optional.empty();
        if (this.extensionModel.getConfigurationModels().isEmpty() && this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent()) {
            defaultElementName = this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(globalElementComponentModelModelProperty -> String.format(DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX, this.extensionModel.getName()));
        }
        return defaultElementName;
    }

    private void expandGlobalElements(List<ComponentModel> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        if (this.defaultGlobalElementName().isPresent()) {
            this.addDefaultGlobalElements(moduleGlobalElementsNames);
        } else {
            this.macroExpandGlobalElements(moduleComponentModels, moduleGlobalElementsNames);
        }
    }

    private void addDefaultGlobalElements(Set<String> moduleGlobalElementsNames) {
        String defaultGlobalElementSuffix = this.defaultGlobalElementName().get();
        ComponentModel rootComponentModel = this.applicationModel.getRootComponentModel();
        List<ComponentModel> globalElements = ((GlobalElementComponentModelModelProperty)this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).get()).getGlobalElements();
        globalElements.forEach(globalElementComponenModel -> {
            ComponentModel macroExpandedImplicitGlobalElement = this.copyGlobalElementComponentModel((ComponentModel)globalElementComponenModel, defaultGlobalElementSuffix, moduleGlobalElementsNames, (Map<String, String>)new HashMap<String, String>());
            macroExpandedImplicitGlobalElement.setRoot(true);
            macroExpandedImplicitGlobalElement.setParent(rootComponentModel);
            rootComponentModel.getInnerComponents().add(macroExpandedImplicitGlobalElement);
        });
    }

    private void macroExpandGlobalElements(List<ComponentModel> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        this.applicationModel.executeOnEveryMuleComponentTree(muleRootComponentModel -> {
            HashMap componentModelsToReplaceByIndex = new HashMap();
            for (ComponentModel componentModel : muleRootComponentModel.getInnerComponents()) {
                this.looForConfiguration(componentModel).ifPresent(configurationModel -> {
                    Map<String, String> propertiesMap = this.extractParameters(configRefModel, configurationModel.getAllParameterModels());
                    Map<String, String> connectionPropertiesMap = this.extractConnectionProperties(configRefModel, (ConfigurationModel)configurationModel);
                    propertiesMap.putAll(connectionPropertiesMap);
                    Map<String, String> literalsParameters = this.getLiteralParameters(propertiesMap, Collections.emptyMap());
                    List<ComponentModel> replacementGlobalElements = this.createGlobalElementsInstance(configRefModel, moduleComponentModels, moduleGlobalElementsNames, literalsParameters);
                    componentModelsToReplaceByIndex.put(configRefModel, replacementGlobalElements);
                });
            }
            for (Map.Entry entry : componentModelsToReplaceByIndex.entrySet()) {
                int componentModelIndex = muleRootComponentModel.getInnerComponents().indexOf(entry.getKey());
                muleRootComponentModel.getInnerComponents().addAll(componentModelIndex, (Collection)entry.getValue());
                muleRootComponentModel.getInnerComponents().remove(componentModelIndex + ((List)entry.getValue()).size());
            }
        });
    }

    private Optional<ConfigurationModel> getConfigurationModel() {
        return this.extensionModel.getConfigurationModel("config");
    }

    private List<ComponentModel> createGlobalElementsInstance(ComponentModel configRefModel, List<ComponentModel> moduleGlobalElements, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters) {
        ComponentModel muleRootElement = configRefModel.getParent();
        return moduleGlobalElements.stream().map(globalElementModel -> {
            ComponentModel macroExpandedGlobalElement = this.copyGlobalElementComponentModel((ComponentModel)globalElementModel, configRefModel.getNameAttribute(), moduleGlobalElementsNames, literalsParameters);
            macroExpandedGlobalElement.setRoot(true);
            macroExpandedGlobalElement.setParent(muleRootElement);
            return macroExpandedGlobalElement;
        }).collect(Collectors.toList());
    }

    private List<ComponentModel> getModuleGlobalElements() {
        return this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(GlobalElementComponentModelModelProperty::getGlobalElements).orElse(new ArrayList());
    }

    private ComponentModel createModuleOperationChain(ComponentModel operationRefModel, OperationModel operationModel, Set<String> moduleGlobalElementsNames, Optional<String> configRefParentTnsName, String containerName) {
        OperationComponentModelModelProperty operationComponentModelModelProperty = (OperationComponentModelModelProperty)operationModel.getModelProperty(OperationComponentModelModelProperty.class).get();
        ComponentModel operationModuleComponentModel = operationComponentModelModelProperty.getBodyComponentModel();
        List<ComponentModel> bodyProcessors = operationModuleComponentModel.getInnerComponents();
        Optional<String> configRefName = this.referencesOperationsWithinModule(operationRefModel) ? configRefParentTnsName : this.getConfigRefName(operationRefModel);
        ComponentModel.Builder processorChainBuilder = new ComponentModel.Builder();
        processorChainBuilder.setIdentifier(ComponentIdentifier.builder().namespace("mule").name("module-operation-chain").build());
        processorChainBuilder.addParameter("moduleName", this.extensionModel.getXmlDslModel().getPrefix(), false);
        processorChainBuilder.addParameter("moduleOperation", operationModel.getName(), false);
        Map<String, String> propertiesMap = this.extractProperties(configRefName);
        Map<String, String> parametersMap = this.extractParameters(operationRefModel, operationModel.getAllParameterModels());
        parametersMap.forEach((k, v) -> processorChainBuilder.addParameter((String)k, (String)v, false));
        operationRefModel.getParameters().forEach((k, v) -> processorChainBuilder.addParameter((String)k, (String)v, false));
        ComponentModel propertiesComponentModel = this.getParameterChild(propertiesMap, "module-operation-properties", "module-operation-property-entry");
        ComponentModel parametersComponentModel = this.getParameterChild(parametersMap, "module-operation-parameters", "module-operation-parameter-entry");
        processorChainBuilder.addChildComponentModel(propertiesComponentModel);
        processorChainBuilder.addChildComponentModel(parametersComponentModel);
        for (ComponentModel componentModel : bodyProcessors) {
            ComponentModel childMPcomponentModel = this.lookForTNSOperation(componentModel).map(tnsOperation -> this.createModuleOperationChain(bodyProcessor, (OperationModel)tnsOperation, moduleGlobalElementsNames, configRefName, containerName)).orElseGet(() -> this.copyOperationComponentModel(bodyProcessor, configRefName, moduleGlobalElementsNames, this.getLiteralParameters(propertiesMap, parametersMap), containerName));
            processorChainBuilder.addChildComponentModel(childMPcomponentModel);
        }
        this.copyErrorMappings(operationRefModel, processorChainBuilder);
        for (Map.Entry entry : operationRefModel.getCustomAttributes().entrySet()) {
            processorChainBuilder.addCustomAttribute((String)entry.getKey(), entry.getValue());
        }
        processorChainBuilder.addCustomAttribute(ROOT_MACRO_EXPANDED_FLOW_CONTAINER_NAME, containerName);
        ComponentModel processorChainModel = processorChainBuilder.build();
        for (ComponentModel processorChainModelChild : processorChainModel.getInnerComponents()) {
            processorChainModelChild.setParent(processorChainModel);
        }
        operationRefModel.getConfigFileName().ifPresent(processorChainBuilder::setConfigFileName);
        operationRefModel.getLineNumber().ifPresent(processorChainBuilder::setLineNumber);
        operationRefModel.getStartColumn().ifPresent(processorChainBuilder::setStartColumn);
        processorChainBuilder.addCustomAttribute(ORIGINAL_IDENTIFIER, operationRefModel.getIdentifier());
        return processorChainModel;
    }

    private Optional<String> getConfigRefName(ComponentModel operationRefModel) {
        return operationRefModel.getParameters().containsKey(MODULE_OPERATION_CONFIG_REF) ? Optional.of(operationRefModel.getParameters().get(MODULE_OPERATION_CONFIG_REF)) : this.defaultGlobalElementName();
    }

    private void copyErrorMappings(ComponentModel operationRefModel, ComponentModel.Builder processorChainBuilder) {
        operationRefModel.getInnerComponents().stream().filter(componentModel -> componentModel.getIdentifier().equals(ApplicationModel.ERROR_MAPPING_IDENTIFIER)).forEach(errorMappingComponentModel -> processorChainBuilder.addChildComponentModel(this.copyComponentModel((ComponentModel)errorMappingComponentModel)));
    }

    private ComponentModel copyComponentModel(ComponentModel modelToCopy) {
        ComponentModel.Builder operationReplacementModel = this.getComponentModelBuilderFrom(modelToCopy);
        for (Map.Entry<String, String> entry : modelToCopy.getParameters().entrySet()) {
            operationReplacementModel.addParameter(entry.getKey(), entry.getValue(), false);
        }
        for (ComponentModel operationChildModel : modelToCopy.getInnerComponents()) {
            operationReplacementModel.addChildComponentModel(this.copyComponentModel(operationChildModel));
        }
        return this.buildFrom(modelToCopy, operationReplacementModel);
    }

    private Map<String, String> getLiteralParameters(Map<String, String> propertiesMap, Map<String, String> parametersMap) {
        Map<String, String> literalsParameters = propertiesMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue));
        literalsParameters.putAll(parametersMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue)));
        return literalsParameters;
    }

    private String getReplaceableExpression(String name, String prefix) {
        return "#[" + prefix + "." + name + "]";
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private ComponentModel getParameterChild(Map<String, String> parameters, String wrapperParameters, String entryParameter) {
        ComponentModel.Builder parametersBuilder = new ComponentModel.Builder();
        parametersBuilder.setIdentifier(ComponentIdentifier.builder().namespace("mule").name(wrapperParameters).build());
        parameters.forEach((paramName, paramValue) -> {
            ComponentModel.Builder parameterBuilder = new ComponentModel.Builder();
            parameterBuilder.setIdentifier(ComponentIdentifier.builder().namespace("mule").name(entryParameter).build());
            parameterBuilder.addParameter("key", (String)paramName, false);
            parameterBuilder.addParameter("value", (String)paramValue, false);
            parametersBuilder.addChildComponentModel(parameterBuilder.build());
        });
        ComponentModel parametersComponentModel = parametersBuilder.build();
        for (ComponentModel parameterComponentModel : parametersComponentModel.getInnerComponents()) {
            parameterComponentModel.setParent(parametersComponentModel);
        }
        return parametersComponentModel;
    }

    private Map<String, String> extractProperties(Optional<String> configRefName) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        configRefName.filter(configParameter -> this.defaultGlobalElementName().map(defaultGlobalElementName -> !defaultGlobalElementName.equals(configParameter)).orElse(true)).ifPresent(configParameter -> {
            ComponentModel configRefComponentModel = this.applicationModel.getRootComponentModel().getInnerComponents().stream().filter(componentModel -> this.looForConfiguration((ComponentModel)componentModel).isPresent() && configParameter.equals(componentModel.getParameters().get("name"))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("There's no <%s:config> named [%s] in the current mule app", this.extensionModel.getXmlDslModel().getPrefix(), configParameter)));
            ConfigurationModel configurationModel = this.getConfigurationModel().get();
            valuesMap.putAll(this.extractParameters(configRefComponentModel, configurationModel.getAllParameterModels()));
            valuesMap.putAll(this.extractConnectionProperties(configRefComponentModel, configurationModel));
        });
        return valuesMap;
    }

    private Map<String, String> extractConnectionProperties(ComponentModel configRefComponentModel, ConfigurationModel configurationModel) {
        HashMap<String, String> connectionValuesMap = new HashMap<String, String>();
        configurationModel.getConnectionProviderModel("connection").ifPresent(connectionProviderModel -> configRefComponentModel.getInnerComponents().stream().filter(componentModel -> "connection".equals(componentModel.getIdentifier().getName())).findFirst().ifPresent(connectionComponentModel -> connectionValuesMap.putAll(this.extractParameters((ComponentModel)connectionComponentModel, connectionProviderModel.getAllParameterModels()))));
        return connectionValuesMap;
    }

    private Map<String, String> extractParameters(ComponentModel componentModel, List<ParameterModel> parameters) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (ParameterModel parameterExtension : parameters) {
            String paramName = parameterExtension.getName();
            String value = null;
            switch (parameterExtension.getRole()) {
                case BEHAVIOUR: {
                    if (!componentModel.getParameters().containsKey(paramName)) break;
                    value = componentModel.getParameters().get(paramName);
                    break;
                }
                case CONTENT: 
                case PRIMARY_CONTENT: {
                    DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.emptySet());
                    DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)this.extensionModel, (DslResolvingContext)dslResolvingContext);
                    String resolvedName = dslSyntaxResolver.resolve(parameterExtension).getElementName();
                    Optional<ComponentModel> childComponentModel = componentModel.getInnerComponents().stream().filter(cm -> resolvedName.equals(cm.getIdentifier().getName())).findFirst();
                    if (!childComponentModel.isPresent()) break;
                    value = childComponentModel.get().getTextContent();
                }
            }
            if (value == null && parameterExtension.getDefaultValue() != null) {
                value = String.valueOf(parameterExtension.getDefaultValue());
            }
            if (value == null) continue;
            valuesMap.put(paramName, value);
        }
        return valuesMap;
    }

    private ComponentModel copyGlobalElementComponentModel(ComponentModel modelToCopy, String configRefName, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters) {
        ComponentModel.Builder globalElementReplacementModel = this.getComponentModelBuilderFrom(modelToCopy);
        for (Map.Entry<String, String> entry : modelToCopy.getParameters().entrySet()) {
            String value = this.calculateAttributeValue(configRefName, moduleGlobalElementsNames, entry.getValue());
            String optimizedValue = literalsParameters.getOrDefault(value, value);
            globalElementReplacementModel.addParameter(entry.getKey(), optimizedValue, false);
        }
        for (ComponentModel operationChildModel : modelToCopy.getInnerComponents()) {
            globalElementReplacementModel.addChildComponentModel(this.copyGlobalElementComponentModel(operationChildModel, configRefName, moduleGlobalElementsNames, literalsParameters));
        }
        return this.buildFrom(modelToCopy, globalElementReplacementModel);
    }

    private ComponentModel copyOperationComponentModel(ComponentModel modelToCopy, Optional<String> configRefName, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters, String containerName) {
        ComponentModel.Builder operationReplacementModel = this.getComponentModelBuilderFrom(modelToCopy);
        for (Map.Entry<String, String> entry : modelToCopy.getParameters().entrySet()) {
            String value = configRefName.map(s -> this.calculateAttributeValue((String)s, moduleGlobalElementsNames, (String)entry.getValue())).orElseGet(entry::getValue);
            String optimizedValue = literalsParameters.getOrDefault(value, value);
            operationReplacementModel.addParameter(entry.getKey(), optimizedValue, false);
        }
        for (ComponentModel operationChildModel : modelToCopy.getInnerComponents()) {
            ComponentModel childMPcomponentModel = this.lookForTNSOperation(operationChildModel).map(tnsOperation -> this.createModuleOperationChain(operationChildModel, (OperationModel)tnsOperation, moduleGlobalElementsNames, configRefName, containerName)).orElseGet(() -> this.copyOperationComponentModel(operationChildModel, configRefName, moduleGlobalElementsNames, literalsParameters, containerName));
            operationReplacementModel.addChildComponentModel(childMPcomponentModel);
        }
        return this.buildFrom(modelToCopy, operationReplacementModel);
    }

    private ComponentModel.Builder getComponentModelBuilderFrom(ComponentModel componentModelOrigin) {
        ComponentModel.Builder operationReplacementModel = new ComponentModel.Builder();
        operationReplacementModel.setIdentifier(componentModelOrigin.getIdentifier()).setTextContent(componentModelOrigin.getTextContent());
        for (Map.Entry<String, Object> entry : componentModelOrigin.getCustomAttributes().entrySet()) {
            operationReplacementModel.addCustomAttribute(entry.getKey(), entry.getValue());
        }
        return operationReplacementModel;
    }

    private ComponentModel buildFrom(ComponentModel componentModelOrigin, ComponentModel.Builder operationReplacementModel) {
        componentModelOrigin.getConfigFileName().ifPresent(operationReplacementModel::setConfigFileName);
        componentModelOrigin.getLineNumber().ifPresent(operationReplacementModel::setLineNumber);
        componentModelOrigin.getStartColumn().ifPresent(operationReplacementModel::setStartColumn);
        ComponentModel componentModel = operationReplacementModel.build();
        for (ComponentModel child : componentModel.getInnerComponents()) {
            child.setParent(componentModel);
        }
        return componentModel;
    }

    private boolean referencesOperationsWithinModule(ComponentModel operationComponentModel) {
        return TNS_PREFIX.equals(operationComponentModel.getIdentifier().getNamespace());
    }

    private Optional<ConfigurationModel> looForConfiguration(ComponentModel componentModel) {
        ComponentIdentifier identifier = componentModel.getIdentifier();
        return identifier.getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix()) ? this.extensionModel.getConfigurationModel(identifier.getName()) : Optional.empty();
    }

    private Optional<OperationModel> lookForOperation(ComponentModel componentModel) {
        return this.lookForOperation(componentModel.getIdentifier(), this.extensionModel.getXmlDslModel().getPrefix());
    }

    private Optional<OperationModel> lookForTNSOperation(ComponentModel componentModel) {
        return this.lookForOperation(componentModel.getIdentifier(), TNS_PREFIX);
    }

    private Optional<OperationModel> lookForOperation(ComponentIdentifier operationIdentifier, String prefix) {
        Optional result = Optional.empty();
        if (operationIdentifier.getNamespace().equals(prefix)) {
            String opName = operationIdentifier.getName();
            HyphenatedOperationFinder extensionWalker = new HyphenatedOperationFinder(opName);
            extensionWalker.walk(this.extensionModel);
            result = extensionWalker.result;
        }
        return result;
    }

    private String calculateAttributeValue(String configRefNameToAppend, Set<String> moduleGlobalElementsNames, String originalValue) {
        String result = moduleGlobalElementsNames.contains(originalValue) ? (originalValue.equals(this.getTestConnectionGlobalElement().orElse(null)) ? configRefNameToAppend : originalValue.concat("-").concat(configRefNameToAppend)) : originalValue;
        return result;
    }

    private Optional<String> getTestConnectionGlobalElement() {
        return this.getConfigurationModel().flatMap(this::getTestConnectionGlobalElement);
    }

    private Optional<String> getTestConnectionGlobalElement(ConfigurationModel configurationModel) {
        Optional connectionProviderModel = configurationModel.getConnectionProviderModel("connection");
        if (connectionProviderModel.isPresent()) {
            Optional modelProperty = ((ConnectionProviderModel)connectionProviderModel.get()).getModelProperty(TestConnectionGlobalElementModelProperty.class);
            return modelProperty.map(TestConnectionGlobalElementModelProperty::getGlobalElementName);
        }
        return Optional.empty();
    }

    private class HyphenatedOperationFinder
    extends IdempotentExtensionWalker {
        private final String hyphenatedOpName;
        private Optional<OperationModel> result = Optional.empty();

        private HyphenatedOperationFinder(String hyphenatedOpName) {
            this.hyphenatedOpName = hyphenatedOpName;
        }

        protected void onOperation(OperationModel model) {
            DslElementSyntax dsl = MacroExpansionModuleModel.this.dslSyntaxResolver.resolve((NamedObject)model);
            if (dsl.getElementName().equals(this.hyphenatedOpName)) {
                this.result = Optional.of(model);
                this.stop();
            }
        }
    }
}

