/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.bean;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.runtime.config.internal.bean.MuleConfigurationDelegate;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleConfigurationDelegateTestCase
extends AbstractMuleTestCase {
    @Test
    void delegatesIdsProperly() {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getId()).thenReturn((Object)"theAppId");
        Mockito.when((Object)muleConfiguration.getDomainId()).thenReturn((Object)"theDomainId");
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        MuleConfigurationDelegate muleConfigurationDelegate = new MuleConfigurationDelegate();
        muleConfigurationDelegate.setMuleContext(muleContext);
        MatcherAssert.assertThat((Object)muleConfigurationDelegate.getId(), (Matcher)Is.is((Object)"theAppId"));
        MatcherAssert.assertThat((Object)muleConfigurationDelegate.getDomainId(), (Matcher)Is.is((Object)"theDomainId"));
    }

    @Test
    void delegatesDirectoriesProperly() {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getWorkingDirectory()).thenReturn((Object)"theWorkDir");
        Mockito.when((Object)muleConfiguration.getMuleHomeDirectory()).thenReturn((Object)"theHomeDir");
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        MuleConfigurationDelegate muleConfigurationDelegate = new MuleConfigurationDelegate();
        muleConfigurationDelegate.setMuleContext(muleContext);
        MatcherAssert.assertThat((Object)muleConfigurationDelegate.getWorkingDirectory(), (Matcher)Is.is((Object)"theWorkDir"));
        MatcherAssert.assertThat((Object)muleConfigurationDelegate.getMuleHomeDirectory(), (Matcher)Is.is((Object)"theHomeDir"));
    }
}

