/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.resolvers;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.config.internal.registry.AbstractSpringRegistry;
import org.mule.runtime.config.internal.resolvers.AutoDiscoveredDependencyResolver;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.resolvers.DeclaredDependencyResolver;
import org.mule.runtime.config.internal.resolvers.DependencyGraphBeanDependencyResolver;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class DependencyGraphBeanDependencyResolverTestCase {
    private DependencyGraphBeanDependencyResolver resolver;
    private ConfigurationDependencyResolver configurationDependencyResolver;
    private DeclaredDependencyResolver declaredDependencyResolver;
    private AutoDiscoveredDependencyResolver autoDiscoveredDependencyResolver;
    private AbstractSpringRegistry springRegistry;

    @Before
    public void setUp() throws Exception {
        this.configurationDependencyResolver = (ConfigurationDependencyResolver)Mockito.mock(ConfigurationDependencyResolver.class);
        this.declaredDependencyResolver = (DeclaredDependencyResolver)Mockito.mock(DeclaredDependencyResolver.class);
        this.autoDiscoveredDependencyResolver = (AutoDiscoveredDependencyResolver)Mockito.mock(AutoDiscoveredDependencyResolver.class);
        this.springRegistry = (AbstractSpringRegistry)Mockito.mock(AbstractSpringRegistry.class);
        this.resolver = new DependencyGraphBeanDependencyResolver(this.configurationDependencyResolver, this.declaredDependencyResolver, this.autoDiscoveredDependencyResolver, this.springRegistry);
    }

    @Test
    @Description(value="Check if getDirectBeanDependencies calls three different resolvers")
    public void getDirectBeanDependenciesTest() {
        Mockito.when((Object)this.springRegistry.get("component")).thenReturn((Object)new DefaultStreamingManager());
        Object currentObject = this.springRegistry.get("component");
        this.resolver.getTransitiveDependencies("component", 5);
        ((AutoDiscoveredDependencyResolver)Mockito.verify((Object)this.autoDiscoveredDependencyResolver, (VerificationMode)Mockito.times((int)1))).getAutoDiscoveredDependencies("component");
        ((DeclaredDependencyResolver)Mockito.verify((Object)this.declaredDependencyResolver, (VerificationMode)Mockito.times((int)1))).getDeclaredDependencies(currentObject);
        ((ConfigurationDependencyResolver)Mockito.verify((Object)this.configurationDependencyResolver, (VerificationMode)Mockito.times((int)1))).getDirectComponentDependencies("component");
    }

    @Test
    @Description(value="Delegate dependency resolution to autoDiscoveredDependencyResolver")
    public void addAutoDiscoveredDependenciesTest() {
        Mockito.when((Object)this.springRegistry.get("component")).thenReturn((Object)new DefaultStreamingManager());
        this.resolver.getTransitiveDependencies("component", 5);
        ((AutoDiscoveredDependencyResolver)Mockito.verify((Object)this.autoDiscoveredDependencyResolver, (VerificationMode)Mockito.times((int)1))).getAutoDiscoveredDependencies("component");
    }

    @Test
    @Description(value="Delegate dependency resolution to declaredDependencyResolver.")
    public void addDirectDeclaredDependenciesTest() {
        Mockito.when((Object)this.springRegistry.get("component")).thenReturn((Object)new DefaultStreamingManager());
        Object currentObject = this.springRegistry.get("component");
        this.resolver.getTransitiveDependencies("component", 5);
        ((DeclaredDependencyResolver)Mockito.verify((Object)this.declaredDependencyResolver, (VerificationMode)Mockito.times((int)1))).getDeclaredDependencies(currentObject);
    }

    @Test
    @Description(value="Delegate dependency resolution to configurationDependencyResolver.")
    public void addDirectConfigurationDependenciesTest() {
        Mockito.when((Object)this.springRegistry.get("component")).thenReturn((Object)new DefaultStreamingManager());
        this.resolver.getTransitiveDependencies("component", 5);
        ((ConfigurationDependencyResolver)Mockito.verify((Object)this.configurationDependencyResolver, (VerificationMode)Mockito.times((int)1))).getDirectComponentDependencies("component");
    }
}

