/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.dsl.model.AbstractMockedValueProviderExtensionTestCase;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.ComponentAstBasedValueProviderCacheIdGenerator;

public class ComponentAstValueProviderCacheIdGeneratorTestCase
extends AbstractMockedValueProviderExtensionTestCase {
    private Optional<ValueProviderCacheId> computeIdFor(ArtifactAst app, String location, String parameterName) throws Exception {
        Locator locator = new Locator(app);
        ComponentAstBasedValueProviderCacheIdGenerator cacheIdGenerator = new ComponentAstBasedValueProviderCacheIdGenerator((ComponentLocator)locator);
        ComponentAst component = this.getComponentAst(app, location);
        return cacheIdGenerator.getIdForResolvedValues((Object)component, parameterName);
    }

    @Test
    public void idForParameterWithNoProviderInConfig() throws Exception {
        ArtifactAst app = this.loadAst("idForParameterWithNoProviderInConfig_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myConfig", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInSource() throws Exception {
        ArtifactAst app = this.loadAst("idForParameterWithNoProviderInSource_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/source", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInOperation() throws Exception {
        ArtifactAst app = this.loadAst("idForParameterWithNoProviderInOperation_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/processors/0", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForConfigNoChanges() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigNoChanges_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(configId, this.computeIdFor(this.loadAst(this.name.getMethodName() + "_2"), "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingNotActingParameters() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigChangingNotActingParameters_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigChangingNotActingParameters_2");
        this.checkIdsAreEqual(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigChangingActingParameter_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigChangingActingParameter_2");
        this.checkIdsAreDifferent(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameterInGroup() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigChangingActingParameterInGroup_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigChangingActingParameterInGroup_2");
        this.checkIdsAreDifferent(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationNoChanges() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationNoChanges_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationNoChanges_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameter_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameter_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConfig() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConfig_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConfig_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConnection() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConnection_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConnection_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceNoChanges() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceNoChanges_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceNoChanges_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameter_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameter_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConfig() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConfig_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConfig_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConnection() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConnection_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConnection_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareOperationChangesInConfigNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareOperationChangesInConfigNotRequiredForMetadata_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareOperationChangesInConfigRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareOperationChangesInConfigRequiredForMetadata_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareOperationChangesInConnectionRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareOperationChangesInConnectionRequiredForMetadata_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareSourceChangesInConfigNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareSourceChangesInConfigNotRequiredForMetadata_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareSourceChangesInConfigRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareSourceChangesInConfigRequiredForMetadata_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareSourceChangesInConnectionRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareSourceChangesInConnectionRequiredForMetadata_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void equalConfigsWithDifferentNameGetSameHash() throws Exception {
        ArtifactAst app = this.loadAst("equalConfigsWithDifferentNameGetSameHash_1");
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithDifferentProviderIdGetDifferentHash() throws Exception {
        ArtifactAst app = this.loadAst("differentConfigsWithDifferentProviderIdGetDifferentHash_1");
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        ArtifactAst modifiedApp = this.loadAst("differentConfigsWithDifferentProviderIdGetDifferentHash_2");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(modifiedApp, "newName", "providedParameter");
        this.checkIdsAreDifferent(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithSameProviderIdGetSameHash() throws Exception {
        ArtifactAst app = this.loadAst("differentConfigsWithSameProviderIdGetSameHash_1");
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentValueProviderIdGetsDifferentHash() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("differentValueProviderIdGetsDifferentHash_1");
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        ArtifactAst modifiedApp = this.loadAst("differentValueProviderIdGetsDifferentHash_2");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    @Test
    public void differentOperationsWithDifferentProviderIdGetsDifferentHash() throws Exception {
        ArtifactAst app = this.loadAst("differentOperationsWithDifferentProviderIdGetsDifferentHash_1");
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        ArtifactAst modifiedApp = this.loadAst("differentOperationsWithDifferentProviderIdGetsDifferentHash_2");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(modifiedApp, "myFlow/processors/1", "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    @Test
    public void differentOperationsWithSameValueProviderIdGetsSameHash() throws Exception {
        ArtifactAst app = this.loadAst("differentOperationsWithSameValueProviderIdGetsSameHash_1");
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/1", "providedParameter");
        this.checkIdsAreEqual(opId1, opId2);
    }

    private static class Locator
    implements ComponentLocator<ComponentAst> {
        private final Map<Location, ComponentAst> components = new HashMap<Location, ComponentAst>();

        Locator(ArtifactAst app) {
            app.topLevelComponentsStream().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(Location location) {
            return Optional.ofNullable(this.components.get(location));
        }

        private Location getLocation(ComponentAst component) {
            return Location.builderFromStringRepresentation((String)component.getLocation().getLocation()).build();
        }

        private void addComponent(ComponentAst component) {
            this.components.put(this.getLocation(component), component);
            component.directChildrenStream().forEach(this::addComponent);
        }
    }
}

