/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ConstantFactoryBeanTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock(extraInterfaces={MuleContextAware.class})
    private Object value;
    private ConstantFactoryBean<Object> factoryBean;
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private Injector injector = (Injector)Mockito.mock(Injector.class);

    @Before
    public void before() throws Exception {
        this.factoryBean = new ConstantFactoryBean(this.value, true);
        Mockito.when((Object)this.muleContext.getInjector()).thenReturn((Object)this.injector);
        this.factoryBean.setMuleContext(this.muleContext);
    }

    @Test
    public void returnsValue() throws Exception {
        MatcherAssert.assertThat((Object)this.factoryBean.getObject(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.value)));
    }

    @Test
    public void singleton() {
        MatcherAssert.assertThat((Object)this.factoryBean.isSingleton(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void assertClass() {
        MatcherAssert.assertThat((Object)(this.factoryBean.getObjectType() == this.value.getClass() ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void injection() throws Exception {
        this.factoryBean.getObject();
        ((Injector)Mockito.verify((Object)this.injector)).inject(this.value);
    }
}

