/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.config.internal.lazy.AbstractLazyMuleArtifactContextTestCase;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.ResolvableType;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Component life cycle")
@RunWith(value=Parameterized.class)
public class LazyMuleArtifactContextBeanFactoryTestCase
extends AbstractLazyMuleArtifactContextTestCase {
    @Parameterized.Parameter
    public boolean beanFactoryMustThrow;
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private static final String ANOTHER_FLOW = "anotherFlow";
    private final AtomicInteger initializations = new AtomicInteger(0);

    @Parameterized.Parameters(name="BeanFactory throws NoSuchBeanDefinition: {0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.beanFactory.setBeanFactoryMustThrow(this.beanFactoryMustThrow);
    }

    @Test
    public void whenBeanFactoryThrowsThenThrows() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        this.expectedException.expect(NoSuchBeanDefinitionException.class);
        this.lazyMuleArtifactContext.getBean("non-existent");
        MatcherAssert.assertThat((Object)this.beanFactory.isRegisteredBeanDefiniion("non-existent"), (Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE));
    }

    @Test
    public void whenBeanFactoryDoesNotThrowThenDontThrow() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.lazyMuleArtifactContext.getBean("non-existent"), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.beanFactory.isRegisteredBeanDefiniion("non-existent"), (Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE));
    }

    @Test
    public void whenInitializationIsNotDoneYetThenShouldNotCreateBeansOnLookup() {
        if (this.beanFactoryMustThrow) {
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean("myFlow"), NoSuchBeanDefinitionException.class);
        } else {
            this.lazyMuleArtifactContext.getBean("myFlow");
        }
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)this.beanFactory.isRegisteredBeanDefiniion("myFlow"), (Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE));
    }

    @Test
    public void whenInitializationIsDoneThenShouldCreateBeansOnLookup() {
        this.lazyMuleArtifactContext.initializeComponent(Location.builderFromStringRepresentation((String)ANOTHER_FLOW).build());
        this.lazyMuleArtifactContext.getBean("myFlow");
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.beanFactory.isRegisteredBeanDefiniion("myFlow"), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
    }

    @Test
    public void whenBeanAlreadyInitializedThenShouldNotDoItAgain() {
        Location location = Location.builderFromStringRepresentation((String)"myFlow").build();
        this.lazyMuleArtifactContext.initializeComponent(location);
        this.lazyMuleArtifactContext.getBean("myFlow");
        this.lazyMuleArtifactContext.getBean("myFlow");
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.beanFactory.isRegisteredBeanDefiniion("myFlow"), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
    }

    @Test
    public void whenCallingOperationsNotSupportingAutomaticInitializationBeforeInitializationThenDelegates() {
        if (this.beanFactoryMustThrow) {
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean("myFlow", new Object[]{1}), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean(Object.class), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean(Object.class, new Object[]{1}), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBeanProvider(Object.class), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBeanProvider(ResolvableType.forClass(Object.class)), NoSuchBeanDefinitionException.class);
        } else {
            this.lazyMuleArtifactContext.getBean("myFlow", new Object[]{1});
            this.lazyMuleArtifactContext.getBean(Object.class);
            this.lazyMuleArtifactContext.getBean(Object.class, new Object[]{1});
            this.lazyMuleArtifactContext.getBeanProvider(Object.class);
            this.lazyMuleArtifactContext.getBeanProvider(ResolvableType.forClass(Object.class));
        }
    }

    @Test
    public void whenCallingOperationsNotSupportingAutomaticInitializationAfterInitializationThenDelegates() {
        this.lazyMuleArtifactContext.initializeComponent(Location.builderFromStringRepresentation((String)ANOTHER_FLOW).build());
        this.whenCallingOperationsNotSupportingAutomaticInitializationBeforeInitializationThenDelegates();
    }

    @Test
    public void whenCallingGetBeanTypeSafeThenBeanIsInitialized() {
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.getBean("myFlow", Object.class));
    }

    @Test
    public void whenCallingGetAliasesThenBeanIsInitialized() {
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.getAliases("myFlow"));
    }

    private void verifyUnsupportedOperationException(Runnable runnable) {
        this.verifyException(runnable, UnsupportedOperationException.class);
    }

    private void verifyException(Runnable runnable, Class<? extends Throwable> throwableCls) {
        Matcher matcher = CoreMatchers.instanceOf(throwableCls);
        try {
            runnable.run();
            Assert.fail((String)String.format("Expected test to throw: %s", matcher));
        }
        catch (Throwable t) {
            MatcherAssert.assertThat((Object)t, (Matcher)matcher);
        }
    }

    private void verifyInitialized(Runnable runnable) {
        this.lazyMuleArtifactContext.initializeComponent(Location.builderFromStringRepresentation((String)ANOTHER_FLOW).build());
        runnable.run();
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.beanFactory.isRegisteredBeanDefiniion("myFlow"), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
    }

    @Override
    protected ArtifactDeclaration getArtifactDeclaration() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName("myFlow").getDeclaration()).withGlobalElement((GlobalElementDeclaration)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(ANOTHER_FLOW).getDeclaration()).getDeclaration();
    }

    @Override
    protected void onProcessorInitialization() {
        this.initializations.incrementAndGet();
    }
}

