/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.AstConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.ComponentAstBasedMetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.ComponentParameterizationBasedMetadataCacheIdGenerator;

public abstract class AbstractMetadataCacheIdGeneratorTestCase
extends AbstractDslModelTestCase {
    protected Set<ExtensionModel> extensions;
    protected DslResolvingContext dslResolvingContext;

    @Before
    public void setUp() throws Exception {
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        this.dslResolvingContext = DslResolvingContext.getDefault(this.extensions);
    }

    protected MetadataCacheId getIdForComponentOutputMetadata(ArtifactAst app, String location) throws Exception {
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentOutputMetadata((Object)component).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentOutputMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return astBasedId;
    }

    protected MetadataCacheId getIdForComponentAttributesMetadata(ArtifactAst app, String location) throws Exception {
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentAttributesMetadata((Object)component).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentAttributesMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return astBasedId;
    }

    protected MetadataCacheId getIdForComponentInputMetadata(ArtifactAst app, String location, String parameterName) throws Exception {
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentInputMetadata((Object)component, parameterName).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentInputMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component), parameterName).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return astBasedId;
    }

    protected MetadataCacheId getIdForComponentMetadata(ArtifactAst app, String location) throws Exception {
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentMetadata((Object)component).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return astBasedId;
    }

    protected MetadataCacheId getIdForMetadataKeys(ArtifactAst app, String location) throws Exception {
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForMetadataKeys((Object)component).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForMetadataKeys((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return astBasedId;
    }

    protected MetadataCacheId getIdForGlobalMetadata(ArtifactAst app, String location) throws Exception {
        ComponentAst component = new Locator(app).get(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForGlobalMetadata((Object)component).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForGlobalMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return astBasedId;
    }

    private MetadataCacheIdGenerator<ComponentAst> createAstBasedGenerator(ArtifactAst app) {
        return new ComponentAstBasedMetadataCacheIdGenerator((ComponentLocator)new Locator(app));
    }

    private MetadataCacheIdGenerator<ComponentParameterization<?>> createComponentParameterizationBasedGenerator(ArtifactAst app) {
        AstConfigurationMetadataCacheIdGenerator configGenerator = new AstConfigurationMetadataCacheIdGenerator();
        configGenerator.addConfigurations(app.topLevelComponentsStream().filter(potentialConfig -> potentialConfig.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).collect(Collectors.toList()));
        return new ComponentParameterizationBasedMetadataCacheIdGenerator((ConfigurationMetadataCacheIdGenerator)configGenerator);
    }

    protected static class Locator
    implements ComponentLocator<ComponentAst> {
        private final Map<Location, ComponentAst> components = new HashMap<Location, ComponentAst>();

        Locator(ArtifactAst app) {
            app.topLevelComponentsStream().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(Location location) {
            return Optional.ofNullable(this.components.get(location));
        }

        private Location getLocation(ComponentAst component) {
            return Location.builderFromStringRepresentation((String)component.getLocation().getLocation()).build();
        }

        private void addComponent(ComponentAst component) {
            this.components.put(this.getLocation(component), component);
            component.directChildrenStream().forEach(this::addComponent);
        }
    }
}

