/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.dsl.model.AbstractMockedValueProviderExtensionTestCase;
import org.mule.runtime.config.dsl.model.ComplexActingParameter;
import org.mule.runtime.config.dsl.model.ComplexActingParameterUtils;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.ComponentAstBasedValueProviderCacheIdGenerator;

public class ValueProviderCacheIdGeneratorTestCase
extends AbstractMockedValueProviderExtensionTestCase {
    private Optional<ValueProviderCacheId> computeIdFor(ArtifactAst app, String location, String parameterName) throws Exception {
        return this.computeIdFor(app, location, parameterName, null);
    }

    private Optional<ValueProviderCacheId> computeIdFor(ArtifactAst app, String location, String parameterName, String targetSelector) throws Exception {
        AbstractMockedValueProviderExtensionTestCase.Locator locator = new AbstractMockedValueProviderExtensionTestCase.Locator(app);
        ComponentAstBasedValueProviderCacheIdGenerator componentAstBasedValueProviderCacheIdGenerator = new ComponentAstBasedValueProviderCacheIdGenerator((ComponentLocator)locator);
        ComponentAst component = this.getComponentAst(app, location);
        Optional astId = targetSelector == null ? componentAstBasedValueProviderCacheIdGenerator.getIdForResolvedValues((Object)component, parameterName) : componentAstBasedValueProviderCacheIdGenerator.getIdForResolvedValues((Object)component, parameterName, targetSelector);
        return astId;
    }

    @Test
    public void idForParameterWithNoProviderInConfig() throws Exception {
        ArtifactAst app = this.loadAst("idForParameterWithNoProviderInConfig_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myConfig", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInSource() throws Exception {
        ArtifactAst app = this.loadAst("idForParameterWithNoProviderInConfig_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/source", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInOperation() throws Exception {
        ArtifactAst app = this.loadAst("idForParameterWithNoProviderInOperation_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/processors/0", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForConfigNoChanges() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigNoChanges_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigNoChanges_2");
        this.checkIdsAreEqual(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingNotActingParameters() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigChangingNotActingParameters_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigChangingNotActingParameters_2");
        this.checkIdsAreEqual(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigChangingActingParameter_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigChangingActingParameter_2");
        this.checkIdsAreDifferent(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameterInGroup() throws Exception {
        ArtifactAst app = this.loadAst("idForConfigChangingActingParameterInGroup_1");
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigChangingActingParameterInGroup_2");
        this.checkIdsAreDifferent(configId, this.computeIdFor(modifiedApp, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationNoChanges() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationNoChanges_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationNoChanges_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameter_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameter_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationDefaultValueHashIdShouldBeSameWithExplicitValueOnActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationDefaultValueHashIdShouldBeSameWithExplicitValueOnActingParameter_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationDefaultValueHashIdShouldBeSameWithExplicitValueOnActingParameter_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConfig() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConfig_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConfig_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConnection() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConnection_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessOperationChangesInConnection_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceNoChanges() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceNoChanges_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedAst = this.loadAst("idForConfiglessAndConnectionlessSourceNoChanges_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedAst, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameter() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameter_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameter_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConfig() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConfig_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConfig_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConnection() throws Exception {
        ArtifactAst app = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConnection_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfiglessAndConnectionlessSourceChangesInConnection_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareOperationChangesInConfigNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareOperationChangesInConfigNotRequiredForMetadata_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareOperationChangesInConfigRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareOperationChangesInConfigRequiredForMetadata_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata_2");
        this.checkIdsAreEqual(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareOperationChangesInConnectionRequiredForMetadata_1");
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareOperationChangesInConnectionRequiredForMetadata_2");
        this.checkIdsAreDifferent(opId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareSourceChangesInConfigNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareSourceChangesInConfigNotRequiredForMetadata_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConfigAwareSourceChangesInConfigRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConfigAwareSourceChangesInConfigRequiredForMetadata_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata_2");
        this.checkIdsAreEqual(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionRequiredForMetadata() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("idForConnectionAwareSourceChangesInConnectionRequiredForMetadata_1");
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("idForConnectionAwareSourceChangesInConnectionRequiredForMetadata_2");
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(modifiedApp, "myFlow/source", "providedParameter"));
    }

    @Test
    public void equalConfigsWithDifferentNameGetSameHash() throws Exception {
        ArtifactAst app = this.loadAst("equalConfigsWithDifferentNameGetSameHash_1");
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithSameParameterGetSameHash() throws Exception {
        ArtifactAst app = this.loadAst("differentConfigsWithSameParameterGetSameHash_1");
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentValueProviderNameGetsSameHash() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("differentValueProviderNameGetsSameHash_1");
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderName()).thenReturn((Object)"newValueProviderName");
        ArtifactAst modifiedApp = this.loadAst("differentValueProviderNameGetsSameHash_2");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter");
        this.checkIdsAreEqual(opId1, opId2);
    }

    @Test
    public void differentValueProviderIdGetsDifferentHash() throws Exception {
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        ArtifactAst app = this.loadAst("differentValueProviderIdGetsDifferentHash_1");
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        ArtifactAst modifiedApp = this.loadAst("differentValueProviderIdGetsDifferentHash_2");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    @Test
    public void differentOperationsWithSameParametersGetsSameHash() throws Exception {
        ArtifactAst app = this.loadAst("differentOperationsWithSameParametersGetsSameHash_1");
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/1", "providedParameter");
        this.checkIdsAreEqual(opId1, opId2);
    }

    @Test
    public void differentHashForComplexActingParameterValue() throws Exception {
        LinkedList allIds = new LinkedList();
        AtomicInteger index = new AtomicInteger();
        ComplexActingParameterUtils.forAllComplexActingParameterChanges("myFlow/processors/0", "complexActingParameter", (CheckedConsumer<ComplexActingParameter>)((CheckedConsumer)v -> allIds.add(this.computeIdFor(this.loadAst("differentHashForComplexActingParameterValue_" + index.incrementAndGet()), "myFlow/processors/0", "fromComplexActingParameter"))));
        for (Optional idA : allIds) {
            for (Optional idB : allIds) {
                if (idA == idB) continue;
                this.checkIdsAreDifferent(idA, idB);
            }
        }
    }

    @Test
    public void extractionExpressionIsUsedForActingParameters() throws Exception {
        String extractionExpression = "actingParameter";
        String otherParameterName = "otherParameterName";
        ActingParameterModel actingParameterModel = this.createActingParameterModel("otherParameterName");
        Mockito.when((Object)actingParameterModel.getExtractionExpression()).thenReturn((Object)"actingParameter");
        Mockito.when((Object)this.valueProviderModel.getActingParameters()).thenReturn(Collections.singletonList("otherParameterName"));
        Mockito.when((Object)this.valueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        ArtifactAst app = this.loadAst("extractionExpressionIsUsedForActingParameters_1");
        Optional<ValueProviderCacheId> operationId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)operationId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("extractionExpressionIsUsedForActingParameters_2");
        this.checkIdsAreDifferent(operationId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void wholeParameterIsUsedIfExpressionPointsToField() throws Exception {
        String extractionExpression = "complexActingParameter.stringParam";
        ActingParameterModel actingParameterModel = this.createActingParameterModel("actingParameter");
        Mockito.when((Object)actingParameterModel.getExtractionExpression()).thenReturn((Object)"complexActingParameter.stringParam");
        Mockito.when((Object)this.valueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        ArtifactAst app = this.loadAst("wholeParameterIsUsedIfExpressionPointsToField_1");
        Optional<ValueProviderCacheId> operationId = this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter");
        MatcherAssert.assertThat((Object)operationId.isPresent(), (Matcher)Matchers.is((Object)true));
        ArtifactAst modifiedApp = this.loadAst("wholeParameterIsUsedIfExpressionPointsToField_2");
        this.checkIdsAreDifferent(operationId, this.computeIdFor(modifiedApp, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void presentFieldValueProviderGetsId() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        Mockito.when((Object)this.providedParameter.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactAst app = this.loadAst("presentFieldValueProviderGetsId_1");
        Optional<ValueProviderCacheId> cacheId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "some.target.path");
        MatcherAssert.assertThat((Object)cacheId.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        cacheId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "other.field");
        MatcherAssert.assertThat((Object)cacheId.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void changesInParameterWithActingFieldReturnsDifferentHash() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        ActingParameterModel actingParameterModel = this.createActingParameterModel("complexActingParameter", "complexActingParameter.innerPojoParam.stringParam");
        Mockito.when((Object)fieldValueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        Mockito.when((Object)this.providedParameterFromComplex.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        LinkedList allIds = new LinkedList();
        AtomicInteger index = new AtomicInteger();
        ComplexActingParameterUtils.forAllComplexActingParameterChanges("myFlow/processors/0", "complexActingParameter", (CheckedConsumer<ComplexActingParameter>)((CheckedConsumer)v -> allIds.add(this.computeIdFor(this.loadAst("changesInParameterWithActingFieldReturnsDifferentHash_" + index.incrementAndGet()), "myFlow/processors/0", "fromComplexActingParameter", "some.target.path"))));
        for (Optional idA : allIds) {
            for (Optional idB : allIds) {
                if (idA == idB) continue;
                this.checkIdsAreDifferent(idA, idB);
            }
        }
    }

    @Test
    public void actingFieldFromNotExistentParameterIsNotConsideredForId() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        ActingParameterModel actingParameterModel = this.createActingParameterModel("actingParameter", "notExistentParam.stringParam");
        Mockito.when((Object)fieldValueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        Mockito.when((Object)this.providedParameter.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactAst app = this.loadAst("actingFieldFromNotExistentParameterIsNotConsideredForId_1");
        Optional<ValueProviderCacheId> id = this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "some.target.path");
        MatcherAssert.assertThat((Object)id.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void actingFieldAsExpressionUsesWholeParameter() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        ActingParameterModel actingParameterModel = this.createActingParameterModel("complexActingParameter", "complexActingParameter.innerPojoParam.stringParam");
        Mockito.when((Object)fieldValueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        Mockito.when((Object)this.providedParameterFromComplex.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactAst app = this.loadAst("actingFieldAsExpressionUsesWholeParameter_1");
        Optional<ValueProviderCacheId> originalExpressionId = this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter", "some.target.path");
        ArtifactAst modifiedApp = this.loadAst("actingFieldAsExpressionUsesWholeParameter_2");
        Optional<ValueProviderCacheId> otherExpressionId = this.computeIdFor(modifiedApp, "myFlow/processors/0", "fromComplexActingParameter", "some.target.path");
        this.checkIdsAreDifferent(originalExpressionId, otherExpressionId);
    }

    @Test
    public void invalidTargetSelector() throws Exception {
        ArtifactAst app = this.loadAst("invalidTargetSelector_1");
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "this-is-not&a$$$val*d@path").isPresent(), (Matcher)Matchers.is((Object)false));
    }
}

