/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.utils.UtilsJavax;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class InjectParamsFromContextServiceMethodInvokerJavaxTestCase
extends AbstractMuleContextTestCase {
    @Inject
    private Registry registry;
    private InjectParamsFromContextServiceMethodInvoker injectParamsFromContextServiceMethodInvoker;
    private Method method;

    protected boolean doTestClassInjection() {
        return true;
    }

    @Before
    public void setUp() throws NoSuchMethodException {
        this.injectParamsFromContextServiceMethodInvoker = new InjectParamsFromContextServiceMethodInvoker(this.registry);
        this.method = UtilsJavax.BaseService.class.getMethod("augmented", new Class[0]);
        UtilsJavax.augmentedParam = null;
    }

    @Test
    public void notAugmentedInvocation() throws Throwable {
        UtilsJavax.BasicService service = new UtilsJavax.BasicService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void augmentedInvocation() throws Throwable {
        UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassInvocation() throws Throwable {
        UtilsJavax.AugmentedSubclassMethodService service = new UtilsJavax.AugmentedSubclassMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassOverridesInvocation() throws Throwable {
        UtilsJavax.AugmentedSubclassOverridesMethodService service = new UtilsJavax.AugmentedSubclassOverridesMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void namedAugmentedInvocation() throws Throwable {
        UtilsJavax.NamedAugmentedMethodService service = new UtilsJavax.NamedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void invalidNamedAugmentedInvocation() throws Throwable {
        UtilsJavax.InvalidNamedAugmentedMethodService service = new UtilsJavax.InvalidNamedAugmentedMethodService();
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", this.method.getName(), service.toString())));
    }

    @Test
    public void hiddenAugmentedInvocation() throws Throwable {
        UtilsJavax.HiddenAugmentedMethodService service = new UtilsJavax.HiddenAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation() throws Throwable {
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation2() throws Throwable {
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        List<Method> methods = Arrays.asList(UtilsJavax.OverloadedAugmentedMethodService.class.getMethods());
        Optional<Method> method = methods.stream().filter(m -> m.getName().equals("augmented") && m.getParameterCount() == 1 && !m.getParameters()[0].getName().contains("context")).findFirst();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method.get(), new Object[]{1});
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void ambiguousAugmentedInvocation() throws Throwable {
        UtilsJavax.AmbiguousAugmentedMethodService service = new UtilsJavax.AmbiguousAugmentedMethodService();
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("More than one invocation candidate for method '%s' in service '%s'", this.method.getName(), service.toString())));
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    public void invalidAugmentedInvocation() throws Throwable {
        UtilsJavax.InvalidAugmentedMethodService service = new UtilsJavax.InvalidAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }
}

