/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import io.qameta.allure.Feature;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.DefaultCustomizationService;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Customization Service")
public class DefaultCustomizationServiceTestCase
extends AbstractMuleTestCase {
    public static final String SERVICE_ID = "foo";
    private DefaultCustomizationService customizationService = new DefaultCustomizationService();

    @Test
    void overridesDefaultServiceClass() throws Exception {
        Class<String> serviceClass = String.class;
        this.customizationService.overrideDefaultServiceClass(SERVICE_ID, serviceClass);
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        this.assertServiceClass(customService, serviceClass);
    }

    @Test
    void overridesDefaultService() throws Exception {
        Object service = new Object();
        this.customizationService.overrideDefaultServiceImpl(SERVICE_ID, service);
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        this.assertServiceInstance(customService, service);
    }

    @Test
    void registersCustomServiceClass() throws Exception {
        Class<String> serviceClass = String.class;
        this.customizationService.registerCustomServiceClass(SERVICE_ID, serviceClass);
        MatcherAssert.assertThat((Object)this.customizationService.getCustomServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getCustomServices().get(SERVICE_ID);
        this.assertServiceClass(customService, serviceClass);
    }

    @Test
    void registersCustomService() throws Exception {
        Object service = new Object();
        this.customizationService.registerCustomServiceImpl(SERVICE_ID, service);
        MatcherAssert.assertThat((Object)this.customizationService.getCustomServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getCustomServices().get(SERVICE_ID);
        this.assertServiceInstance(customService, service);
    }

    @Test
    void interceptsDefaultService() {
        Object defaultService = new Object();
        Object service = new Object();
        this.customizationService.interceptDefaultServiceImpl(SERVICE_ID, serviceInterceptor -> {
            MatcherAssert.assertThat((Object)serviceInterceptor.getDefaultServiceImpl().isPresent(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat(serviceInterceptor.getDefaultServiceImpl().get(), (Matcher)Is.is((Object)defaultService));
            serviceInterceptor.overrideServiceImpl(service);
        });
        MatcherAssert.assertThat((Object)this.customizationService.getDefaultServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        this.assertServiceInstanceWithDefault(customService, defaultService, service);
    }

    @Test
    void interceptsWithoutDefaultService() {
        Object service = new Object();
        this.customizationService.interceptDefaultServiceImpl(SERVICE_ID, serviceInterceptor -> {
            MatcherAssert.assertThat((Object)serviceInterceptor.getDefaultServiceImpl().isPresent(), (Matcher)Is.is((Object)false));
            serviceInterceptor.overrideServiceImpl(service);
        });
        MatcherAssert.assertThat((Object)this.customizationService.getDefaultServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        this.assertServiceInstance(customService, service);
    }

    @Test
    void skipsDefaultService() {
        this.customizationService.interceptDefaultServiceImpl(SERVICE_ID, CustomizationService.ServiceInterceptor::remove);
        MatcherAssert.assertThat((Object)this.customizationService.getDefaultServices().size(), (Matcher)IsEqual.equalTo((Object)1));
        CustomService customService = (CustomService)this.customizationService.getOverriddenService(SERVICE_ID).get();
        MatcherAssert.assertThat((Object)customService.getServiceImpl().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    void artifactProperties() {
        HashMap<String, String> artifactProperties = new HashMap<String, String>();
        artifactProperties.put("key1", "value1");
        this.customizationService.setArtifactProperties(artifactProperties);
        artifactProperties.put("key2", "value2");
        this.customizationService.setArtifactType(ArtifactType.DOMAIN);
        MatcherAssert.assertThat((Object)this.customizationService.getArtifactProperties(), (Matcher)IsMapContaining.hasKey((Object)"key1"));
        MatcherAssert.assertThat((Object)this.customizationService.getArtifactProperties(), (Matcher)Matchers.not((Matcher)IsMapContaining.hasKey((Object)"key2")));
        MatcherAssert.assertThat((Object)this.customizationService.getArtifactType(), (Matcher)Is.is((Object)ArtifactType.DOMAIN));
    }

    private void assertServiceInstance(CustomService customService, Object service) {
        MatcherAssert.assertThat(customService.getServiceImpl().get(), (Matcher)IsEqual.equalTo((Object)service));
        MatcherAssert.assertThat((Object)customService.getServiceClass().isPresent(), (Matcher)Is.is((Object)false));
    }

    private void assertServiceInstanceWithDefault(CustomService customService, Object defaultService, Object service) {
        MatcherAssert.assertThat(customService.getServiceImpl(defaultService).get(), (Matcher)IsEqual.equalTo((Object)service));
        MatcherAssert.assertThat((Object)customService.getServiceClass().isPresent(), (Matcher)Is.is((Object)false));
    }

    private void assertServiceClass(CustomService customService, Class<String> serviceClass) {
        MatcherAssert.assertThat(customService.getServiceClass().get(), (Matcher)IsEqual.equalTo(serviceClass));
        MatcherAssert.assertThat((Object)customService.getServiceImpl().isPresent(), (Matcher)Is.is((Object)false));
    }
}

