/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model.internal.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.properties.api.ResourceProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.IsEqualIgnoringLineBreaks;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
public class FileConfigurationPropertiesProviderTestCase
extends AbstractMuleTestCase {
    private ConfigurationPropertiesResolver resolver;

    @BeforeEach
    public void createResolver() {
        ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader());
        this.resolver = new ConfigurationPropertiesHierarchyBuilder().withPropertiesFile((ResourceProvider)externalResourceProvider).build();
    }

    @Test
    void fileIsResolved() {
        MatcherAssert.assertThat((Object)((String)this.resolver.resolveValue("${file::dummy.xml}")), (Matcher)Is.is((Matcher)IsEqualIgnoringLineBreaks.equalToIgnoringLineBreaks((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foo/>\n")));
    }

    @Test
    void fileDoesNotExist() {
        Exception thrown = (Exception)Assertions.assertThrows(Exception.class, () -> this.resolver.resolveValue("${file::non-existing-file}"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"Couldn't find configuration property value for key ${file::non-existing-file}"));
    }
}

