/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.config.internal.registry;

import static org.mule.runtime.core.privileged.registry.LegacyRegistryUtils.registerObject;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.mock;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.core.api.config.MuleProperties;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

import io.qameta.allure.Description;
import org.junit.Test;
import javax.inject.Inject;
import javax.inject.Named;

public class QueueManagerInjectTestCase extends AbstractMuleContextTestCase {

  @Test
  @Description("Tests that injecting either new or old api is correct")
  public void injectQueueManager() throws Exception {
    org.mule.runtime.api.queue.QueueManager mockNewQM = mock(org.mule.runtime.api.queue.QueueManager.class);
    org.mule.runtime.core.api.util.queue.QueueManager mockOldQM = mock(org.mule.runtime.core.api.util.queue.QueueManager.class);
    registerObject(muleContext, QueueManager.OBJECT_QUEUE_MANAGER, mockNewQM);
    registerObject(muleContext, MuleProperties.OBJECT_QUEUE_MANAGER, mockOldQM);

    QueueManagerConsumer consumer = new QueueManagerConsumer();
    muleContext.getInjector().inject(consumer);

    assertThat(consumer.getNewApiQueueManager(), is(mockNewQM));
    assertThat(consumer.getOldCoreApiQueueManager(), is(mockOldQM));
  }

  public static class QueueManagerConsumer {

    private org.mule.runtime.api.queue.QueueManager newApiQueueManager;
    private org.mule.runtime.core.api.util.queue.QueueManager oldCoreApiQueueManager;


    public org.mule.runtime.api.queue.QueueManager getNewApiQueueManager() {
      return newApiQueueManager;
    }

    public org.mule.runtime.core.api.util.queue.QueueManager getOldCoreApiQueueManager() {
      return oldCoreApiQueueManager;
    }

    @Inject
    @Named(QueueManager.OBJECT_QUEUE_MANAGER)
    public void setNewQueueManager(org.mule.runtime.api.queue.QueueManager queueManager) {
      this.newApiQueueManager = queueManager;
    }

    @Inject
    @Named(MuleProperties.OBJECT_QUEUE_MANAGER)
    public void setOldQueueManager(org.mule.runtime.core.api.util.queue.QueueManager queueManager) {
      this.oldCoreApiQueueManager = queueManager;
    }
  }
}
