/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.utils.UtilsJavax;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class InjectParamsFromContextServiceProxyJavaxTestCase
extends AbstractMuleContextTestCase {
    @Inject
    private Registry registry;

    @Before
    public void setUo() {
        UtilsJavax.augmentedParam = null;
    }

    protected boolean doTestClassInjection() {
        return true;
    }

    @Test
    public void notAugmentedInvocation() {
        UtilsJavax.BasicService service = new UtilsJavax.BasicService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void augmentedInvocation() {
        UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassInvocation() {
        UtilsJavax.AugmentedSubclassMethodService service = new UtilsJavax.AugmentedSubclassMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassOverridesInvocation() {
        UtilsJavax.AugmentedSubclassOverridesMethodService service = new UtilsJavax.AugmentedSubclassOverridesMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void namedAugmentedInvocation() {
        UtilsJavax.NamedAugmentedMethodService service = new UtilsJavax.NamedAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void invalidNamedAugmentedInvocation() {
        UtilsJavax.InvalidNamedAugmentedMethodService service = new UtilsJavax.InvalidNamedAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> serviceProxy.augmented());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", "augmented", "InvalidNamedAugmentedMethodService")));
    }

    @Test
    public void hiddenAugmentedInvocation() {
        UtilsJavax.HiddenAugmentedMethodService service = new UtilsJavax.HiddenAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation() {
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        UtilsJavax.BaseOverloadedService serviceProxy = (UtilsJavax.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation2() {
        UtilsJavax.OverloadedAugmentedMethodService service = new UtilsJavax.OverloadedAugmentedMethodService();
        UtilsJavax.BaseOverloadedService serviceProxy = (UtilsJavax.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(1);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void overloadedAugmentedInvocation3() {
        UtilsJavax.OverloadedAugmentedMethodService2 service = new UtilsJavax.OverloadedAugmentedMethodService2();
        UtilsJavax.BaseOverloadedService2 serviceProxy = (UtilsJavax.BaseOverloadedService2)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(muleContext, 1);
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void ambiguousAugmentedInvocation() {
        UtilsJavax.AmbiguousAugmentedMethodService service = new UtilsJavax.AmbiguousAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> serviceProxy.augmented());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("More than one invocation candidate for method '%s' in service '%s'", "augmented", "AmbiguousAugmentedMethodService")));
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    public void invalidAugmentedInvocation() {
        UtilsJavax.InvalidAugmentedMethodService service = new UtilsJavax.InvalidAugmentedMethodService();
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void throughProxyAugmentedInvocation() {
        final UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        MetadataInvocationHandler<UtilsJavax.BaseService> noOpHandler = new MetadataInvocationHandler<UtilsJavax.BaseService>((UtilsJavax.BaseService)service){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)service, args);
            }
        };
        UtilsJavax.BaseService innerProxy = (UtilsJavax.BaseService)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{UtilsJavax.BaseService.class}, (InvocationHandler)noOpHandler);
        UtilsJavax.BaseService serviceProxy = (UtilsJavax.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)innerProxy, (Registry)this.registry);
        serviceProxy.augmented();
        MatcherAssert.assertThat((Object)UtilsJavax.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }
}

