/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.bean.DefaultObjectSerializerDelegate;
import org.mule.runtime.config.internal.bean.MuleConfigurationDelegate;
import org.mule.runtime.config.internal.context.AbstractSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.internal.el.DataWeaveExtendedExpressionLanguageAdaptorFactoryBean;
import org.mule.runtime.config.internal.el.DefaultExpressionManagerFactoryBean;
import org.mule.runtime.config.internal.factories.SchedulerBaseConfigFactory;
import org.mule.runtime.config.internal.lazy.LazyDataWeaveExtendedExpressionLanguageAdaptorFactoryBean;
import org.mule.runtime.config.internal.registry.SpringRegistryBootstrap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.management.stats.ArtifactMeterProvider;
import org.mule.runtime.core.internal.alert.DefaultAlertingSupport;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.profiling.ProfilingServiceWrapper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transformer.DefaultTransformersRegistry;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.metrics.api.MeterProvider;
import org.mule.runtime.metrics.api.error.ErrorMetricsFactory;
import org.mule.runtime.metrics.exporter.impl.OpenTelemetryMeterExporterFactory;
import org.mule.runtime.metrics.exporter.impl.optel.config.OpenTelemetryAutoConfigurableMeterExporterConfiguration;
import org.mule.runtime.metrics.impl.DefaultMeterProvider;
import org.mule.runtime.metrics.impl.meter.error.DefaultErrorMetricsFactory;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxy;
import org.mule.runtime.module.service.internal.manager.MethodInvoker;
import org.mule.runtime.tracer.customization.impl.provider.DefaultInitialSpanInfoProvider;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterFactory;
import org.mule.runtime.tracer.exporter.impl.optel.config.OpenTelemetryAutoConfigurableSpanExporterConfiguration;
import org.mule.runtime.tracer.impl.CoreEventComponentTracerFactory;
import org.mule.runtime.tracer.impl.SelectableCoreEventTracer;
import org.mule.runtime.tracer.impl.span.factory.ExecutionSpanFactory;
import org.mule.runtime.tracing.level.impl.config.FileTracingLevelConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BaseSpringMuleContextServiceConfigurator
extends AbstractSpringMuleContextServiceConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSpringMuleContextServiceConfigurator.class);
    @Deprecated
    public static final String DISABLE_TRANSFORMERS_SUPPORT = BaseSpringMuleContextServiceConfigurator.class.getName() + ".disableTransformersSupport";
    private final Map<String, BeanDefinition> baseContextServices = Map.ofEntries(Map.entry("_muleTimeSupplier", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(LocalTimeSupplier.class)), Map.entry("_muleAlertingSupport", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultAlertingSupport.class)), Map.entry("_muleSpanExporterConfiguration", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetryAutoConfigurableSpanExporterConfiguration.class)), Map.entry("_muleProfilingService", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(ProfilingServiceWrapper.class)), Map.entry("_muleCoreSpanFactory", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(ExecutionSpanFactory.class)), Map.entry("_muleCoreExporterFactory", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetrySpanExporterFactory.class)), Map.entry("_muleCoreEventTracer", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(SelectableCoreEventTracer.class)), Map.entry("_muleCoreComponentTracerFactory", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(CoreEventComponentTracerFactory.class)), Map.entry("_muleErrorMetricsFactory", BaseSpringMuleContextServiceConfigurator.resolveErrorMetricsFactory()), Map.entry("_muleMeterProvider", this.resolveBaseArtifactMeterProvider()), Map.entry("_muleMeterExporterConfiguration", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetryAutoConfigurableMeterExporterConfiguration.class)), Map.entry("_muleMeterExporterFactory", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetryMeterExporterFactory.class)), Map.entry("_muleTracingLevelConfiguration", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(FileTracingLevelConfiguration.class)), Map.entry("_muleTracerInitialSpanInfoProvider", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultInitialSpanInfoProvider.class)), Map.entry("_muleStreamingManager", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamingManager.class)), Map.entry("_muleStreamingGhostBuster", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(StreamingGhostBuster.class)));
    private final MuleContext muleContext;
    private final ArtifactType artifactType;
    private final ConfigurationProperties configurationProperties;
    private final boolean enableLazyInit;
    private final org.mule.runtime.api.artifact.Registry serviceLocator;
    private Registry originalRegistry;

    public BaseSpringMuleContextServiceConfigurator(MuleContext muleContext, ConfigurationProperties configurationProperties, ArtifactType artifactType, BeanDefinitionRegistry beanDefinitionRegistry, org.mule.runtime.api.artifact.Registry serviceLocator, Registry originalRegistry, boolean enableLazyInit) {
        super((InternalCustomizationService)muleContext.getCustomizationService(), beanDefinitionRegistry);
        this.muleContext = muleContext;
        this.configurationProperties = configurationProperties;
        this.artifactType = artifactType;
        this.serviceLocator = serviceLocator;
        this.originalRegistry = originalRegistry;
        this.enableLazyInit = enableLazyInit;
    }

    void createArtifactServices() {
        FeatureFlaggingService featureFlaggingService = (FeatureFlaggingService)this.originalRegistry.lookupObject("core.featureFlaggingService");
        this.registerConstantBeanDefinition("core.featureFlaggingService", featureFlaggingService);
        this.registerConstantBeanDefinition("_muleArtifactEncoding", this.originalRegistry.lookupObject("_muleArtifactEncoding"));
        this.registerConstantBeanDefinition("_muleConfigurationComponentLocator", new BaseConfigurationComponentLocator());
        this.registerBeanDefinition("_muleArtifactMeterProvider", this.resolveArtifactIdMeterProvider());
        if (!this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            this.loadServiceConfigurators();
        }
        this.registerContextServices(this.baseContextServices, this.artifactType.equals((Object)ArtifactType.DOMAIN));
        ContributedErrorTypeRepository contributedErrorTypeRepository = new ContributedErrorTypeRepository();
        this.registerConstantBeanDefinition(ErrorTypeRepository.class.getName(), contributedErrorTypeRepository);
        ContributedErrorTypeLocator contributedErrorTypeLocator = new ContributedErrorTypeLocator();
        contributedErrorTypeLocator.setDelegate(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)contributedErrorTypeRepository, Optional.of(featureFlaggingService)));
        this.registerConstantBeanDefinition(ErrorTypeLocator.class.getName(), contributedErrorTypeLocator);
        this.registerConstantBeanDefinition("_muleConfigurationAttributesResolver", this.configurationProperties);
        if (!Boolean.getBoolean(DISABLE_TRANSFORMERS_SUPPORT)) {
            this.registerBeanDefinition("_muleTransfromerResolver", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(TypeBasedTransformerResolver.class));
            this.registerBeanDefinition("_muleTransfromersRegistry", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultTransformersRegistry.class));
        }
        this.registerLazyInitialisationAwareBeans();
        this.registerBeanDefinition("_muleExpressionManager", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultExpressionManagerFactoryBean.class));
        this.registerBeanDefinition("_muleSchedulerPoolsConfig", BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(SchedulerContainerPoolsConfig.getInstance()));
        this.registerBeanDefinition("_muleSchedulerBaseConfig", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(SchedulerBaseConfigFactory.class));
        this.registerConstantBeanDefinition("_muleRegistry", this.serviceLocator);
        this.registerBeanDefinition("_muleDefaultObjectSerializer", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectSerializerDelegate.class));
        this.registerBeanDefinition("_muleConfiguration", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(MuleConfigurationDelegate.class));
        this.createRuntimeServices();
        this.createBootstrapBeanDefinitions();
        this.absorbOriginalRegistry();
    }

    private void registerLazyInitialisationAwareBeans() {
        if (this.enableLazyInit) {
            this.registerBeanDefinition("_muleDwExpressionLanguageAdapter", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(LazyDataWeaveExtendedExpressionLanguageAdaptorFactoryBean.class));
        } else {
            this.registerBeanDefinition("_muleDwExpressionLanguageAdapter", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DataWeaveExtendedExpressionLanguageAdaptorFactoryBean.class));
        }
    }

    protected void createBootstrapBeanDefinitions() {
        try {
            SpringRegistryBootstrap springRegistryBootstrap = new SpringRegistryBootstrap(this.artifactType, this.muleContext.getRegistryBootstrapServiceDiscoverer(), this::registerBeanDefinition, AbstractRegistryBootstrap.BINDING_PROVIDER_PREDICATE.or(AbstractRegistryBootstrap.TRANSFORMER_PREDICATE));
            springRegistryBootstrap.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
    }

    private void createRuntimeServices() {
        Map customServices = this.getCustomizationService().getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = (CustomService)customServices.get(serviceName);
            if (!customService.isBaseContext() && !this.isServiceRuntimeProvided(customService)) continue;
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService, serviceName);
            LOGGER.debug("Registering runtime service '{}' for {}...", (Object)serviceName, (Object)this.artifactType.name());
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    @Override
    protected BeanDefinition addServiceProxyParamsInjector(Object servImpl) {
        BeanDefinition beanDefinition;
        if (Proxy.isProxyClass(servImpl.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(servImpl);
            if (handler instanceof LazyServiceProxy) {
                LazyServiceProxy lazyHandker = (LazyServiceProxy)handler;
                servImpl = lazyHandker.forApplication((MethodInvoker)new InjectParamsFromContextServiceMethodInvoker(this.serviceLocator));
            }
            beanDefinition = BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(servImpl, true);
        } else {
            beanDefinition = BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)servImpl, this.serviceLocator), true);
        }
        return beanDefinition;
    }

    private void absorbOriginalRegistry() {
        if (this.originalRegistry == null) {
            return;
        }
        this.originalRegistry.lookupByType(Object.class).forEach(this::registerConstantBeanDefinition);
        this.originalRegistry = null;
    }

    private static BeanDefinition getPrimaryBeanDefinition(Object beanType) {
        BeanDefinition beanDefinition = BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(beanType);
        beanDefinition.setPrimary(true);
        return beanDefinition;
    }

    private BeanDefinition resolveBaseArtifactMeterProvider() {
        if (Boolean.getBoolean("mule.open.telemetry.metric.exporter")) {
            return BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMeterProvider.class);
        }
        return BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(MeterProvider.NO_OP);
    }

    private static BeanDefinition resolveErrorMetricsFactory() {
        if (Boolean.getBoolean("mule.open.telemetry.metric.exporter")) {
            return BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultErrorMetricsFactory.class);
        }
        return BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(ErrorMetricsFactory.NO_OP);
    }

    private BeanDefinition resolveArtifactIdMeterProvider() {
        if (Boolean.getBoolean("mule.open.telemetry.metric.exporter")) {
            return BaseSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ArtifactMeterProvider.class).addConstructorArgReference("_muleMeterProvider").addConstructorArgValue((Object)this.muleContext.getId()).setPrimary(true).getBeanDefinition();
        }
        return BaseSpringMuleContextServiceConfigurator.getPrimaryBeanDefinition(MeterProvider.NO_OP);
    }
}

