/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.config.dsl.model.ComplexActingParameter;
import org.mule.runtime.config.dsl.model.InnerPojo;
import org.mule.tck.util.func.CheckedConsumer;

public class ComplexActingParameterUtils {
    static final ComplexActingParameter DEFAULT_COMPLEX_ACTING_PARAMETER;

    private ComplexActingParameterUtils() {
    }

    static ParameterValue declareComplexActingParameter(ComplexActingParameter complexActingParameter) {
        int intParam = complexActingParameter.getIntParam();
        String stringParam = complexActingParameter.getStringParam();
        List<String> listParam = complexActingParameter.getListParam();
        Map<String, String> mapParam = complexActingParameter.getMapParam();
        InnerPojo innerPojo = complexActingParameter.getInnerPojoParam();
        List<InnerPojo> complexList = complexActingParameter.getComplexListParam();
        Map<String, InnerPojo> complexMap = complexActingParameter.getComplexMapParam();
        ParameterListValue.Builder listValueBuilder = ParameterListValue.builder();
        listParam.forEach(arg_0 -> ((ParameterListValue.Builder)listValueBuilder).withValue(arg_0));
        ParameterListValue.Builder complexListBuilder = ParameterListValue.builder();
        complexList.forEach(i -> complexListBuilder.withValue(ComplexActingParameterUtils.declareInnerPojo(i)));
        ParameterObjectValue.Builder mapBuilder = ParameterObjectValue.builder();
        mapParam.forEach((arg_0, arg_1) -> ((ParameterObjectValue.Builder)mapBuilder).withParameter(arg_0, arg_1));
        ParameterObjectValue.Builder complexMapBuilder = ParameterObjectValue.builder();
        complexMap.forEach((k, v) -> complexMapBuilder.withParameter(k, ComplexActingParameterUtils.declareInnerPojo(v)));
        return ParameterObjectValue.builder().withParameter("innerPojoParam", ComplexActingParameterUtils.declareInnerPojo(innerPojo)).withParameter("intParam", Integer.toString(intParam)).withParameter("stringParam", stringParam).withParameter("listParam", (ParameterValue)listValueBuilder.build()).withParameter("mapParam", (ParameterValue)mapBuilder.build()).withParameter("complexListParam", (ParameterValue)complexListBuilder.build()).withParameter("complexMapParam", (ParameterValue)complexMapBuilder.build()).build();
    }

    static void forAllComplexActingParameterChanges(String componentLocation, String complexActingParameterName, CheckedConsumer<ComplexActingParameter> newValueConsumer) {
        int defaultInt = DEFAULT_COMPLEX_ACTING_PARAMETER.getIntParam();
        String defaultString = DEFAULT_COMPLEX_ACTING_PARAMETER.getStringParam();
        List<String> defaultList = DEFAULT_COMPLEX_ACTING_PARAMETER.getListParam();
        Map<String, String> defaultMap = DEFAULT_COMPLEX_ACTING_PARAMETER.getMapParam();
        InnerPojo defaultInnerPojo = DEFAULT_COMPLEX_ACTING_PARAMETER.getInnerPojoParam();
        List<InnerPojo> defaultComplexList = DEFAULT_COMPLEX_ACTING_PARAMETER.getComplexListParam();
        Map<String, InnerPojo> defaultComplexMap = DEFAULT_COMPLEX_ACTING_PARAMETER.getComplexMapParam();
        ComplexActingParameter originalComplexActingParameter = new ComplexActingParameter(defaultInt, defaultString, defaultList, defaultMap, defaultInnerPojo, defaultComplexList, defaultComplexMap);
        newValueConsumer.accept((Object)originalComplexActingParameter);
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setIntParam(1));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setStringParam("one"));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setListParam(Arrays.asList("one", "two", "four")));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setMapParam((Map<String, String>)ImmutableMap.of((Object)"2", (Object)"two", (Object)"3", (Object)"three")));
        InnerPojo innerPojoChangedInt = new InnerPojo(1, defaultString, defaultList, defaultMap);
        InnerPojo innerPojoChangedString = new InnerPojo(defaultInt, "one", defaultList, defaultMap);
        InnerPojo innerPojoChangedList = new InnerPojo(defaultInt, defaultString, Arrays.asList("one", "two", "four"), defaultMap);
        InnerPojo innerPojoChangedMap = new InnerPojo(defaultInt, defaultString, defaultList, (Map<String, String>)ImmutableMap.of((Object)"0", (Object)"two", (Object)"1", (Object)"three"));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedInt));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedString));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedList));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedMap));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedInt)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedString)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedList)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedMap)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedInt)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedString)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedList)));
        newValueConsumer.accept((Object)originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedMap)));
    }

    private static ParameterValue declareInnerPojo(InnerPojo innerPojo) {
        ParameterListValue.Builder listBuilder = ParameterListValue.builder();
        innerPojo.getListParam().forEach(arg_0 -> ((ParameterListValue.Builder)listBuilder).withValue(arg_0));
        ParameterObjectValue.Builder mapBuilder = ParameterObjectValue.builder();
        innerPojo.getMapParam().forEach((arg_0, arg_1) -> ((ParameterObjectValue.Builder)mapBuilder).withParameter(arg_0, arg_1));
        return ParameterObjectValue.builder().ofType(InnerPojo.class.getName()).withParameter("intParam", Integer.toString(innerPojo.getIntParam())).withParameter("stringParam", innerPojo.getStringParam()).withParameter("listParam", (ParameterValue)listBuilder.build()).withParameter("mapParam", (ParameterValue)mapBuilder.build()).build();
    }

    static {
        boolean defaultInt = false;
        String defaultString = "zero";
        List<String> defaultList = Arrays.asList("one", "two", "three");
        ImmutableMap defaultMap = ImmutableMap.of((Object)"0", (Object)"zero", (Object)"1", (Object)"one");
        InnerPojo innerPojo = new InnerPojo(0, "zero", defaultList, (Map<String, String>)defaultMap);
        DEFAULT_COMPLEX_ACTING_PARAMETER = new ComplexActingParameter(0, "zero", defaultList, (Map<String, String>)defaultMap, innerPojo, Collections.singletonList(innerPojo), (Map<String, InnerPojo>)ImmutableMap.of((Object)"zero", (Object)innerPojo));
    }
}

