/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.utils.Utils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.tck.junit4.AbstractMuleTestCase;

@ExtendWith(value={MockitoExtension.class})
class InjectParamsFromContextServiceMethodInvokerTestCase
extends AbstractMuleTestCase {
    @Mock
    private Registry registry;
    @Mock
    private MuleContext muleContext;
    private InjectParamsFromContextServiceMethodInvoker injectParamsFromContextServiceMethodInvoker;
    private Method method;

    InjectParamsFromContextServiceMethodInvokerTestCase() {
    }

    @BeforeEach
    public void setUp() throws NoSuchMethodException {
        this.injectParamsFromContextServiceMethodInvoker = new InjectParamsFromContextServiceMethodInvoker(this.registry);
        this.method = Utils.BaseService.class.getMethod("augmented", new Class[0]);
        Utils.augmentedParam = null;
    }

    @Test
    void notAugmentedInvocation() throws Throwable {
        Utils.BasicService service = new Utils.BasicService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void augmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AugmentedSubclassMethodService service = new Utils.AugmentedSubclassMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void augmentedSubclassOverridesInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AugmentedSubclassOverridesMethodService service = new Utils.AugmentedSubclassOverridesMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void namedAugmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupByName("_muleContext")).thenReturn(Optional.of(this.muleContext));
        Utils.NamedAugmentedMethodService service = new Utils.NamedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void invalidNamedAugmentedInvocation() throws Throwable {
        Utils.InvalidNamedAugmentedMethodService service = new Utils.InvalidNamedAugmentedMethodService();
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", this.method.getName(), service.toString())));
    }

    @Test
    void hiddenAugmentedInvocation() throws Throwable {
        Utils.HiddenAugmentedMethodService service = new Utils.HiddenAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(Integer.TYPE)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void overloadedAugmentedInvocation2() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        List<Method> methods = Arrays.asList(Utils.OverloadedAugmentedMethodService.class.getMethods());
        Optional<Method> method = methods.stream().filter(m -> m.getName().equals("augmented") && m.getParameterCount() == 1 && !m.getParameters()[0].getName().contains("context")).findFirst();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method.get(), new Object[]{1});
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)this.muleContext));
    }

    @Test
    void ambiguousAugmentedInvocation() throws Throwable {
        Mockito.when((Object)this.registry.lookupAllByType(MuleContext.class)).thenReturn(Collections.singleton(this.muleContext));
        Utils.AmbiguousAugmentedMethodService service = new Utils.AmbiguousAugmentedMethodService();
        IllegalDependencyInjectionException thrown = (IllegalDependencyInjectionException)Assert.assertThrows(IllegalDependencyInjectionException.class, () -> this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)String.format("More than one invocation candidate for method '%s' in service '%s'", this.method.getName(), service.toString())));
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    void invalidAugmentedInvocation() throws Throwable {
        Utils.InvalidAugmentedMethodService service = new Utils.InvalidAugmentedMethodService();
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, this.method, null);
        MatcherAssert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }
}

