/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import io.qameta.allure.Description;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class QueueManagerInjectTestCase
extends AbstractMuleContextTestCase {
    @Test
    @Description(value="Tests that injecting either new or old api is correct")
    public void injectQueueManager() throws Exception {
        QueueManager mockNewQM = (QueueManager)Mockito.mock(QueueManager.class);
        org.mule.runtime.core.api.util.queue.QueueManager mockOldQM = (org.mule.runtime.core.api.util.queue.QueueManager)Mockito.mock(org.mule.runtime.core.api.util.queue.QueueManager.class);
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"_muleApiQueueManager", (Object)mockNewQM);
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"_muleQueueManager", (Object)mockOldQM);
        QueueManagerConsumer consumer = new QueueManagerConsumer();
        muleContext.getInjector().inject((Object)consumer);
        MatcherAssert.assertThat((Object)consumer.getNewApiQueueManager(), (Matcher)Matchers.is((Object)mockNewQM));
        MatcherAssert.assertThat((Object)consumer.getOldCoreApiQueueManager(), (Matcher)Matchers.is((Object)mockOldQM));
    }

    public static class QueueManagerConsumer {
        private QueueManager newApiQueueManager;
        private org.mule.runtime.core.api.util.queue.QueueManager oldCoreApiQueueManager;

        public QueueManager getNewApiQueueManager() {
            return this.newApiQueueManager;
        }

        public org.mule.runtime.core.api.util.queue.QueueManager getOldCoreApiQueueManager() {
            return this.oldCoreApiQueueManager;
        }

        @Inject
        @Named(value="_muleApiQueueManager")
        public void setNewQueueManager(QueueManager queueManager) {
            this.newApiQueueManager = queueManager;
        }

        @Inject
        @Named(value="_muleQueueManager")
        public void setOldQueueManager(org.mule.runtime.core.api.util.queue.QueueManager queueManager) {
            this.oldCoreApiQueueManager = queueManager;
        }
    }
}

