/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceMethodInvoker;
import org.mule.runtime.config.utils.Utils;
import org.mule.runtime.config.utils.UtilsJavax;
import org.mule.tck.junit4.AbstractMuleTestCase;

@ExtendWith(value={MockitoExtension.class})
class InjectParamsFromContextServiceMethodInvokerCacheTestCase
extends AbstractMuleTestCase {
    @Mock
    private Registry registry;
    private InjectParamsFromContextServiceMethodInvoker injectParamsFromContextServiceMethodInvoker;

    InjectParamsFromContextServiceMethodInvokerCacheTestCase() {
    }

    @BeforeEach
    public void setUp() {
        this.injectParamsFromContextServiceMethodInvoker = new InjectParamsFromContextServiceMethodInvoker(this.registry);
    }

    @Test
    void lookupByNameCaching() throws Throwable {
        Mockito.when((Object)this.registry.lookupByName(ArgumentMatchers.anyString())).thenReturn(Optional.of("malaFama"));
        Utils.InvalidNamedAugmentedMethodService service = new Utils.InvalidNamedAugmentedMethodService();
        Method method = Utils.BaseService.class.getMethod("augmented", new Class[0]);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        ((Registry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)1))).lookupByName((String)ArgumentMatchers.any());
    }

    @Test
    void lookupByNameCachingJavax() throws Throwable {
        Mockito.when((Object)this.registry.lookupByName(ArgumentMatchers.anyString())).thenReturn(Optional.of("malaFama"));
        UtilsJavax.InvalidNamedAugmentedMethodService service = new UtilsJavax.InvalidNamedAugmentedMethodService();
        Method method = Utils.BaseService.class.getMethod("augmented", new Class[0]);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        ((Registry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)1))).lookupByName((String)ArgumentMatchers.any());
    }

    @Test
    void lookupAllByTypeCaching() throws Throwable {
        Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        Method method = Utils.BaseService.class.getMethod("augmented", new Class[0]);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        ((Registry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)1))).lookupAllByType((Class)ArgumentMatchers.any());
    }

    @Test
    void lookupAllByTypeCachingJavax() throws Throwable {
        UtilsJavax.AugmentedMethodService service = new UtilsJavax.AugmentedMethodService();
        Method method = UtilsJavax.BaseService.class.getMethod("augmented", new Class[0]);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        this.injectParamsFromContextServiceMethodInvoker.invoke((Object)service, method, null);
        ((Registry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.times((int)1))).lookupAllByType((Class)ArgumentMatchers.any());
    }
}

