/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import com.google.common.collect.ImmutableSet;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.context.lazy.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.model.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.el.function.MuleFunctionsBindingContextProvider;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.tck.util.MuleContextUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ResolvableType;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Component life cycle")
public abstract class AbstractLazyMuleArtifactContextTestCase
extends AbstractDslModelTestCase {
    protected LazyMuleArtifactContext lazyMuleArtifactContext;
    protected static final String MY_FLOW = "myFlow";
    @Mock(extraInterfaces={Initialisable.class, Disposable.class, Startable.class, Stoppable.class})
    protected Processor targetProcessor;
    @Mock
    private ExtensionManager extensionManager;
    @Mock
    private InternalCustomizationService customizationService;
    protected TestObjectProviderAwareBeanFactory beanFactory;

    @Before
    public void setup() throws Exception {
        MuleContext muleContext = MuleContextUtils.mockContextWithServices();
        ImmutableSet extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        Mockito.when((Object)this.extensionManager.getExtensions()).thenReturn((Object)extensions);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)muleContext.getExtensionManager()).thenReturn((Object)this.extensionManager);
        Mockito.when((Object)muleContext.getCustomizationService()).thenReturn((Object)this.customizationService);
        MuleContextUtils.registerIntoMockContext((MuleContext)muleContext, (String)"_muleRegistry", (Object)new DefaultRegistry(muleContext));
        MuleContextUtils.registerIntoMockContext((MuleContext)muleContext, (String)"core.global.binding.provider", (Object)Mockito.mock(MuleFunctionsBindingContextProvider.class));
        this.lazyMuleArtifactContext = this.createLazyMuleArtifactContextStub(muleContext);
        MuleContextUtils.registerIntoMockContext((MuleContext)muleContext, (String)MY_FLOW, (Object)new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.targetProcessor}));
        ((Initialisable)Mockito.doAnswer(a -> {
            this.onProcessorInitialization();
            return null;
        }).when((Object)((Initialisable)this.targetProcessor))).initialise();
    }

    protected abstract void onProcessorInitialization();

    private TestObjectProviderAwareBeanFactory createBeanFactoryMock(MuleContext muleContext) {
        return new TestObjectProviderAwareBeanFactory(muleContext);
    }

    @Override
    protected ExtensionModel createExtension(String name, XmlDslModel xmlDslModel, List<ConfigurationModel> configs, List<ConnectionProviderModel> connectionProviders) {
        return new ImmutableExtensionModel("extension", "", "1.0", "Mulesoft", Category.COMMUNITY, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, xmlDslModel, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private ArtifactAst loadAst(String astName, Set<ExtensionModel> extensionModels) throws IOException {
        ArtifactAstDeserializer defaultArtifactAstDeserializer = new ArtifactAstSerializerProvider().getDeserializer();
        ArtifactAst deserializedArtifactAst = defaultArtifactAstDeserializer.deserialize(((Object)((Object)this)).getClass().getResourceAsStream("/asts/" + astName + ".ast"), name -> extensionModels.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null));
        return deserializedArtifactAst;
    }

    private LazyMuleArtifactContext createLazyMuleArtifactContextStub(final MuleContext muleContext) throws IOException {
        ArtifactAst artifactAst = this.loadAst(((Object)((Object)this)).getClass().getSimpleName(), this.getExtensions(muleContext.getExtensionManager()));
        ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new DefaultComponentBuildingDefinitionRegistryFactory().create(artifactAst.dependencies(), arg_0 -> ((ArtifactAst)artifactAst).dependenciesDsl(arg_0));
        LazyMuleArtifactContext muleArtifactContext = new LazyMuleArtifactContext(muleContext, artifactAst, Optional.empty(), new BaseConfigurationComponentLocator(), new ContributedErrorTypeRepository(), new ContributedErrorTypeLocator(), Collections.emptyMap(), ArtifactType.APP, Optional.empty(), componentBuildingDefinitionRegistry, (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class), (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)){

            protected DefaultListableBeanFactory createBeanFactory() {
                AbstractLazyMuleArtifactContextTestCase.this.beanFactory = AbstractLazyMuleArtifactContextTestCase.this.createBeanFactoryMock(muleContext);
                return AbstractLazyMuleArtifactContextTestCase.this.beanFactory;
            }
        };
        muleArtifactContext.refresh();
        return muleArtifactContext;
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }

    protected static class TestObjectProviderAwareBeanFactory
    extends ObjectProviderAwareBeanFactory {
        private final MuleContext muleContext;
        private boolean beanFactoryMustThrow;
        private final Map<String, BeanDefinition> registeredBeans = new HashMap<String, BeanDefinition>();
        private final Map<String, BeanDefinition> registeredBeansByType = new HashMap<String, BeanDefinition>();

        public TestObjectProviderAwareBeanFactory(MuleContext muleContext) {
            super((BeanFactory)Mockito.mock(ListableBeanFactory.class));
            this.muleContext = muleContext;
        }

        public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
            return new String[0];
        }

        public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
            this.registeredBeans.put(beanName, beanDefinition);
            this.registeredBeansByType.put(beanDefinition.getBeanClassName(), beanDefinition);
            super.registerBeanDefinition(beanName, beanDefinition);
        }

        public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
            return this.getBean(requiredType);
        }

        public <T> T getBean(Class<T> requiredType) throws BeansException {
            if (this.beanFactoryMustThrow) {
                throw new NoSuchBeanDefinitionException(requiredType);
            }
            if (this.registeredBeans.containsKey(requiredType)) {
                return (T)Mockito.mock(requiredType);
            }
            return null;
        }

        public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
            return this.getBeanProvider(requiredType, false);
        }

        public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
            if (this.beanFactoryMustThrow) {
                throw new NoSuchBeanDefinitionException(requiredType);
            }
            final Object bean = Mockito.mock(requiredType);
            return new ObjectProvider<T>(){

                public T getObject() throws BeansException {
                    return bean;
                }
            };
        }

        public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
            if (this.beanFactoryMustThrow) {
                throw new NoSuchBeanDefinitionException(requiredType);
            }
            Object bean = null;
            try {
                bean = Mockito.mock(Class.forName(requiredType.getType().getTypeName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            final Object finalBean = bean;
            return new ObjectProvider<T>(){

                public T getObject() throws BeansException {
                    return finalBean;
                }
            };
        }

        public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType, boolean allowEagerInit) {
            return this.getBeanProvider(requiredType, false);
        }

        public Object getBean(String name, Object ... args) throws BeansException {
            return this.getBean(name);
        }

        public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
            return (T)this.registeredBeans.get(name);
        }

        public Object getBean(String name) throws BeansException {
            if (this.beanFactoryMustThrow) {
                if (this.registeredBeans.containsKey(name)) {
                    return this.registeredBeans.get(name);
                }
                throw new NoSuchBeanDefinitionException(name);
            }
            if (name.equals("_muleContext")) {
                return this.muleContext;
            }
            if (this.registeredBeans.containsKey(name)) {
                try {
                    return Mockito.mock(Class.forName(this.registeredBeans.get(name).getBeanClassName()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        public void setSerializationId(String serializationId) {
        }

        protected Map<String, Object> findAutowireCandidates(String beanName, Class<?> requiredType, DependencyDescriptor descriptor) {
            if (requiredType.equals(MuleContext.class)) {
                return Collections.singletonMap("_muleContext", this.muleContext);
            }
            if (requiredType.equals(Registry.class)) {
                return Collections.singletonMap("_registry", new DefaultRegistry(this.muleContext));
            }
            return Collections.singletonMap(beanName, Mockito.mock(requiredType));
        }

        public void setBeanFactoryMustThrow(boolean beanFactoryMustThrow) {
            this.beanFactoryMustThrow = beanFactoryMustThrow;
        }

        public boolean isRegisteredBeanDefiniion(String name) {
            return this.registeredBeans.containsKey(name);
        }

        public boolean containsBean(String name) {
            return this.registeredBeans.containsKey(name);
        }

        public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
            return false;
        }

        public String[] getAliases(String name) {
            return null;
        }
    }
}

