/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.processor;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.config.internal.dsl.processor.RetryPolicyTemplateObjectFactory;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.tck.util.MockInjector;

@ExtendWith(value={MockitoExtension.class})
class RetryPolicyTemplateObjectFactoryTestCase {
    private RetryPolicyTemplateObjectFactory factory;
    @Mock
    private RetryNotifier retryNotifier;
    @Mock
    private NotificationDispatcher notificationFirer;

    RetryPolicyTemplateObjectFactoryTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new RetryPolicyTemplateObjectFactory();
        MockInjector.injectMocksFromSuite((Object)this, (Object)this.factory);
    }

    @Test
    void setBlocking() throws Exception {
        this.factory.setBlocking(false);
        MatcherAssert.assertThat((Object)((RetryPolicyTemplate)this.factory.getObject()), (Matcher)CoreMatchers.instanceOf(AsynchronousRetryTemplate.class));
    }

    @Test
    void setCount() throws Exception {
        this.factory.setCount(Integer.valueOf(0));
        MatcherAssert.assertThat((Object)((RetryPolicyTemplate)this.factory.getObject()), (Matcher)CoreMatchers.instanceOf(NoRetryPolicyTemplate.class));
    }

    @Test
    void setFrequency() throws Exception {
        this.factory.setFrequency(Integer.valueOf(100));
        SimpleRetryPolicyTemplate result = (SimpleRetryPolicyTemplate)this.factory.getObject();
        MatcherAssert.assertThat((Object)result.getFrequency(), (Matcher)CoreMatchers.is((Object)100L));
    }

    @Test
    void setRetryNotifier() throws Exception {
        this.factory.setRetryNotifier(this.retryNotifier);
        SimpleRetryPolicyTemplate result = (SimpleRetryPolicyTemplate)this.factory.getObject();
        MatcherAssert.assertThat((Object)result.getNotifier(), (Matcher)CoreMatchers.is((Object)this.retryNotifier));
    }

    @Test
    void notificationFirerNotCalled() throws Exception {
        ((RetryPolicyTemplate)this.factory.getObject()).createRetryInstance().applyPolicy((Throwable)new IllegalArgumentException("The Crimson Capybara!"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.notificationFirer});
    }
}

