/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Logging")
@Story(value="Flow Stack")
public class BeanDefinitionFactoryRepresentationSourceLocationTestCase
extends AbstractMuleTestCase {
    @Test
    public void withFailingProcessorNoPathResolver() {
        MatcherAssert.assertThat((Object)BeanDefinitionFactory.resolveProcessorSourceLocation((ComponentMetadataAst)DefaultComponentMetadataAst.builder().setFileName("unknown").build()), (Matcher)CoreMatchers.is((Object)"unknown:-1"));
    }

    @Test
    public void withFailingProcessorPathResolver() {
        MatcherAssert.assertThat((Object)BeanDefinitionFactory.resolveProcessorSourceLocation((ComponentMetadataAst)DefaultComponentMetadataAst.builder().setFileName("muleApp.xml").setStartLine(10).build()), (Matcher)CoreMatchers.is((Object)"muleApp.xml:10"));
    }

    @Test
    public void withFailingProcessorNotPathResolver() {
        MatcherAssert.assertThat((Object)BeanDefinitionFactory.resolveProcessorSourceLocation((ComponentMetadataAst)DefaultComponentMetadataAst.builder().setFileName("unknown").build()), (Matcher)CoreMatchers.is((Object)"unknown:-1"));
    }

    @Test
    public void withAnnotatedFailingProcessorNoPathResolver() {
        MatcherAssert.assertThat((Object)BeanDefinitionFactory.resolveProcessorSourceLocation((ComponentMetadataAst)DefaultComponentMetadataAst.builder().setFileName("muleApp.xml").setStartLine(10).putDocAttribute(Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart(), "Mock Component").build()), (Matcher)CoreMatchers.is((Object)"muleApp.xml:10"));
    }

    @Test
    public void withAnnotatedFailingProcessorPathResolver() {
        MatcherAssert.assertThat((Object)BeanDefinitionFactory.resolveProcessorSourceLocation((ComponentMetadataAst)DefaultComponentMetadataAst.builder().setFileName("muleApp.xml").setStartLine(10).putDocAttribute(Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart(), "Mock Component").build()), (Matcher)CoreMatchers.is((Object)"muleApp.xml:10"));
    }

    @Test
    public void withAnnotatedFailingProcessorNotPathResolver() {
        MatcherAssert.assertThat((Object)BeanDefinitionFactory.resolveProcessorSourceLocation((ComponentMetadataAst)DefaultComponentMetadataAst.builder().setFileName("muleApp.xml").setStartLine(10).putDocAttribute(Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart(), "Mock Component").build()), (Matcher)CoreMatchers.is((Object)"muleApp.xml:10"));
    }
}

