/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.config.internal.lazy.LazyExpressionLanguageAdaptor;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.util.func.CheckedSupplier;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@ExtendWith(value={MockitoExtension.class})
@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Expression Language")})
class LazyExpressionLanguageAdaptorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private CheckedSupplier<ExtendedExpressionLanguageAdaptor> supplier;
    @Mock
    private BindingContext b1;
    @Mock
    private BindingContext b2;
    @Mock(extraInterfaces={Disposable.class})
    private ExtendedExpressionLanguageAdaptor delegate;
    private LazyExpressionLanguageAdaptor lazyAdaptor;
    private final Latch latch = new Latch();

    LazyExpressionLanguageAdaptorTestCase() {
    }

    @BeforeEach
    public void before() {
        this.lazyAdaptor = new LazyExpressionLanguageAdaptor(this.supplier);
        Mockito.when((Object)((ExtendedExpressionLanguageAdaptor)this.supplier.get())).thenReturn((Object)this.delegate);
    }

    @Test
    void supplierInvokedOnlyOnce() throws Exception {
        Thread t1 = new Thread(() -> {
            try {
                this.latch.await();
                this.evaluate();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Thread t2 = new Thread(() -> {
            this.latch.countDown();
            this.evaluate();
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    @Test
    @Issue(value="W-11745207")
    void delegateIsDisposedWhenAdaptorDisposed() {
        this.evaluate();
        this.lazyAdaptor.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.delegate))).dispose();
    }

    @Test
    void globalBindingsDeferred() throws Exception {
        this.lazyAdaptor.addGlobalBindings(this.b1);
        this.lazyAdaptor.addGlobalBindings(this.b2);
        ((CheckedSupplier)Mockito.verify(this.supplier, (VerificationMode)Mockito.never())).get();
        this.evaluate();
        ((ExtendedExpressionLanguageAdaptor)Mockito.verify((Object)this.delegate)).addGlobalBindings(this.b1);
        ((ExtendedExpressionLanguageAdaptor)Mockito.verify((Object)this.delegate)).addGlobalBindings(this.b2);
    }

    @Test
    void globalBIndingsNotDeferred() {
        this.evaluate();
        this.lazyAdaptor.addGlobalBindings(this.b1);
        this.lazyAdaptor.addGlobalBindings(this.b2);
        ((ExtendedExpressionLanguageAdaptor)Mockito.verify((Object)this.delegate)).addGlobalBindings(this.b1);
        ((ExtendedExpressionLanguageAdaptor)Mockito.verify((Object)this.delegate)).addGlobalBindings(this.b2);
    }

    private void evaluate() {
        String expression = "#[as]";
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        this.lazyAdaptor.evaluate(expression, event, this.b1);
        ((CheckedSupplier)Mockito.verify(this.supplier)).get();
        ((ExtendedExpressionLanguageAdaptor)Mockito.verify((Object)this.delegate)).evaluate(expression, event, this.b1);
    }
}

