/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;

class ObjectReferencePopulator {
    private static final Map<Class<?>, String> OBJECT_REFERENCES = ObjectReferencePopulator.createObjectReferencesMap();

    ObjectReferencePopulator() {
    }

    private static Map<Class<?>, String> createObjectReferencesMap() {
        HashMap<Class<PlatformManagedOAuthHandler>, String> map = new HashMap<Class<PlatformManagedOAuthHandler>, String>();
        map.put(Registry.class, "_muleRegistry");
        map.put(MuleContext.class, "_muleContext");
        map.put(TimeSupplier.class, "_muleTimeSupplier");
        map.put(ExtensionManager.class, "_muleExtensionManager");
        map.put(PolicyManager.class, "_mulePolicyManager");
        map.put(PolicyProvider.class, "_mulePolicyProvider");
        map.put(AuthorizationCodeOAuthHandler.class, "extensions.authCode.handler");
        map.put(ClientCredentialsOAuthHandler.class, "extensions.clientCredentials.handler");
        map.put(PlatformManagedOAuthHandler.class, "extensions.ocs.handler");
        return Collections.unmodifiableMap(map);
    }

    public void populate(Class<?> type, Consumer<String> typeIdConsumer) {
        String referenceName = OBJECT_REFERENCES.get(type);
        if (referenceName == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not determine reference object of type: " + type.getName())));
        }
        typeIdConsumer.accept(referenceName);
    }
}

