/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.config.dsl.model.internal.config;

import static org.mule.tck.junit4.matcher.IsEqualIgnoringLineBreaks.equalToIgnoringLineBreaks;
import static org.mule.test.allure.AllureConstants.ConfigurationProperties.CONFIGURATION_PROPERTIES;
import static org.mule.test.allure.AllureConstants.ConfigurationProperties.ComponentConfigurationAttributesStory.CONFIGURATION_PROPERTIES_RESOLVER_STORY;

import static java.lang.Thread.currentThread;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import static org.junit.jupiter.api.Assertions.assertThrows;

import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.properties.api.ResourceProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(CONFIGURATION_PROPERTIES)
@Story(CONFIGURATION_PROPERTIES_RESOLVER_STORY)
public class FileConfigurationPropertiesProviderTestCase extends AbstractMuleTestCase {

  private ConfigurationPropertiesResolver resolver;

  @BeforeEach
  public void createResolver() {
    ResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(currentThread().getContextClassLoader());
    resolver = new ConfigurationPropertiesHierarchyBuilder().withPropertiesFile(externalResourceProvider).build();
  }

  @Test
  void fileIsResolved() {
    assertThat((String) resolver.resolveValue("${file::dummy.xml}"),
               is(equalToIgnoringLineBreaks("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foo/>\n")));
  }

  @Test
  void fileDoesNotExist() {
    var thrown = assertThrows(Exception.class, () -> resolver.resolveValue("${file::non-existing-file}"));
    assertThat(thrown.getMessage(), is("Couldn't find configuration property value for key ${file::non-existing-file}"));
  }
}
