/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.context.FlowClassifierFactory;
import org.mule.runtime.core.internal.logger.CustomLogger;
import org.mule.runtime.core.internal.management.stats.FlowClassifier;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLogger;

public class FlowClassifierFactoryTestCase
extends AbstractMuleTestCase {
    private static final String APIKIT_EXTENSION_NAME = "APIKit";
    private static final String SOAPKIT_EXTENSION_NAME = "APIKit for SOAP";
    private CustomLogger logger;
    private Logger originalDelegate;
    private ArtifactAst artifactAst;
    private ArtifactAst parentArtifactAst;
    private ComponentAst apiKitConfig;
    private ComponentAst soapKitConfig;
    private ComponentAst parentApiKitConfig;
    private ComponentAst parentSoapKitConfig;

    @Before
    public void setupLogger() {
        SubstituteLogger substituteLogger = (SubstituteLogger)LoggerFactory.getLogger(FlowClassifierFactory.class);
        this.originalDelegate = substituteLogger.delegate();
        this.logger = new CustomLogger(this.originalDelegate, FlowClassifierFactory.class.getName());
        substituteLogger.setDelegate((Logger)this.logger);
    }

    @After
    public void restoreLogger() {
        SubstituteLogger substituteLogger = (SubstituteLogger)LoggerFactory.getLogger(FlowClassifierFactory.class);
        substituteLogger.setDelegate(this.originalDelegate);
    }

    @Before
    public void setUp() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.parentArtifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.soapKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.parentApiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.parentSoapKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        this.setupConfigMock(this.soapKitConfig, "soapkit-config", SOAPKIT_EXTENSION_NAME);
        this.setupConfigMock(this.parentApiKitConfig, "parent-api-config", APIKIT_EXTENSION_NAME);
        this.setupConfigMock(this.parentSoapKitConfig, "parent-soapkit-config", SOAPKIT_EXTENSION_NAME);
        ComponentAst flowMapping = this.createFlowMappingMock((Either<String, Object>)Either.right((Object)"mapped-flow"));
        this.setupFlowMappingsParameter(this.apiKitConfig, (Either<String, Object>)Either.right(Collections.singletonList(flowMapping)));
        ComponentAst parentFlowMapping = this.createFlowMappingMock((Either<String, Object>)Either.right((Object)"parent-mapped-flow"));
        this.setupFlowMappingsParameter(this.parentApiKitConfig, (Either<String, Object>)Either.right(Collections.singletonList(parentFlowMapping)));
    }

    private FlowClassifier createClassifier(List<ComponentAst> components, List<ComponentAst> parentComponents) {
        Mockito.when((Object)this.artifactAst.topLevelComponentsStream()).thenAnswer(invocation -> components.stream());
        Mockito.when((Object)this.artifactAst.getParent()).thenReturn(Optional.of(this.parentArtifactAst));
        Mockito.when((Object)this.parentArtifactAst.topLevelComponentsStream()).thenAnswer(invocation -> parentComponents.stream());
        return new FlowClassifierFactory(this.artifactAst).create();
    }

    @Test
    public void testGenericFlow() {
        FlowClassifier classifier = this.createClassifier(Collections.emptyList(), Collections.emptyList());
        MatcherAssert.assertThat((String)"generic-flow", (Object)classifier.getFlowType("generic-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    public void testApiKitFlow() {
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
    }

    @Test
    public void testSoapKitFlow() {
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.soapKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"flow:\\soapkit-config", (Object)classifier.getFlowType("flow:\\soapkit-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.SOAPKIT));
    }

    @Test
    public void testMultipleConfigs() {
        FlowClassifier classifier = this.createClassifier(Arrays.asList(this.apiKitConfig, this.soapKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:\\soapkit-config", (Object)classifier.getFlowType("flow:\\soapkit-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.SOAPKIT));
        MatcherAssert.assertThat((String)"generic-flow", (Object)classifier.getFlowType("generic-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    public void testApiKitFlowWithNonMatchingConfig() {
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"flow:non-matching-config", (Object)classifier.getFlowType("flow:non-matching-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    public void testSoapKitFlowWithNonMatchingConfig() {
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.soapKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"flow:\\non-matching-config", (Object)classifier.getFlowType("flow:\\non-matching-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    public void testMultipleConfigsWithNonMatchingFlows() {
        FlowClassifier classifier = this.createClassifier(Arrays.asList(this.apiKitConfig, this.soapKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"flow:non-matching-api-config", (Object)classifier.getFlowType("flow:non-matching-api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:\\non-matching-soap-config", (Object)classifier.getFlowType("flow:\\non-matching-soap-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    public void testApiKitFlowFromParent() {
        FlowClassifier classifier = this.createClassifier(Collections.emptyList(), Collections.singletonList(this.parentApiKitConfig));
        MatcherAssert.assertThat((String)"parent-mapped-flow", (Object)classifier.getFlowType("parent-mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:parent-api-config", (Object)classifier.getFlowType("flow:parent-api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
    }

    @Test
    public void testSoapKitFlowFromParent() {
        FlowClassifier classifier = this.createClassifier(Collections.emptyList(), Collections.singletonList(this.parentSoapKitConfig));
        MatcherAssert.assertThat((String)"flow:\\parent-soapkit-config", (Object)classifier.getFlowType("flow:\\parent-soapkit-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.SOAPKIT));
    }

    @Test
    public void testMultipleConfigsFromParent() {
        FlowClassifier classifier = this.createClassifier(Collections.emptyList(), Arrays.asList(this.parentApiKitConfig, this.parentSoapKitConfig));
        MatcherAssert.assertThat((String)"parent-mapped-flow", (Object)classifier.getFlowType("parent-mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:parent-api-config", (Object)classifier.getFlowType("flow:parent-api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:\\parent-soapkit-config", (Object)classifier.getFlowType("flow:\\parent-soapkit-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.SOAPKIT));
        MatcherAssert.assertThat((String)"generic-flow", (Object)classifier.getFlowType("generic-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    public void testConfigsFromBothMainAndParent() {
        FlowClassifier classifier = this.createClassifier(Arrays.asList(this.apiKitConfig, this.soapKitConfig), Arrays.asList(this.parentApiKitConfig, this.parentSoapKitConfig));
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:\\soapkit-config", (Object)classifier.getFlowType("flow:\\soapkit-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.SOAPKIT));
        MatcherAssert.assertThat((String)"parent-mapped-flow", (Object)classifier.getFlowType("parent-mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:parent-api-config", (Object)classifier.getFlowType("flow:parent-api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        MatcherAssert.assertThat((String)"flow:\\parent-soapkit-config", (Object)classifier.getFlowType("flow:\\parent-soapkit-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.SOAPKIT));
        MatcherAssert.assertThat((String)"generic-flow", (Object)classifier.getFlowType("generic-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
    }

    @Test
    @Issue(value="W-19004884")
    @Description(value="The ApiKit config doesn't have any value for the optional flow-mappings parameter, it must not fail nor log")
    public void testApiKitNoFlowMappingsParameterPresent() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        this.setupFlowMappingsParameter(this.apiKitConfig, (Either<String, Object>)Either.empty());
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        this.assertOnLog((Matcher<? super List<String>>)IsEmptyCollection.empty());
    }

    @Test
    @Issue(value="W-19004884")
    @Description(value="In this test, the ApiKit config model doesn't even have the flow-mappings parameter, something changed in the model, it must not fail, but log")
    public void testApiKitNoFlowMappingsParameter() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        this.assertOnLog((Matcher<? super List<String>>)Matchers.containsInAnyOrder((Object[])new String[]{"Component `api-config` is a config from `APIKit` but has no flow-mappings parameter, the model must have changed incompatibly"}));
    }

    @Test
    @Issue(value="W-19004884")
    @Description(value="The ApiKit config does have a value for the optional flow-mappings parameter but it is not iterable, it must not fail, but log")
    public void testApiKitFlowMappingsNotIterable() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        this.setupFlowMappingsParameter(this.apiKitConfig, (Either<String, Object>)Either.right((Object)"some unexpected value"));
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        this.assertOnLog((Matcher<? super List<String>>)Matchers.containsInAnyOrder((Object[])new String[]{"Component `api-config` has flow mappings but they are not iterable, the model `APIKit` must have changed incompatibly"}));
    }

    @Test
    @Issue(value="W-19004884")
    @Description(value="The ApiKit config does have a value for the optional flow-mappings parameter but it is not an iterable of ComponentAst, it must not fail, but log")
    public void testApiKitFlowMappingsIterableButNotComponentAst() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        this.setupFlowMappingsParameter(this.apiKitConfig, (Either<String, Object>)Either.right(Arrays.asList(null, "some unexpected value")));
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        Matcher matcher = Matchers.is((Object)"Component `api-config` has a flow-mapping that is not of the expected type, the model `APIKit` must have changed incompatibly");
        this.assertOnLog((Matcher<? super List<String>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{matcher, matcher}));
    }

    @Test
    @Issue(value="W-19004884")
    @Description(value="Some flow-mappings in the ApiKit config don't have a value for the required parameter `flow-ref`, it must not fail nor log")
    public void testApiKitFlowMappingsNoFlowRef() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        ComponentAst flowMapping = this.createFlowMappingMock((Either<String, Object>)Either.empty());
        this.setupFlowMappingsParameter(this.apiKitConfig, (Either<String, Object>)Either.right(Collections.singletonList(flowMapping)));
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        this.assertOnLog((Matcher<? super List<String>>)Matchers.containsInAnyOrder((Object[])new String[]{"Component `api-config` has a flow-mapping with no flow-ref which is supposed to be a required parameter, the model `APIKit` must have changed incompatibly"}));
    }

    @Test
    @Issue(value="W-19004884")
    @Description(value="Some flow-mappings in the ApiKit config have a `flow-ref` that is not a String, it must not fail, but log")
    public void testApiKitFlowMappingsInvalidFlowRefType() {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.apiKitConfig = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.setupConfigMock(this.apiKitConfig, "api-config", APIKIT_EXTENSION_NAME);
        ComponentAst flowMapping = this.createFlowMappingMock((Either<String, Object>)Either.right((Object)1));
        this.setupFlowMappingsParameter(this.apiKitConfig, (Either<String, Object>)Either.right(Collections.singletonList(flowMapping)));
        FlowClassifier classifier = this.createClassifier(Collections.singletonList(this.apiKitConfig), Collections.emptyList());
        MatcherAssert.assertThat((String)"mapped-flow", (Object)classifier.getFlowType("mapped-flow"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.GENERIC));
        MatcherAssert.assertThat((String)"flow:api-config", (Object)classifier.getFlowType("flow:api-config"), (Matcher)Matchers.is((Object)FlowClassifier.FlowType.APIKIT));
        this.assertOnLog((Matcher<? super List<String>>)Matchers.containsInAnyOrder((Object[])new String[]{"Component `api-config` has a flow-mapping with a flow-ref that is not a String value, the model `APIKit` must have changed incompatibly"}));
    }

    private void setupConfigMock(ComponentAst config, String configId, String extensionName) {
        Mockito.when((Object)config.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)config.getComponentId()).thenReturn(Optional.of(configId));
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)extensionModel.getName()).thenReturn((Object)extensionName);
        Mockito.when((Object)config.getExtensionModel()).thenReturn((Object)extensionModel);
        ConfigurationModel configModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)configModel.getName()).thenReturn((Object)"config");
        Mockito.when((Object)config.getModel(ConfigurationModel.class)).thenReturn(Optional.of(configModel));
    }

    private void setupFlowMappingsParameter(ComponentAst config, Either<String, Object> flowMappingsParameterValue) {
        ComponentParameterAst flowMappingsParameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)flowMappingsParameter.getValue()).thenReturn(flowMappingsParameterValue);
        Mockito.when((Object)config.getParameter("General", "flowMappings")).thenReturn((Object)flowMappingsParameter);
    }

    private ComponentAst createFlowMappingMock(Either<String, Object> flowMappingsParameterValue) {
        ComponentAst flowMapping = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst parentFlowRefParameter = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)parentFlowRefParameter.getValue()).thenReturn(flowMappingsParameterValue);
        Mockito.when((Object)flowMapping.getParameter("FlowMapping", "flow-ref")).thenReturn((Object)parentFlowRefParameter);
        return flowMapping;
    }

    private void assertOnLog(Matcher<? super List<String>> matcher) {
        MatcherAssert.assertThat((Object)this.logger.getMessages(), matcher);
    }
}

