/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.config.internal.context.service;

import static java.util.Optional.of;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.utils.Utils;
import org.mule.runtime.config.utils.Utils.AugmentedMethodService;
import org.mule.runtime.config.utils.Utils.BaseService;
import org.mule.runtime.config.utils.UtilsJavax;
import org.mule.tck.junit4.AbstractMuleTestCase;

import java.lang.reflect.Method;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
class InjectParamsFromContextServiceMethodInvokerCacheTestCase extends AbstractMuleTestCase {

  @Mock
  private Registry registry;

  private InjectParamsFromContextServiceMethodInvoker injectParamsFromContextServiceMethodInvoker;

  @BeforeEach
  public void setUp() {
    injectParamsFromContextServiceMethodInvoker = new InjectParamsFromContextServiceMethodInvoker(registry);
  }

  @Test
  void lookupByNameCaching() throws Throwable {
    when(registry.lookupByName(anyString())).thenReturn(of("malaFama"));
    BaseService service = new Utils.InvalidNamedAugmentedMethodService();
    Method method = BaseService.class.getMethod("augmented");
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);

    verify(registry, times(1)).lookupByName(any());
  }

  @Test
  void lookupByNameCachingJavax() throws Throwable {
    when(registry.lookupByName(anyString())).thenReturn(of("malaFama"));
    UtilsJavax.BaseService service = new UtilsJavax.InvalidNamedAugmentedMethodService();
    Method method = BaseService.class.getMethod("augmented");
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);

    verify(registry, times(1)).lookupByName(any());
  }

  @Test
  void lookupAllByTypeCaching() throws Throwable {
    BaseService service = new AugmentedMethodService();
    Method method = BaseService.class.getMethod("augmented");
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);

    verify(registry, times(1)).lookupAllByType(any());
  }

  @Test
  void lookupAllByTypeCachingJavax() throws Throwable {
    UtilsJavax.BaseService service = new UtilsJavax.AugmentedMethodService();
    Method method = UtilsJavax.BaseService.class.getMethod("augmented");
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);
    injectParamsFromContextServiceMethodInvoker.invoke(service, method, null);

    verify(registry, times(1)).lookupAllByType(any());
  }

}
